/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.base.ConfigProvider;
import com.fr.file.BaseClusterHelper;
import com.fr.file.ClusterService;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.ManagerFactory;
import com.fr.general.http.HttpClient;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClusterConfigManager
extends XMLFileManager {
    private static ClusterConfigManager clusterConfigManager = null;
    private boolean useCluster = false;
    private boolean useShare = false;
    private boolean sticky = false;
    private boolean encode = false;
    private String publicURL;
    private List<ClusterService> serviceList = new ArrayList<ClusterService>();

    public static ClusterConfigManager getInstance() {
        if (clusterConfigManager == null) {
            clusterConfigManager = new ClusterConfigManager();
            clusterConfigManager.readXMLFile();
            if (ClusterConfigManager.isClusterMember()) {
                ClusterConfigManager.waitForMainService();
            }
        }
        return clusterConfigManager;
    }

    private static boolean isOldCluster(ClusterService clusterService, ClusterService clusterService2) {
        return clusterService == null || clusterService2 == null || !clusterService2.isMain();
    }

    private static boolean isClusterMember() {
        ClusterService clusterService;
        ClusterService clusterService2 = clusterConfigManager.resolveSelfServices();
        if (ClusterConfigManager.isOldCluster(clusterService2, clusterService = clusterConfigManager.resolveMainServices())) {
            return false;
        }
        return !clusterService2.isMain();
    }

    public static void waitForMainService() {
        ClusterService clusterService = clusterConfigManager.resolveMainServices();
        String string = ClusterConfigManager.getDefaultUrl(clusterService);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("op", "schedule_cluster");
        hashMap.put("cmd", "start_manager");
        while (new HttpClient(string, hashMap).getResponseCode() != 200) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                FRLogger.getLogger().error(interruptedException.getMessage());
            }
        }
        HttpClient httpClient = new HttpClient(string, hashMap);
        String string2 = httpClient.getResponseText();
        if (!Boolean.valueOf(string2).booleanValue()) {
            FRLogger.getLogger().error("Server Connect Failed : " + string2);
        }
    }

    public static String getServiceURL(String string) {
        ClusterService clusterService = ClusterConfigManager.getInstance().getService(string);
        return clusterService == null ? "" : ClusterConfigManager.getDefaultUrl(clusterService);
    }

    public static String getDefaultUrl(ClusterService clusterService) {
        ConfigProvider configProvider = ManagerFactory.getConfigProvider();
        String string = configProvider == null ? "ReportServer" : configProvider.getServletMapping();
        return "http://" + clusterService.getIp() + ":" + clusterService.getPort() + "/" + clusterService.getWebAppName() + "/" + string;
    }

    private ClusterConfigManager() {
    }

    public String fileName() {
        return "cluster.xml";
    }

    public ClusterService getService(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            if (!ComparatorUtils.equals(string, this.serviceList.get(i2).getServiceName())) continue;
            return this.serviceList.get(i2);
        }
        return null;
    }

    public String[] getAllServiceName() {
        String[] stringArray = new String[this.serviceList.size()];
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            ClusterService clusterService = this.serviceList.get(i2);
            stringArray[i2] = clusterService.getServiceName();
        }
        return stringArray;
    }

    public List getOtherServices(ClusterService clusterService) {
        ArrayList<ClusterService> arrayList = new ArrayList<ClusterService>();
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            if (clusterService != null && ComparatorUtils.equals(clusterService, this.serviceList.get(i2))) continue;
            arrayList.add(this.serviceList.get(i2));
        }
        return arrayList;
    }

    public ClusterService resolveSelfServices() {
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            if (!this.serviceList.get(i2).isSelf()) continue;
            return this.serviceList.get(i2);
        }
        return this.findSelfIndexByIpAndService();
    }

    private ClusterService findSelfIndexByIpAndService() {
        try {
            String string = BaseClusterHelper.getLocalIP();
            ArrayList<ClusterService> arrayList = new ArrayList<ClusterService>();
            int n2 = this.serviceList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ClusterService clusterService = this.serviceList.get(i2);
                if (!ComparatorUtils.equals(string, clusterService.getIp())) continue;
                arrayList.add(clusterService);
                if (!this.matchServiceName(clusterService.getServiceName())) continue;
                return clusterService;
            }
            if (arrayList.size() == 1) {
                return (ClusterService)arrayList.get(0);
            }
            return null;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return null;
        }
    }

    private boolean matchServiceName(String string) throws IOException {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        String string2 = GeneralContext.getEnvProvider().getPath();
        File file = new File(string2);
        return file.exists() ? file.getAbsolutePath().indexOf(string) != -1 : false;
    }

    public ClusterService resolveMainServices() {
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            if (!this.serviceList.get(i2).isMain()) continue;
            return this.serviceList.get(i2);
        }
        return this.serviceList.size() > 0 ? this.serviceList.get(0) : null;
    }

    public ClusterService resolveSelfServicesByIPAndPort(String string, String string2) {
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            ClusterService clusterService = this.serviceList.get(i2);
            if (!ComparatorUtils.equals(string, clusterService.getIp()) || !ComparatorUtils.equals(string2, clusterService.getPort())) continue;
            return clusterService;
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            if (this.serviceList == null) {
                this.serviceList = new ArrayList<ClusterService>();
            } else {
                this.serviceList.clear();
            }
            this.setUseCluster(xMLableReader.getAttrAsBoolean("useCluster", false));
            this.setUseShare(xMLableReader.getAttrAsBoolean("useShare", false));
            this.setSticky(xMLableReader.getAttrAsBoolean("sticky", false));
            this.setEncode(xMLableReader.getAttrAsBoolean("encode", false));
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("XMLVersion")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    xMLableReader.setXmlVersionByString(string2);
                }
            } else if ("ClusterService".equals(string)) {
                ClusterService clusterService = new ClusterService();
                xMLableReader.readXMLObject(clusterService);
                this.serviceList.add(clusterService);
            } else if ("PublicURL".equals(string)) {
                this.publicURL = xMLableReader.getElementValue();
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ClusterConfig").attr("useCluster", this.useCluster).attr("useShare", this.useShare).attr("sticky", this.sticky).attr("encode", this.encode);
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            this.serviceList.get(i2).writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean isUseCluster() {
        return this.useCluster;
    }

    public void setUseCluster(boolean bl) {
        this.useCluster = bl;
    }

    public boolean isUseShare() {
        return this.useShare;
    }

    public void setUseShare(boolean bl) {
        this.useShare = bl;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public boolean isEncode() {
        return this.encode;
    }

    public void setEncode(boolean bl) {
        this.encode = bl;
    }

    public String getPublicURL() {
        if (StringUtils.isEmpty(this.publicURL)) {
            return BaseClusterHelper.getMainServiceIP();
        }
        return this.publicURL;
    }

    public void setPublicURL(String string) {
        this.publicURL = string;
    }

    public void readFromInputStream(InputStream inputStream) throws Exception {
        ClusterConfigManager clusterConfigManager = new ClusterConfigManager();
        XMLTools.readInputStreamXML(clusterConfigManager, inputStream);
        ClusterConfigManager.clusterConfigManager = clusterConfigManager;
    }
}

