/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dav;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.base.FeedBackInfo;
import com.fr.base.ModifiedTable;
import com.fr.base.Parameter;
import com.fr.base.StoreProcedureParameter;
import com.fr.base.TableData;
import com.fr.data.TableDataSource;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.impl.Connection;
import com.fr.data.impl.TableDataSourceDependent;
import com.fr.data.impl.XMLOPTableDataSource;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.file.filetree.FileNode;
import com.fr.general.ComparatorUtils;
import com.fr.general.LogRecordTime;
import com.fr.general.LogUtils;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ParameterProvider;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLFileReader;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;

public class DavXMLUtils {
    private DavXMLUtils() {
    }

    public static void writeXMLFileNodes(FileNode[] fileNodeArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new FileNodeArrayWriter(fileNodeArray));
    }

    public static FileNode[] readXMLFileNodes(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new FileNodeArrayReader());
        return object instanceof FileNode[] ? (FileNode[])object : new FileNode[]{};
    }

    public static void writeXMLFileDatabaseConnection(Connection connection, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new DatabaseConnectionWriter(connection));
    }

    public static Connection readXMLDatabaseConnection(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new DatabaseConnectionReader());
        return object instanceof Connection ? (Connection)object : null;
    }

    public static void writeXMLFileTableData(TableData tableData, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new TableDataWriter(tableData));
    }

    public static void writeXMLFileTableDataArray(TableData[] tableDataArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new TableDataArrayWriter(tableDataArray));
    }

    public static void writeXMLFileStoreProcedure(StoreProcedure storeProcedure, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new StoreProcedureWriter(storeProcedure));
    }

    public static TableData readXMLTableData(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new TableDataReader());
        return object instanceof TableData ? (TableData)object : null;
    }

    public static TableData[] readXMLTableDataArray(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new TableDataArrayReader());
        return object instanceof TableData[] ? (TableData[])object : new TableData[]{};
    }

    public static TableData[] readTableDatas(XMLableReader xMLableReader) {
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("TableData")) {
                    arrayList.add(DataCoreXmlUtils.readXMLTableData(xMLableReader));
                }
            }
        });
        return arrayList.toArray(new TableData[arrayList.size()]);
    }

    public static StoreProcedure readXMLStoreProcedure(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new StoreProcedureReader());
        return object instanceof StoreProcedure ? (StoreProcedure)object : null;
    }

    public static void writeXMLFileTableDataAndSource(TableData tableData, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new TableDataAndSourceWriter(tableData));
    }

    public static void writeXMLFileStoreProcedureAndSource(StoreProcedure storeProcedure, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new StoreProcedureAndSourceWriter(storeProcedure));
    }

    public static LogRecordTime[] readXMLLogRecords(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new LoRecordsArrayReader());
        return object instanceof LogRecordTime[] ? (LogRecordTime[])object : new LogRecordTime[]{};
    }

    public static void writeXMLFileParameters(ParameterProvider[] parameterProviderArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new ParameterArrayWriter(parameterProviderArray));
    }

    public static void writeXMLFileLogRecords(LogRecordTime[] logRecordTimeArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new LogMessageWriter(logRecordTimeArray));
    }

    public static Parameter[] readXMLParameters(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new ParameterArrayReader());
        return object instanceof Parameter[] ? (Parameter[])object : new Parameter[]{};
    }

    public static void writeXMLFileSchema(String[] stringArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new SchemaWriter(stringArray));
    }

    public static String[] readXMLFileSchema(InputStream inputStream) {
        Object object = null;
        try {
            object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new SchemaReader());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        return object instanceof String[] ? (String[])object : new String[1];
    }

    public static void writeXMLFileSQLTable(TableProcedure[] tableProcedureArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new SQLTableArrayWriter(tableProcedureArray));
    }

    public static TableProcedure[] readXMLSQLTables(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new SQLTableArrayReader());
        return object instanceof TableProcedure[] ? (TableProcedure[])object : new TableProcedure[]{};
    }

    public static void writeXMLFileProcedureText(String string, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new ProcedureTextWriter(string));
    }

    public static String readXMLProcedureText(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new ProcedureTextReader());
        return object instanceof String ? (String)object : "";
    }

    public static StoreProcedureParameter[] readXMLStoreProcedureParameters(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new StoreProcedureParameterReader());
        return object instanceof StoreProcedureParameter[] ? (StoreProcedureParameter[])object : new StoreProcedureParameter[]{};
    }

    public static void writeXMLSPColumns(String[] stringArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new ColumnWriter(stringArray));
    }

    public static String[] readXMLSPColumns(InputStream inputStream) {
        Object object = null;
        try {
            object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new ColumnReader());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        return object instanceof String[] ? (String[])object : ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public static void writeXMLFeedBackInfo(FeedBackInfo feedBackInfo, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new FeedBackInfoWriter(feedBackInfo));
    }

    public static void writeXMLModifiedTables(ModifiedTable modifiedTable, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new ModifiedTableWriter(modifiedTable));
    }

    public static ModifiedTable readXMLModifiedTables(InputStream inputStream) {
        Object object = null;
        try {
            object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new ModifiedTableReader());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        return object instanceof ModifiedTable ? (ModifiedTable)object : null;
    }

    public static boolean readXMLBoolean(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        return n2 == 1;
    }

    public static void writeXMLBoolean(boolean bl, OutputStream outputStream) throws IOException {
        if (bl) {
            outputStream.write(1);
        } else {
            outputStream.write(0);
        }
    }

    private static class FeedBackInfoWriter
    implements XMLWriter {
        private FeedBackInfo feedBackInfo = null;

        public FeedBackInfoWriter(FeedBackInfo feedBackInfo) {
            this.feedBackInfo = feedBackInfo;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            if (this.feedBackInfo == null) {
                return;
            }
            xMLPrintWriter.startTAG("FeedBack");
            xMLPrintWriter.attr("class", this.feedBackInfo.getClass().getName());
            this.feedBackInfo.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private static class ModifiedTableWriter
    implements XMLWriter {
        private ModifiedTable table = null;

        public ModifiedTableWriter(ModifiedTable modifiedTable) {
            this.table = modifiedTable;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("ModifiedTable");
            for (Map.Entry<String, Integer> entry : this.table.getModifiedMap().entrySet()) {
                String string = entry.getKey();
                xMLPrintWriter.startTAG("item").attr("key", string).attr("type", entry.getValue()).attr("modifier", this.table.getModifierMap().get(string)).end();
            }
            xMLPrintWriter.end();
        }
    }

    private static class ModifiedTableReader
    implements XMLFileReader {
        private ModifiedTable table = new ModifiedTable();

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if (string.equals("ModifiedTable")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("item")) {
                            String string = xMLableReader.getAttrAsString("key", "");
                            int n2 = xMLableReader.getAttrAsInt("type", -2);
                            if (!ComparatorUtils.equals(string, "") && n2 != -2) {
                                ModifiedTableReader.this.table.modifyTable(string, n2);
                                ModifiedTableReader.this.table.modiferTable(string, xMLableReader.getAttrAsString("modifier", "local"));
                            }
                        }
                    }
                });
            }
            return this.table;
        }

        public Object errorHandler() {
            return null;
        }
    }

    private static class ColumnReader
    implements XMLFileReader {
        private ColumnReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            final ArrayList arrayList = new ArrayList();
            if (string.equals("ColumnsName")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("column")) {
                            String string = xMLableReader.getElementValue();
                            arrayList.add(string);
                        }
                    }
                });
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                stringArray[i2] = (String)arrayList.get(i2);
            }
            return stringArray;
        }

        public Object errorHandler() {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    private static class ColumnWriter
    implements XMLWriter {
        private String[] cs;

        public ColumnWriter(String[] stringArray) {
            this.cs = stringArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("ColumnsName");
            for (int i2 = 0; i2 < (this.cs == null ? 0 : this.cs.length); ++i2) {
                xMLPrintWriter.startTAG("column").textNode(this.cs[i2]).end();
            }
            xMLPrintWriter.end();
        }
    }

    private static class StoreProcedureParameterReader
    implements XMLFileReader {
        private StoreProcedureParameterReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if ("Parameters".equals(string)) {
                return BaseXMLUtils.readStoreParameters(xMLableReader);
            }
            return null;
        }

        public Object errorHandler() {
            return new StoreProcedureParameter[0];
        }
    }

    private static class ProcedureTextReader
    implements XMLFileReader {
        private ProcedureTextReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if ("ProcedureText".equals(string)) {
                return xMLableReader.getAttrAsString("text", "");
            }
            return "";
        }

        public Object errorHandler() {
            return "";
        }
    }

    private static class ProcedureTextWriter
    implements XMLWriter {
        private String text;

        ProcedureTextWriter(String string) {
            this.text = string;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("ProcedureText");
            xMLPrintWriter.attr("text", this.text);
            xMLPrintWriter.end();
        }
    }

    private static class SQLTableArrayReader
    implements XMLFileReader {
        private SQLTableArrayReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            final ArrayList arrayList = new ArrayList();
            if ("SQLTables".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && "TableProcedure".equals(string = xMLableReader.getTagName())) {
                            TableProcedure tableProcedure = new TableProcedure();
                            xMLableReader.readXMLObject(tableProcedure);
                            arrayList.add(tableProcedure);
                        }
                    }
                });
            }
            return arrayList.toArray(new TableProcedure[arrayList.size()]);
        }

        public Object errorHandler() {
            return new TableProcedure[0];
        }
    }

    private static class SQLTableArrayWriter
    implements XMLWriter {
        private TableProcedure[] sqlTables;

        SQLTableArrayWriter(TableProcedure[] tableProcedureArray) {
            this.sqlTables = tableProcedureArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            int n2;
            xMLPrintWriter.startTAG("SQLTables");
            int n3 = n2 = this.sqlTables == null ? 0 : this.sqlTables.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.sqlTables[i2].writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
    }

    private static class SchemaReader
    implements XMLFileReader {
        private SchemaReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            final ArrayList arrayList = new ArrayList();
            if (string.equals("SchemaName")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Schema")) {
                            String string = xMLableReader.getElementValue();
                            arrayList.add(string);
                        }
                    }
                });
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                stringArray[i2] = (String)arrayList.get(i2);
            }
            return stringArray;
        }

        public Object errorHandler() {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    private static class SchemaWriter
    implements XMLWriter {
        private String[] schema;

        public SchemaWriter(String[] stringArray) {
            this.schema = stringArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("SchemaName");
            for (int i2 = 0; i2 < (this.schema == null ? 0 : this.schema.length); ++i2) {
                xMLPrintWriter.startTAG("Schema").textNode(this.schema[i2]).end();
            }
            xMLPrintWriter.end();
        }
    }

    private static class ParameterArrayReader
    implements XMLFileReader {
        private ParameterArrayReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if ("Parameters".equals(string)) {
                return BaseXMLUtils.readParameters(xMLableReader);
            }
            return null;
        }

        public Object errorHandler() {
            return new Parameter[0];
        }
    }

    private static class ParameterArrayWriter
    implements XMLWriter {
        private ParameterProvider[] parameters;

        ParameterArrayWriter(ParameterProvider[] parameterProviderArray) {
            this.parameters = parameterProviderArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            StableXMLUtils.writeParameters(xMLPrintWriter, this.parameters);
        }
    }

    private static class LogMessageWriter
    implements XMLWriter {
        private LogRecordTime[] records;

        LogMessageWriter(LogRecordTime[] logRecordTimeArray) {
            this.records = logRecordTimeArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            LogUtils.writeLogRecords(xMLPrintWriter, this.records);
        }
    }

    private static class LoRecordsArrayReader
    implements XMLFileReader {
        private LoRecordsArrayReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if ("LogRecords".equals(string)) {
                return LogUtils.readLogRecords(xMLableReader);
            }
            return null;
        }

        public Object errorHandler() {
            return new LogRecordTime[0];
        }
    }

    private static class StoreProcedureAndSourceWriter
    implements XMLWriter {
        private StoreProcedure data;

        StoreProcedureAndSourceWriter(StoreProcedure storeProcedure) {
            this.data = storeProcedure;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            DataCoreXmlUtils.writeXMLStoreProcedure(xMLPrintWriter, this.data, null);
        }
    }

    private static class TableDataAndSourceWriter
    implements XMLWriter {
        private TableData data;

        TableDataAndSourceWriter(TableData tableData) {
            this.data = tableData;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            if (this.data == null) {
                return;
            }
            xMLPrintWriter.startTAG("TableData");
            xMLPrintWriter.attr("class", this.data.getClass().getName());
            if (this.data instanceof TableDataSourceDependent) {
                this.writeTableDataSource(xMLPrintWriter);
            }
            this.data.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }

        private void writeTableDataSource(XMLPrintWriter xMLPrintWriter) {
            TableDataSource tableDataSource = ((TableDataSourceDependent)((Object)this.data)).getTableDataSource();
            if (tableDataSource != null) {
                new XMLOPTableDataSource(tableDataSource).writeXML(xMLPrintWriter);
            }
        }
    }

    private static class TableDataReader
    implements XMLFileReader {
        private TableDataReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if ("TableData".equals(string)) {
                return DataCoreXmlUtils.readXMLTableData(xMLableReader);
            }
            return null;
        }

        public Object errorHandler() {
            return null;
        }
    }

    private static class StoreProcedureReader
    implements XMLFileReader {
        private StoreProcedureReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if ("StoreProcedure".equals(string)) {
                return DataCoreXmlUtils.readXMLStoreProcedure(xMLableReader);
            }
            return null;
        }

        public Object errorHandler() {
            return null;
        }
    }

    private static class TableDataArrayReader
    implements XMLFileReader {
        private TableDataArrayReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if ("TableDatas".equals(string)) {
                return DavXMLUtils.readTableDatas(xMLableReader);
            }
            return null;
        }

        public Object errorHandler() {
            return null;
        }
    }

    private static class StoreProcedureWriter
    implements XMLWriter {
        private StoreProcedure data;

        StoreProcedureWriter(StoreProcedure storeProcedure) {
            this.data = storeProcedure;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            DataCoreXmlUtils.writeXMLStoreProcedure(xMLPrintWriter, this.data, null);
        }
    }

    private static class TableDataWriter
    implements XMLWriter {
        private TableData data;

        TableDataWriter(TableData tableData) {
            this.data = tableData;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, this.data);
        }
    }

    private static class TableDataArrayWriter
    implements XMLWriter {
        private TableData[] data;

        TableDataArrayWriter(TableData[] tableDataArray) {
            this.data = tableDataArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            DataCoreXmlUtils.writeXMLTableDataArray(xMLPrintWriter, this.data);
        }
    }

    private static class DatabaseConnectionReader
    implements XMLFileReader {
        private DatabaseConnectionReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if ("Connection".equals(string)) {
                return DataCoreXmlUtils.readXMLConnection(xMLableReader);
            }
            return null;
        }

        public Object errorHandler() {
            return null;
        }
    }

    private static class DatabaseConnectionWriter
    implements XMLWriter {
        private Connection database;

        DatabaseConnectionWriter(Connection connection) {
            this.database = connection;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            DataCoreXmlUtils.writeXMLConnection(xMLPrintWriter, this.database);
        }
    }

    private static class FileNodeArrayReader
    implements XMLFileReader {
        private FileNodeArrayReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            final ArrayList arrayList = new ArrayList();
            if ("NODES".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "Node".equals(xMLableReader.getTagName())) {
                            FileNode fileNode = new FileNode();
                            xMLableReader.readXMLObject(fileNode);
                            arrayList.add(fileNode);
                        }
                    }
                });
            }
            return arrayList.toArray(new FileNode[arrayList.size()]);
        }

        public Object errorHandler() {
            return new FileNode[0];
        }
    }

    private static class FileNodeArrayWriter
    implements XMLWriter {
        private FileNode[] fileNodes;

        FileNodeArrayWriter(FileNode[] fileNodeArray) {
            this.fileNodes = fileNodeArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            int n2;
            xMLPrintWriter.startTAG("NODES");
            int n3 = n2 = this.fileNodes == null ? 0 : this.fileNodes.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.fileNodes[i2].writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
    }
}

