/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.util.function;

import com.fr.base.FComparator;
import com.fr.data.impl.Group;
import com.fr.data.impl.GroupList;
import com.fr.data.util.DefaultComparator;
import com.fr.data.util.function.AbstractDataFunction;
import com.fr.general.ComparatorUtils;
import com.fr.stable.Primitive;
import java.util.ArrayList;
import java.util.List;

public class MinFunction
extends AbstractDataFunction {
    private FComparator comparator = null;
    private Object minResult = new Double(Double.MAX_VALUE);

    public MinFunction() {
        this(null);
    }

    public MinFunction(FComparator fComparator) {
        if (fComparator == null) {
            fComparator = new DefaultComparator();
        }
        this.setComparator(fComparator);
        this.reset();
    }

    public FComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(FComparator fComparator) {
        this.comparator = fComparator;
    }

    public void reset() {
        this.minResult = null;
    }

    public void addData(Object object) {
        if (object == null || ComparatorUtils.equals(Primitive.NULL, object)) {
            return;
        }
        if (this.minResult == null) {
            this.minResult = object;
            return;
        }
        int n2 = this.comparator.compare(this.minResult, object);
        if (n2 > 0) {
            this.minResult = object;
        }
    }

    public Object getResult() {
        return this.minResult;
    }

    public String getFormula() {
        return "min";
    }

    public void cal_when_traverse_result(GroupList groupList, Object object) {
        List list = groupList.getV_list();
        ArrayList arrayList = groupList.getG();
        if (arrayList.size() > 0) {
            Group group = (Group)arrayList.get(0);
            double d2 = ((Number)group.getValue()).doubleValue();
            double d3 = ((Number)object).doubleValue();
            Double d4 = new Double(Math.min(d2, d3));
            group.setValue(d4);
        } else {
            Group group = new Group(object);
            arrayList.add(group);
        }
    }
}

