/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.Parameter;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.core.define.XMLColumnNameDateType;
import com.fr.data.core.define.XMLColumnNameType;
import com.fr.data.impl.DirectoryConnectionContainer;
import com.fr.data.impl.FileTableData;
import com.fr.data.impl.XMLDataModel;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.DataModel;
import com.fr.general.data.DataSource;
import com.fr.script.Calculator;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;

public class XMLTableData
extends FileTableData
implements XMLable,
DirectoryConnectionContainer {
    private static final long serialVersionUID = 1L;
    private DataSource dataSource = null;
    private String filePath;
    private String xmlKeyPoint;
    private Parameter[] params;
    private String[] xPath = null;
    private String charSet = "UTF-8";
    private XMLColumnNameType[] columns = new XMLColumnNameType[0];
    public static final int COLUMN_TYPE_STRING = 0;
    public static final int COLUMN_TYPE_NUMBER = 1;
    public static final int COLUMN_TYPE_DATE = 2;
    public static final int COLUMN_TYPE_BOOLEAN = 3;

    public Parameter[] getParams() {
        return this.params;
    }

    public void setParams(Parameter[] parameterArray) {
        this.params = parameterArray;
    }

    public String getXmlKeyPoint() {
        return this.xmlKeyPoint;
    }

    public void setXmlKeyPoint(String string) {
        this.xmlKeyPoint = string;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public Parameter[] getParameters(Calculator calculator) {
        return this.params == null ? new Parameter[]{} : this.params;
    }

    public String[] getXPath() {
        return this.xPath;
    }

    public void setXPath(String[] stringArray) {
        this.xPath = stringArray;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String string) {
        this.charSet = string;
    }

    public XMLColumnNameType[] getColumns() {
        return this.columns;
    }

    public void setColumns(XMLColumnNameType[] xMLColumnNameTypeArray) {
        this.columns = xMLColumnNameTypeArray;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataModel createDataModel(Calculator calculator) {
        Parameter[] parameterArray = Parameter.providers2Parameter(Calculator.processParameters(calculator, this.params));
        this.params = parameterArray.length == 0 ? this.params : parameterArray;
        try {
            XMLColumnNameType[] xMLColumnNameTypeArray = new XMLColumnNameType[]{};
            if (this.columns != null) {
                xMLColumnNameTypeArray = new XMLColumnNameType[this.columns.length];
                for (int i2 = 0; i2 < xMLColumnNameTypeArray.length; ++i2) {
                    XMLColumnNameType xMLColumnNameType = this.columns[i2];
                    xMLColumnNameTypeArray[i2] = xMLColumnNameType == null ? null : (XMLColumnNameType)xMLColumnNameType.clone();
                }
            }
            if (this.params != null) {
                parameterArray = this.params;
            }
            return new XMLDataModel((DataSource)this.dataSource.clone(), parameterArray, this.xPath == null ? null : (String[])this.xPath.clone(), this.charSet, xMLColumnNameTypeArray);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return DataModel.EMPTY_DATAMODEL;
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("XMLTableDataAttr".equals(string)) {
                String string2 = xMLableReader.getAttrAsString("filePath", null);
                if (string2 != null) {
                    this.filePath = string2;
                }
                if ((string2 = xMLableReader.getAttrAsString("xmlKeyPoint", null)) != null) {
                    this.xmlKeyPoint = string2;
                }
                if ((string2 = xMLableReader.getAttrAsString("charSet", null)) != null) {
                    this.charSet = string2;
                }
            } else if ("Parameters".equals(string)) {
                final ArrayList arrayList = new ArrayList();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("Parameter".equals(xMLableReader.getTagName())) {
                            arrayList.add(StableXMLUtils.readParameter(xMLableReader));
                        }
                    }
                });
                if (arrayList.size() > 0) {
                    this.params = new Parameter[arrayList.size()];
                    arrayList.toArray(this.params);
                }
            } else if ("XPath".equals(string)) {
                String string3 = xMLableReader.getAttrAsString("length", null);
                if (string3 != null) {
                    this.xPath = new String[Integer.parseInt(string3.trim())];
                    xMLableReader.readXMLObject(new XMLReadable(){
                        String tmpV;

                        public void readXML(XMLableReader xMLableReader) {
                            if (xMLableReader.isChildNode() && "XPathElem".equals(xMLableReader.getTagName()) && (this.tmpV = xMLableReader.getAttrAsString("idx", null)) != null) {
                                int n2 = Integer.parseInt(this.tmpV.trim());
                                this.tmpV = xMLableReader.getElementValue();
                                if (this.tmpV != null) {
                                    ((XMLTableData)XMLTableData.this).xPath[n2] = this.tmpV.trim();
                                }
                            }
                        }
                    });
                }
            } else if ("Columns".equals(string)) {
                String string4 = xMLableReader.getAttrAsString("length", null);
                if (string4 != null) {
                    this.columns = new XMLColumnNameType[Integer.parseInt(string4.trim())];
                    xMLableReader.readXMLObject(new XMLReadable(){
                        String tmpV;

                        public void readXML(XMLableReader xMLableReader) {
                            if (xMLableReader.isChildNode() && "ColumnElem".equals(xMLableReader.getTagName()) && (this.tmpV = xMLableReader.getAttrAsString("idx", null)) != null) {
                                int n2 = Integer.parseInt(this.tmpV.trim());
                                boolean bl = false;
                                this.tmpV = xMLableReader.getAttrAsString("isdate", null);
                                if (this.tmpV != null) {
                                    bl = new Boolean(this.tmpV.trim());
                                }
                                XMLColumnNameType xMLColumnNameType = bl ? new XMLColumnNameDateType() : new XMLColumnNameType();
                                xMLableReader.readXMLObject(xMLColumnNameType);
                                ((XMLTableData)XMLTableData.this).columns[n2] = xMLColumnNameType;
                            }
                        }
                    });
                }
            } else if ("DataSource".equals(string)) {
                this.dataSource = DataCoreXmlUtils.readXMLDataSource(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2;
        xMLPrintWriter.startTAG("XMLTableDataAttr").attr("filePath", this.getFilePath()).attr("xmlKeyPoint", this.getXmlKeyPoint()).attr("charSet", this.getCharSet()).end();
        StableXMLUtils.writeParameters(xMLPrintWriter, this.params);
        if (!"UTF-8".equals(this.charSet)) {
            xMLPrintWriter.startTAG("CharSet").textNode(this.charSet).end();
        }
        if (this.xPath != null) {
            xMLPrintWriter.startTAG("XPath").attr("length", this.xPath.length);
            for (n2 = 0; n2 < this.xPath.length; ++n2) {
                if (this.xPath[n2] == null) continue;
                xMLPrintWriter.startTAG("XPathElem").attr("idx", n2).textNode(this.xPath[n2]).end();
            }
            xMLPrintWriter.end();
        }
        if (this.columns != null) {
            xMLPrintWriter.startTAG("Columns").attr("length", this.columns.length);
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                if (this.columns[n2] == null) continue;
                xMLPrintWriter.startTAG("ColumnElem").attr("idx", n2).attr("isdate", this.columns[n2].getType() == 2);
                this.columns[n2].writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        if (this.dataSource != null) {
            DataCoreXmlUtils.writeXMLDataSource(xMLPrintWriter, this.dataSource);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof XMLTableData)) {
            return false;
        }
        XMLTableData xMLTableData = (XMLTableData)object;
        return object instanceof XMLTableData && super.equals(object) && ComparatorUtils.equals(this.dataSource, xMLTableData.dataSource) && ComparatorUtils.equals(this.charSet, xMLTableData.charSet) && ComparatorUtils.equals(this.columns, xMLTableData.columns) && ComparatorUtils.equals(this.xPath, xMLTableData.xPath);
    }

    public Object clone() throws CloneNotSupportedException {
        XMLTableData xMLTableData = (XMLTableData)super.clone();
        if (this.columns != null) {
            XMLColumnNameType[] xMLColumnNameTypeArray = new XMLColumnNameType[this.columns.length];
            for (int i2 = 0; i2 < this.columns.length; ++i2) {
                xMLColumnNameTypeArray[i2] = (XMLColumnNameType)this.columns[i2].clone();
            }
            xMLTableData.setColumns(xMLColumnNameTypeArray);
        }
        if (this.dataSource != null) {
            xMLTableData.setDataSource((DataSource)this.dataSource.clone());
        }
        if (this.xPath != null) {
            xMLTableData.setXPath((String[])this.xPath.clone());
        }
        return xMLTableData;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean needColumnName() {
        return false;
    }
}

