/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dml.CountSelect;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.FieldValueGetter;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.SortInfo;
import com.fr.data.dao.page.PageConfiguration;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.stable.StableUtils;
import java.sql.ResultSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoMapperUtils {
    public static Select createAllSelect(ObjectTableMapper objectTableMapper, SortInfo sortInfo) {
        Select select = new Select(objectTableMapper.getTable(), null);
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null) continue;
            select.addColumnName(fieldColumnMapperArray[i2].getColumnName());
        }
        if (sortInfo != null) {
            sortInfo.createOrderBy(select, objectTableMapper);
        }
        return select;
    }

    public static Select createSelectAllByMoreInfo(ObjectTableMapper objectTableMapper, Map<String, Object> map, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        Select select = DaoMapperUtils.createAllSelect(objectTableMapper, null);
        Where where = new Where();
        boolean bl = false;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            bl = true;
            FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(entry.getKey());
            if (fieldColumnMapper == null) {
                throw new RuntimeException(entry.getKey() + " can not matched in mapping info.");
            }
            Object object = fieldColumnMapper.field2Value(entry.getValue(), dataAccessObjectSession);
            where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, object);
        }
        if (bl) {
            select.setWhere(where);
        }
        return select;
    }

    public static Delete createAllDelete(ObjectTableMapper objectTableMapper) {
        return new Delete(objectTableMapper.getTable());
    }

    public static Delete createDeleteByPrimaryKey(long l2, ObjectTableMapper objectTableMapper) {
        Delete delete = new Delete(objectTableMapper.getTable());
        Where where = new Where();
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, l2);
        delete.setWhere(where);
        return delete;
    }

    public static Delete createDeleteByField(String string, Object object, ObjectTableMapper objectTableMapper, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(string);
        if (fieldColumnMapper == null) {
            throw new IllegalArgumentException("FieldName " + string + " can not matched in this mapping info.");
        }
        return DaoMapperUtils.createDeleteByFCMapper(fieldColumnMapper, object, objectTableMapper, dataAccessObjectSession);
    }

    public static Delete createDeleteByColumn(String string, Object object, ObjectTableMapper objectTableMapper, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByColumnName(string);
        if (fieldColumnMapper == null) {
            throw new IllegalArgumentException("FieldName " + string + " can not matched in this mapping info.");
        }
        return DaoMapperUtils.createDeleteByFCMapper(fieldColumnMapper, object, objectTableMapper, dataAccessObjectSession);
    }

    private static Delete createDeleteByFCMapper(FieldColumnMapper fieldColumnMapper, Object object, ObjectTableMapper objectTableMapper, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        Delete delete = new Delete(objectTableMapper.getTable());
        Where where = new Where();
        where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, fieldColumnMapper.field2Value(object, dataAccessObjectSession));
        delete.setWhere(where);
        return delete;
    }

    public static Delete createDeleteByInfo(ObjectTableMapper objectTableMapper, Map<String, Object> map, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        Delete delete = new Delete(objectTableMapper.getTable());
        if (map == null || map.isEmpty()) {
            return delete;
        }
        Where where = new Where();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(entry.getKey());
            if (fieldColumnMapper == null) {
                throw new IllegalArgumentException("FieldName " + entry.getKey() + " can not matched in this mapping info.");
            }
            where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, fieldColumnMapper.field2Value(entry.getValue(), dataAccessObjectSession));
        }
        delete.setWhere(where);
        return delete;
    }

    public static Select createLoadSelect(FieldColumnMapper fieldColumnMapper, Object object, ObjectTableMapper objectTableMapper, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        if (fieldColumnMapper == null) {
            throw new RuntimeException("Mapper info can not be null!");
        }
        Object object2 = fieldColumnMapper.field2Value(object, dataAccessObjectSession);
        return DaoMapperUtils.createSelectByInfo(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), object2, 0, objectTableMapper, false);
    }

    public static Select createSelectByField(String string, Object object, int n2, ObjectTableMapper objectTableMapper, DataAccessObjectSession dataAccessObjectSession, boolean bl) throws Exception {
        FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(string);
        return DaoMapperUtils.createSelectByFCMapper(fieldColumnMapper, object, n2, objectTableMapper, dataAccessObjectSession, bl);
    }

    public static Select createSelectByColumn(String string, Object object, int n2, ObjectTableMapper objectTableMapper, DataAccessObjectSession dataAccessObjectSession, boolean bl) throws Exception {
        FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByColumnName(string);
        return DaoMapperUtils.createSelectByFCMapper(fieldColumnMapper, object, n2, objectTableMapper, dataAccessObjectSession, bl);
    }

    private static Select createSelectByFCMapper(FieldColumnMapper fieldColumnMapper, Object object, int n2, ObjectTableMapper objectTableMapper, DataAccessObjectSession dataAccessObjectSession, boolean bl) throws Exception {
        if (fieldColumnMapper == null) {
            throw new RuntimeException("No FieldColumnMapper can find !");
        }
        object = fieldColumnMapper.field2Value(object, dataAccessObjectSession);
        return DaoMapperUtils.createSelectByInfo(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), object, n2, objectTableMapper, bl);
    }

    public static Select createSelectByInfo(String string, int n2, Object object, int n3, ObjectTableMapper objectTableMapper, boolean bl) {
        FieldColumnMapper[] fieldColumnMapperArray;
        Select select;
        if (bl) {
            select = new Select(objectTableMapper.getTable(), null);
            fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
            for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
                if (fieldColumnMapperArray[i2].getColumnName() == null || ComparatorUtils.equals(fieldColumnMapperArray[i2].getColumnName(), string)) continue;
                select.addColumnName(fieldColumnMapperArray[i2].getColumnName());
            }
        } else {
            select = DaoMapperUtils.createAllSelect(objectTableMapper, null);
        }
        fieldColumnMapperArray = new Where();
        fieldColumnMapperArray.addColumn(string, n2, n3, object);
        select.setWhere((Where)fieldColumnMapperArray);
        return select;
    }

    public static String createSelectSQLByListFiledValue(Map<String, Object> map, ObjectTableMapper objectTableMapper, Dialect dialect, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        boolean bl = false;
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null) continue;
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(dialect.column2SQL(fieldColumnMapperArray[i2].getColumnName()));
            bl = true;
        }
        stringBuilder.append("  FROM ").append(dialect.table2SQL(objectTableMapper.getTable())).append(" ");
        if (map == null || map.isEmpty()) {
            return stringBuilder.toString();
        }
        stringBuilder.append("WHERE ");
        boolean bl2 = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (!bl2) {
                stringBuilder.append(" and ");
            }
            bl2 = false;
            FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(entry.getKey());
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                if (objectArray.length == 0) {
                    return null;
                }
                stringBuilder.append(dialect.column2SQL(fieldColumnMapper.getColumnName()));
                stringBuilder.append(" in (");
                int n2 = objectArray.length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (i3 != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(DaoMapperUtils.createValueSql(fieldColumnMapper.field2Value(objectArray[i3], dataAccessObjectSession)));
                }
                stringBuilder.append(")");
            } else {
                stringBuilder.append(dialect.column2SQL(fieldColumnMapper.getColumnName())).append(" = ").append(DaoMapperUtils.createValueSql(fieldColumnMapper.field2Value(object, dataAccessObjectSession)));
            }
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private static String createValueSql(Object object) {
        if (object instanceof String) {
            return "'" + object.toString() + "'";
        }
        return object.toString();
    }

    public static Insert createInsert(ObjectTableMapper objectTableMapper, FieldValueGetter fieldValueGetter, boolean bl, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        if (objectTableMapper == null) {
            return null;
        }
        Insert insert = new Insert(objectTableMapper.getTable());
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null) continue;
            String string = fieldColumnMapperArray[i2].getColumnName();
            int n2 = fieldColumnMapperArray[i2].getType();
            Object object = fieldValueGetter.getFieldValue(fieldColumnMapperArray[i2].getFieldName());
            if (fieldColumnMapperArray[i2].isPrimaryKey() && DaoMapperUtils.isNegative(object) || (object = fieldColumnMapperArray[i2].field2Value(object, dataAccessObjectSession)) == null) continue;
            insert.addColumn(string, n2, object);
        }
        return insert;
    }

    private static boolean isNegative(Object object) {
        Number number = GeneralUtils.objectToNumberReturnNull(object);
        if (number == null) {
            return false;
        }
        if (object instanceof Long) {
            return (Long)object < 0L;
        }
        if (object instanceof Integer) {
            return (Integer)object < 0;
        }
        if (object instanceof String) {
            return Long.valueOf((String)object) < 0L;
        }
        return false;
    }

    public static Update createUpdate(Object object, ObjectTableMapper objectTableMapper, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        Update update = new Update(objectTableMapper.getTable());
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        FieldColumnMapper fieldColumnMapper = null;
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null) continue;
            if (fieldColumnMapperArray[i2].isPrimaryKey()) {
                fieldColumnMapper = fieldColumnMapperArray[i2];
                continue;
            }
            Object object2 = StableUtils.getPrivateFieldValue(object, fieldColumnMapperArray[i2].getFieldName());
            object2 = fieldColumnMapperArray[i2].field2Value(object2, dataAccessObjectSession);
            update.addColumn(fieldColumnMapperArray[i2].getColumnName(), fieldColumnMapperArray[i2].getType(), object2);
        }
        if (fieldColumnMapper == null) {
            return null;
        }
        Where where = new Where();
        where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, StableUtils.getPrivateFieldValue(object, fieldColumnMapper.getFieldName()));
        update.setWhere(where);
        return update;
    }

    public static Update createUpdateByInfo(Object object, ObjectTableMapper objectTableMapper, DataAccessObjectSession dataAccessObjectSession, Map<String, Object> map) throws Exception {
        Update update = new Update(objectTableMapper.getTable());
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null || fieldColumnMapperArray[i2].isPrimaryKey()) continue;
            Object object2 = StableUtils.getPrivateFieldValue(object, fieldColumnMapperArray[i2].getFieldName());
            object2 = fieldColumnMapperArray[i2].field2Value(object2, dataAccessObjectSession);
            update.addColumn(fieldColumnMapperArray[i2].getColumnName(), fieldColumnMapperArray[i2].getType(), object2);
        }
        Where where = new Where();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(entry.getKey());
            if (fieldColumnMapper == null) {
                throw new IllegalArgumentException("FieldName " + entry.getKey() + " can not matched in this mapping info.");
            }
            where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, fieldColumnMapper.field2Value(entry.getValue(), dataAccessObjectSession));
        }
        update.setWhere(where);
        return update;
    }

    public static Update createUpdate(ObjectTableMapper objectTableMapper, Map<String, Object> map, FieldColumnMapper fieldColumnMapper, Object object, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        Update update = new Update(objectTableMapper.getTable());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            FieldColumnMapper fieldColumnMapper2 = objectTableMapper.findFCMapperByFieldName(entry.getKey());
            if (fieldColumnMapper2 == null) {
                throw new IllegalArgumentException("FieldName " + entry.getKey() + " can not matched in this mapping info.");
            }
            Object object2 = entry.getValue();
            object2 = fieldColumnMapper2.field2Value(object2, dataAccessObjectSession);
            update.addColumn(fieldColumnMapper2.getColumnName(), fieldColumnMapper2.getType(), object2);
        }
        if (object != null) {
            Where where = new Where();
            where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, object);
            update.setWhere(where);
        }
        return update;
    }

    public static <T> T extractResultSet(ResultSet resultSet, Class<T> clazz, ObjectTableMapper objectTableMapper, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        T t2 = clazz.newInstance();
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            FieldColumnMapper fieldColumnMapper = fieldColumnMapperArray[i2];
            if (fieldColumnMapper.getColumnName() == null) continue;
            Object object = null;
            object = fieldColumnMapper.getType() == 12 ? resultSet.getString(fieldColumnMapper.getColumnName()) : (fieldColumnMapper.getType() == 16 ? Boolean.valueOf(resultSet.getBoolean(fieldColumnMapper.getColumnName())) : (fieldColumnMapper.getType() == 4 || fieldColumnMapper.getType() == -6 ? Integer.valueOf(resultSet.getInt(fieldColumnMapper.getColumnName())) : (fieldColumnMapper.getType() == 93 ? resultSet.getTimestamp(fieldColumnMapper.getColumnName()) : resultSet.getObject(fieldColumnMapper.getColumnName()))));
            if ((object = fieldColumnMapper.value2Field(object, dataAccessObjectSession.getManager().startSession())) == null) continue;
            object = dataAccessObjectSession.convertDBValueToFieldValue(object, fieldColumnMapperArray[i2].getType());
            StableUtils.setPrivateFieldValue(t2, fieldColumnMapperArray[i2].getFieldName(), object);
        }
        return t2;
    }

    public static Select createPageSelect(ObjectTableMapper objectTableMapper, SortInfo sortInfo, PageConfiguration pageConfiguration) {
        return DaoMapperUtils.createAllSelect(objectTableMapper, sortInfo).setPageConfiguration(pageConfiguration);
    }

    public static Select createCountAllSelect(ObjectTableMapper objectTableMapper) {
        CountSelect countSelect = new CountSelect(objectTableMapper.getTable(), null);
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null) continue;
            countSelect.addColumnName(fieldColumnMapperArray[i2].getColumnName());
        }
        return countSelect;
    }
}

