/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.handler;

import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.general.DateUtils;
import com.fr.stable.date.YearDate;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public abstract class AbstractTimeTypeHandler
implements SQLTypeHandler {
    public void setValue(PreparedStatement preparedStatement, int n2, Object object, int n3) throws SQLException {
        if (object instanceof Timestamp) {
            this.setPreparedStatementByTime(preparedStatement, n2, ((Timestamp)object).getTime());
        } else if (object instanceof Date) {
            this.setPreparedStatementByTime(preparedStatement, n2, ((Date)object).getTime());
        } else if (object instanceof Time) {
            this.setPreparedStatementByTime(preparedStatement, n2, ((Time)object).getTime());
        } else if (object instanceof String) {
            Date date = null;
            try {
                date = DateUtils.string2Date(object.toString(), true);
            }
            catch (Exception exception) {
                preparedStatement.setNull(n2, n3);
                return;
            }
            if (date != null) {
                this.setPreparedStatementByTime(preparedStatement, n2, date.getTime());
            } else {
                preparedStatement.setNull(n2, n3);
            }
        } else if (object instanceof YearDate) {
            preparedStatement.setString(n2, object.toString());
        }
    }

    protected abstract void setPreparedStatementByTime(PreparedStatement var1, int var2, long var3) throws SQLException;
}

