/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dml.Fragment;
import com.fr.general.ComparatorUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class Table
implements Fragment,
XMLable {
    public static final String XML_TAG = "Table";
    private String schema = null;
    private String name = null;

    public Table() {
    }

    public Table(String string) {
        this(null, string);
    }

    public Table(String string, String string2) {
        this.schema = string;
        this.name = string2;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String toNormalSQLString(Dialect dialect) {
        return dialect.table2SQL(this);
    }

    public String toStatementSQLString(Dialect dialect) {
        return this.toNormalSQLString(dialect);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = null;
        string = xMLableReader.getAttrAsString("schema", null);
        if (string != null) {
            this.schema = string;
        }
        if ((string = xMLableReader.getAttrAsString("name", null)) != null) {
            this.name = string;
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.getSchema() != null) {
            xMLPrintWriter.attr("schema", this.getSchema());
        }
        if (this.getName() != null) {
            xMLPrintWriter.attr("name", this.getName());
        }
        xMLPrintWriter.end();
    }

    public String toString() {
        if (StringUtils.isBlank(this.name)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!StringUtils.isBlank(this.schema)) {
            stringBuffer.append(this.schema).append('.');
        }
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Table)) {
            return false;
        }
        Table table = (Table)object;
        return ComparatorUtils.equals(this.schema, table.schema) && ComparatorUtils.equals(this.name, table.name);
    }

    public int hashCode() {
        int n2 = 0;
        if (this.schema != null) {
            n2 = 37 * n2 + this.schema.hashCode();
        }
        n2 = 37 * n2 + this.name.hashCode();
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

