/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.dao.JDBCDataAccessObjectOperator;
import com.fr.data.dao.ObjectMappingTable;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import java.sql.Connection;
import java.sql.SQLException;

public class InformixDialect
extends AbstractDialect {
    private static final int AMOUNT_SIZE = 255;
    private static final int DEFAULT_HASH_VALUE = 37;
    private static final String DEFAULT_INCREMENT_EM = "serial";
    private static final String DIALECT_NAME = "informix";
    private static final int LIMIT_QUERY_EXPAND_LENGTH = 16;
    private static final int SELECT_STRING_LENGTH = 6;

    public void initTables(JDBCDataAccessObjectOperator jDBCDataAccessObjectOperator, Connection connection, ObjectMappingTable[] objectMappingTableArray) throws Exception {
        try {
            int n2;
            for (n2 = 0; n2 < objectMappingTableArray.length; ++n2) {
                objectMappingTableArray[n2].createTable(connection);
            }
            for (n2 = 0; n2 < objectMappingTableArray.length; ++n2) {
                objectMappingTableArray[n2].initData(jDBCDataAccessObjectOperator.startSession());
            }
            for (n2 = 0; n2 < objectMappingTableArray.length; ++n2) {
                objectMappingTableArray[n2].createForeignKey(connection);
            }
            connection.commit();
        }
        catch (Exception exception) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                }
            }
            throw exception;
        }
    }

    public StringBuffer columnInit(StringBuffer stringBuffer, Column column) {
        stringBuffer.append(" ").append(column.isAllowNull() ? "" : "NOT NULL");
        return stringBuffer;
    }

    public String cascadeDeletePosition(boolean bl, boolean bl2, StringBuffer stringBuffer) {
        return stringBuffer.toString();
    }

    public String columnType2SQL(int n2, String string) {
        switch (n2) {
            case -7: {
                return "varchar(1)";
            }
            case -6: {
                return "int8";
            }
            case 4: {
                return "int";
            }
            case -5: {
                return "int";
            }
            case 12: {
                return "nvarchar(255)";
            }
            case 93: {
                return "DATETIME YEAR TO second";
            }
        }
        return TypeUtils.getTypeName(n2);
    }

    public String createSequence(Connection connection, String string, String string2, String string3) {
        int n2 = string2.length();
        return new StringBuffer().replace(0, n2, DEFAULT_INCREMENT_EM).toString();
    }

    public String getIdentitySelectString(String string, String string2, int n2) throws Exception {
        return "select first 1 " + string2 + " from " + string + " order by " + string2 + " desc";
    }

    public boolean supportsLimitOffset(String string) {
        return false;
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    public String getLimitString(String string, int n2, int n3) {
        if (n2 > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuffer(string.length() + 16).append(string).insert(string.toLowerCase().indexOf("select") + 6, " first " + n3).toString();
    }

    public String buildForeignKeyString(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(30).append(" add constraint ").append(this.foreignKeyString(stringArray, string2, stringArray2, bl));
        stringBuffer.append(" on delete cascade constraint ").append(string);
        return stringBuffer.toString();
    }

    private class CTC {
        private String url = null;
        private String user = null;
        private Table table = null;
        private String columnName = null;

        public CTC(Connection connection, Table table, String string) {
            try {
                this.url = connection.getMetaData().getURL();
                this.user = connection.getMetaData().getUserName();
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            }
            this.table = table;
            this.columnName = string;
        }

        public int hashCode() {
            int n2 = 0;
            n2 = 37 * n2 + this.url.hashCode();
            n2 = 37 * n2 + this.user.hashCode();
            n2 = 37 * n2 + this.table.hashCode();
            n2 = 37 * n2 + this.columnName.hashCode();
            return n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CTC)) {
                return false;
            }
            CTC cTC = (CTC)object;
            return ComparatorUtils.equals(this.url, cTC.url) && ComparatorUtils.equals(this.user, cTC.user) && ComparatorUtils.equals(this.table, cTC.table) && ComparatorUtils.equals(this.columnName, cTC.columnName);
        }
    }
}

