/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.AccessDialect;
import com.fr.data.core.db.dialect.DB2Dialect;
import com.fr.data.core.db.dialect.DB2V6Dialect;
import com.fr.data.core.db.dialect.DB2V7Dialect;
import com.fr.data.core.db.dialect.DB2V8Dialect;
import com.fr.data.core.db.dialect.DerbyDialect;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.H2Dialect;
import com.fr.data.core.db.dialect.HSQLDialect;
import com.fr.data.core.db.dialect.HiveDialect;
import com.fr.data.core.db.dialect.InformixDialect;
import com.fr.data.core.db.dialect.MSSQL2000Dialect;
import com.fr.data.core.db.dialect.MSSQL2005Dialect;
import com.fr.data.core.db.dialect.MSSQL2008Dialect;
import com.fr.data.core.db.dialect.MSSQL2012Dialect;
import com.fr.data.core.db.dialect.MSSQLDialect;
import com.fr.data.core.db.dialect.MySQLDialect;
import com.fr.data.core.db.dialect.Oracle10gDialect;
import com.fr.data.core.db.dialect.Oracle8iDialect;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.dialect.PostgreSQLDialect;
import com.fr.data.core.db.dialect.SQLiteDialect;
import com.fr.data.core.db.dialect.SybaseDialect;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UrlDriver;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.DialectCreator;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DialectFactory {
    private static final int ORACLE9_MAJOR_VERSION = 9;
    private static final int MSSQL2000_MAJOR_VERSION = 8;
    private static final int MSSQL2005_MAJOR_VERSION = 9;
    private static final int MSSQL2008_MAJOR_VERSION = 10;
    private static final int MSSQL2012_MAJOR_VERSION = 11;
    private static final int MSSQL2014_MAJOR_VERSION = 12;
    private static final int MSSQL2016_MAJOR_VERSION = 13;
    private static final int DB2V6_MAJOR_VERSION = 6;
    private static final int DB2V7_MAJOR_VERSION = 7;
    private static final int DB2V8_MAJOR_VERSION = 8;
    private static Dialect defaultDialect;
    private static Map dialectMap;
    private static Map databaseNameDialectMap;

    public static Dialect getDefaultDialect() {
        if (defaultDialect == null) {
            defaultDialect = new AbstractDialect();
        }
        return defaultDialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dialect getDialectByName(String string) {
        Dialect dialect = (Dialect)databaseNameDialectMap.get(string);
        if (dialect == null) {
            Map map = databaseNameDialectMap;
            synchronized (map) {
                dialect = (Dialect)databaseNameDialectMap.get(string);
                if (dialect == null) {
                    dialect = DialectFactory.generateDialect(string);
                    databaseNameDialectMap.put(string, dialect);
                }
            }
        }
        return dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dialect generateDialect(String string) {
        Dialect dialect;
        Connection connection = null;
        try {
            connection = new NameDatabaseConnection(string).createConnection();
            dialect = DialectFactory.generateDialect(connection);
            Object var5_4 = null;
        }
        catch (Exception exception) {
            Dialect dialect2;
            try {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                dialect2 = DialectFactory.getDefaultDialect();
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                DBUtils.closeConnection(connection);
                throw throwable;
            }
            DBUtils.closeConnection(connection);
            return dialect2;
        }
        DBUtils.closeConnection(connection);
        return dialect;
    }

    public static Dialect try2GenerateDialectByDriver(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        Dialect dialect = DialectFactory.getDialectFromExtraDriver(string);
        if (dialect != null) {
            return dialect;
        }
        return DialectFactory.getDialectFromEmbDriver(string);
    }

    private static Dialect getDialectFromExtraDriver(String string) {
        try {
            for (DialectCreator dialectCreator : DialectFactory.getExtraDialectCreators()) {
                Class<?> clazz = dialectCreator.generate(UrlDriver.UrlDriverInstance.getInstance(string));
                if (clazz == null) continue;
                return (Dialect)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return null;
    }

    private static Dialect getDialectFromEmbDriver(String string) {
        if (string.contains("hsqldb")) {
            return new HSQLDialect();
        }
        if (string.contains("oracle")) {
            return new OracleDialect();
        }
        if (string.contains("db2")) {
            return new DB2Dialect();
        }
        if (string.contains("sqlserver")) {
            return new MSSQLDialect();
        }
        if (string.contains("mysql")) {
            return new MySQLDialect();
        }
        if (string.contains("sybase")) {
            return new SybaseDialect();
        }
        if (string.contains("derby")) {
            return new DerbyDialect();
        }
        if (string.contains("postgresql")) {
            return new PostgreSQLDialect();
        }
        if (string.contains("sqlite")) {
            return new SQLiteDialect();
        }
        if (string.contains("Hive")) {
            return new HiveDialect();
        }
        return null;
    }

    public static Dialect generateDialect(Connection connection, String string) {
        Dialect dialect = DialectFactory.try2GenerateDialectByDriver(string);
        if (dialect != null) {
            return dialect;
        }
        return DialectFactory.generateDialect(connection);
    }

    public static Dialect generateDialect(Connection connection) {
        Dialect dialect = DialectFactory.getDialectFromExtraMetadata(connection);
        if (dialect != null) {
            return dialect;
        }
        return DialectFactory.getDialectFromMetadata(connection);
    }

    private static Dialect getDialectFromExtraMetadata(Connection connection) {
        try {
            for (DialectCreator dialectCreator : DialectFactory.getExtraDialectCreators()) {
                Class<?> clazz = dialectCreator.generate(connection);
                if (clazz == null) continue;
                return (Dialect)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return null;
    }

    private static DialectCreator[] getExtraDialectCreators() {
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null) {
            Set<DialectCreator> set = extraClassManagerProvider.getArray("DialectCreator");
            return set.toArray(new DialectCreator[set.size()]);
        }
        return new DialectCreator[0];
    }

    private static Dialect getDialectFromMetadata(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            int n2 = -1;
            try {
                n2 = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (StringUtils.isBlank(string)) {
                return DialectFactory.getDefaultDialect();
            }
            DBDialectMapper dBDialectMapper = (DBDialectMapper)dialectMap.get(string);
            if (dBDialectMapper == null) {
                return DialectFactory.getDefaultDialect();
            }
            return dBDialectMapper.getDialect(n2);
        }
        catch (SQLException sQLException) {
            return DialectFactory.getDefaultDialect();
        }
    }

    static {
        dialectMap = new HashMap();
        databaseNameDialectMap = new HashMap();
        dialectMap.put("Oracle", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                if (n2 < 9) {
                    return new Oracle8iDialect();
                }
                if (n2 > 9) {
                    return new Oracle10gDialect();
                }
                return new OracleDialect();
            }
        });
        dialectMap.put("Microsoft SQL Server", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                MSSQLDialect mSSQLDialect;
                switch (n2) {
                    case 8: {
                        mSSQLDialect = new MSSQL2000Dialect();
                        break;
                    }
                    case 9: {
                        mSSQLDialect = new MSSQL2005Dialect();
                        break;
                    }
                    case 10: {
                        mSSQLDialect = new MSSQL2008Dialect();
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        mSSQLDialect = new MSSQL2012Dialect();
                        break;
                    }
                    default: {
                        mSSQLDialect = new MSSQLDialect();
                    }
                }
                return mSSQLDialect;
            }
        });
        dialectMap.put("Microsoft SQL Server Database", new VersionInsensitiveMapper(MSSQLDialect.class.getName()));
        dialectMap.put("ACCESS", new VersionInsensitiveMapper(AccessDialect.class.getName()));
        dialectMap.put("Sybase SQL Server", new VersionInsensitiveMapper(SybaseDialect.class.getName()));
        dialectMap.put("Adaptive Server Enterprise", new VersionInsensitiveMapper(SybaseDialect.class.getName()));
        dialectMap.put("HSQL Database Engine", new VersionInsensitiveMapper(HSQLDialect.class.getName()));
        dialectMap.put("H2", new VersionInsensitiveMapper(H2Dialect.class.getName()));
        dialectMap.put("MySQL", new VersionInsensitiveMapper(MySQLDialect.class.getName()));
        dialectMap.put("PostgreSQL", new VersionInsensitiveMapper(PostgreSQLDialect.class.getName()));
        dialectMap.put("Apache Derby", new VersionInsensitiveMapper(DerbyDialect.class.getName()));
        dialectMap.put("Informix Dynamic Server", new VersionInsensitiveMapper(InformixDialect.class.getName()));
        dialectMap.put("SQLite", new VersionInsensitiveMapper(SQLiteDialect.class.getName()));
        DBDialectMapper dBDialectMapper = new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                switch (n2) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        };
        dialectMap.put("DB2/NT", dBDialectMapper);
        dialectMap.put("DB2/LINUX", dBDialectMapper);
        dialectMap.put("DB2/6000", dBDialectMapper);
        dialectMap.put("DB2/HPUX", dBDialectMapper);
        dialectMap.put("DB2/SUN", dBDialectMapper);
        dialectMap.put("DB2/LINUX390", dBDialectMapper);
        dialectMap.put("DB2/AIX64", dBDialectMapper);
        dialectMap.put("DB2/LINUXX8664", dBDialectMapper);
        dialectMap.put("DB2/NT64", dBDialectMapper);
    }

    private static class VersionInsensitiveMapper
    implements DBDialectMapper {
        String dialectClass = null;

        public VersionInsensitiveMapper(String string) {
            this.dialectClass = string;
        }

        public Dialect getDialect(int n2) {
            try {
                return (Dialect)GeneralUtils.classForName(this.dialectClass).newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
                return DialectFactory.getDefaultDialect();
            }
        }
    }

    private static interface DBDialectMapper {
        public Dialect getDialect(int var1);
    }
}

