/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc.cache;

import com.fr.cluster.rpc.exception.CacheUnavailableException;
import com.fr.general.ComparatorUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accelerator<K, V> {
    public static final long INTERVAL = 2048L;
    public static final int THRESHOLD = 0;
    public static final boolean ENABLE = true;
    private long intervalTime = 2048L;
    private int cacheThreshold = 0;
    protected Map<K, V> caches = new HashMap();
    private Map<K, Integer> cacheCounts = new HashMap<K, Integer>();
    private Map<K, Long> lastTimes = new HashMap<K, Long>();

    public Accelerator(int n2, long l2) {
        this.cacheThreshold = n2;
        this.intervalTime = l2;
    }

    public Accelerator() {
    }

    protected boolean canRead(K k2) {
        this.updateTime(k2);
        return this.isAchieved(k2);
    }

    protected void cache(K k2, V v2) {
        this.updateResult(k2, v2);
    }

    protected V read(K k2) throws CacheUnavailableException {
        if (this.canRead(k2)) {
            return this.caches.get(k2);
        }
        throw new CacheUnavailableException("need to cache first.");
    }

    private void updateTime(K k2) {
        if (this.isBeyondTimeLimit(k2)) {
            this.clearCount(k2);
        }
        this.recordOneInvoke(k2);
    }

    private void updateResult(K k2, V v2) {
        if (!this.isEquals(k2, v2)) {
            if (this.caches.containsKey(k2)) {
                this.caches.remove(k2);
            }
            this.clearCount(k2);
            this.caches.put(k2, v2);
        }
        this.recordCacheUpdate(k2);
    }

    protected boolean isEquals(K k2, V v2) {
        if (this.caches.containsKey(k2)) {
            V v3 = this.caches.get(k2);
            return ComparatorUtils.equals(v3, v2);
        }
        return false;
    }

    private void recordOneInvoke(K k2) {
        this.recordLastTime(k2);
    }

    private void recordCacheUpdate(K k2) {
        this.increaseCount(k2);
        this.recordOneInvoke(k2);
    }

    private boolean isAchieved(K k2) {
        if (this.cacheCounts.containsKey(k2)) {
            return this.cacheCounts.get(k2) > this.cacheThreshold;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCount(K k2) {
        Accelerator accelerator = this;
        synchronized (accelerator) {
            this.cacheCounts.put(k2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseCount(K k2) {
        Accelerator accelerator = this;
        synchronized (accelerator) {
            if (this.cacheCounts.containsKey(k2)) {
                this.cacheCounts.put(k2, this.cacheCounts.get(k2) + 1);
            } else {
                this.cacheCounts.put(k2, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordLastTime(K k2) {
        Accelerator accelerator = this;
        synchronized (accelerator) {
            this.lastTimes.put(k2, System.currentTimeMillis());
        }
    }

    private boolean isBeyondTimeLimit(K k2) {
        if (!this.lastTimes.containsKey(k2)) {
            return false;
        }
        long l2 = this.lastTimes.get(k2);
        return System.currentTimeMillis() - l2 >= this.intervalTime;
    }

    public void refreshCache() {
        this.caches.clear();
        this.cacheCounts.clear();
        this.lastTimes.clear();
    }

    public void refreshCache(K k2) {
        this.caches.remove(k2);
        this.cacheCounts.remove(k2);
        this.lastTimes.remove(k2);
    }
}

