/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc;

import com.fr.cluster.rpc.CacheContainer;
import com.fr.cluster.rpc.DeltaSkeletonLocalization;
import com.fr.cluster.rpc.RPCClient;
import com.fr.cluster.rpc.RPCUtil;
import com.fr.cluster.rpc.Result;
import com.fr.cluster.rpc.SkeletonLocalization;
import com.fr.cluster.rpc.SocketClient;
import com.fr.cluster.rpc.exception.ParamSerializableException;
import com.fr.cluster.rpc.exception.SkeletonIsNullException;
import com.fr.general.FRLogger;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RPCProxyHandler
implements InvocationHandler,
Serializable {
    private RPCClient RPCClient;
    private Map<String, Object> ignoredMethod;
    private SkeletonLocalization skeletonLocalization;

    public RPCProxyHandler(RPCClient rPCClient, Map<String, Object> map, Boolean bl) {
        this(rPCClient, map, bl != false ? new ArrayList() : null);
    }

    private RPCProxyHandler(RPCClient rPCClient, Map<String, Object> map, ArrayList<String> arrayList) {
        this.RPCClient = rPCClient;
        this.ignoredMethod = map;
        if (arrayList != null) {
            this.skeletonLocalization = new DeltaSkeletonLocalization(rPCClient, arrayList);
            CacheContainer.getInstance().register(rPCClient.getClassName(), this.skeletonLocalization);
        } else {
            this.skeletonLocalization = null;
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (this.ignoredMethod.containsKey(method.getName())) {
            return this.ignoredMethod.get(method.getName());
        }
        try {
            if (this.isLocalizeAvailable(method, objectArray)) {
                return this.skeletonLocalization.fetch(method, objectArray);
            }
        }
        catch (SkeletonIsNullException skeletonIsNullException) {
            FRLogger.getLogger().info("remote object localization is vacancy,so need to provoke the remote object");
        }
        SocketClient socketClient = null;
        try {
            socketClient = objectArray == null ? this.RPCClient.perceive(method) : this.RPCClient.perceive(method, objectArray);
        }
        catch (ParamSerializableException paramSerializableException) {
            FRLogger.getLogger().error(paramSerializableException.getMessage());
        }
        if (socketClient == null) {
            return null;
        }
        if (!RPCUtil.equalsTool(method.getReturnType(), Void.TYPE)) {
            Result result = null;
            result = (Result)this.RPCClient.readResult(socketClient);
            if (result == null) {
                this.subsequentProcess(method, objectArray);
                throw new Exception("the rpc result wrong");
            }
            result.assignmentReturnParameter(objectArray);
            this.subsequentProcess(method, objectArray);
            return result.getReturnValue(method);
        }
        Result result = (Result)this.RPCClient.readResult(socketClient);
        if (result != null) {
            result.assignmentReturnParameter(objectArray);
            this.subsequentProcess(method, objectArray);
        }
        return null;
    }

    private void subsequentProcess(Method method, Object[] objectArray) {
        if (this.skeletonLocalization != null) {
            this.skeletonLocalization.subsequentProcess(method, objectArray);
        }
    }

    private boolean isLocalizeAvailable(Method method, Object[] objectArray) throws Throwable {
        return this.skeletonLocalization != null && this.skeletonLocalization.isAvailable(method, objectArray);
    }
}

