/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.module;

import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.ChartCollection;
import com.fr.chart.chartattr.ChartGetter;
import com.fr.chart.chartattr.ChartPainter;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.chart.charttypes.ChartTypeManager;
import com.fr.chart.web.Chart4BSService;
import com.fr.chart.web.ChartBitMapInitService;
import com.fr.chart.web.ChartRelateService;
import com.fr.chart.web.ChartSvgInitService;
import com.fr.chart.web.ChartletCreator;
import com.fr.general.Inter;
import com.fr.module.BaseModule;
import com.fr.stable.ArrayUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.Service;
import com.fr.stable.plugin.ExtraChartTypeClassManagerProvider;
import com.fr.stable.web.WebletCreator;

public class ChartModule
extends BaseModule {
    public void start() {
        super.start();
        this.init();
    }

    public void init() {
        this.registerXML4Chart();
        this.registerData4Chart();
    }

    private void registerXML4Chart() {
        StableFactory.registerXMLDescription("CC", new ChartCollection());
        StableFactory.registerXMLDescription("CP", new ChartPainter());
        StableFactory.registerXMLDescription("Chart", new Chart());
    }

    private void registerData4Chart() {
        StableFactory.registerMarkedClass("BaseChartGetter", ChartGetter.class);
        StableFactory.registerMarkedClass("ExtraChartTypeClassManagerProvider", ChartTypeManager.class);
        StableFactory.registerMarkedClass("BaseMapAreaValue", MapAreaValue.class);
        StableFactory.registerMarkedClass("BaseMapTitleValue", MapTitleValue.class);
        StableFactory.getStaticMarkedInstanceObjectFromClass("ExtraChartTypeClassManagerProvider", ExtraChartTypeClassManagerProvider.class);
    }

    public String[] getChartFiles4WebClient() {
        return ChartTypeManager.getInstance().getUsedJSFiles();
    }

    public String[] getChartFiles4IEWebClient() {
        String[] stringArray = this.getChartFiles4WebClient();
        String[] stringArray2 = new String[]{"/com/fr/web/core/js/excanvas.js"};
        return ArrayUtils.addAll(stringArray, stringArray2);
    }

    public Service[] service4Register() {
        return ArrayUtils.addAll(super.service4Register(), new Service[]{new Chart4BSService(), new ChartRelateService(), new ChartSvgInitService(), new ChartBitMapInitService()});
    }

    public WebletCreator[] webletCreator4Register() {
        return ArrayUtils.addAll(super.webletCreator4Register(), new WebletCreator[]{ChartletCreator.getInstance()});
    }

    public String getInterNationalName() {
        return Inter.getLocText("FR-Chart-Chart_Module");
    }

    public String[] getLocaleFile() {
        return new String[]{"com/fr/chart/locale/chart"};
    }
}

