/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.charttypes;

import com.fr.base.CoreDecimalFormat;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrContents;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.ChartFactory;
import com.fr.chart.chartattr.Pie3DPlot;
import com.fr.chart.chartattr.PiePlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.fun.impl.AbstractIndependentDefaultChartProviderWithAPILevel;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import java.awt.Color;
import java.text.DecimalFormat;

public class PieIndependentChart
extends AbstractIndependentDefaultChartProviderWithAPILevel {
    public static Chart[] pieChartTypes = PieIndependentChart.initPieCharts();

    private static Chart[] initPieCharts() {
        return new Chart[]{PieIndependentChart.createPieChart(1), PieIndependentChart.createPie3DChart()};
    }

    public String getChartName() {
        return "ChartF-Pie";
    }

    public Chart[] getChartTypes() {
        return pieChartTypes;
    }

    private static Chart createPieChart(int n2) {
        PiePlot piePlot = new PiePlot();
        piePlot.setSubType(n2);
        PieIndependentChart.createPieCondition(piePlot);
        return new Chart(piePlot);
    }

    private static Chart createPie3DChart() {
        Pie3DPlot pie3DPlot = new Pie3DPlot();
        PieIndependentChart.createPieCondition(pie3DPlot);
        return new Chart(pie3DPlot);
    }

    private static void createPieCondition(Plot plot) {
        ConditionCollection conditionCollection = plot.getConditionCollection();
        AttrBorder attrBorder = conditionCollection.getDefaultAttr().getExisted(AttrBorder.class);
        if (attrBorder == null) {
            attrBorder = new AttrBorder();
            conditionCollection.getDefaultAttr().addDataSeriesCondition(attrBorder);
        }
        attrBorder.setBorderColor(Color.WHITE);
        attrBorder.setBorderStyle(1);
        ChartFactory.setChartFontAttr(plot);
        AttrContents attrContents = new AttrContents("${VALUE}${PERCENT}");
        plot.setHotTooltipStyle(attrContents);
        attrContents.setFormat(new CoreDecimalFormat(new DecimalFormat("#.##"), "#.##"));
        attrContents.setPercentFormat(new CoreDecimalFormat(new DecimalFormat("#.##%"), "#.##%"));
    }

    static {
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStart() {
                if (pieChartTypes == null) {
                    pieChartTypes = PieIndependentChart.initPieCharts();
                }
            }

            public void onServletStop() {
                pieChartTypes = null;
            }
        });
    }
}

