/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.ColorInfo;
import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.Object3D;
import com.fr.chart.chartglyph.Pie3D;
import com.fr.chart.chartglyph.Projection;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.general.ComparatorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class Ring3D
extends SpecialGlyph
implements Object3D {
    private Projection projection = new Projection();
    private static final double DET_S = 0.1;
    private static final double DET_B = -0.15;
    private ArrayList outerCylinderList = new ArrayList();
    private ArrayList innerCylinderList = new ArrayList();
    private ArrayList<Cylinder> origin = new ArrayList();

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawBack(graphics2D);
        this.drawSide(graphics2D);
        this.drawPositive(graphics2D);
        this.drawTop(graphics2D);
    }

    public void drawPositive(Graphics2D graphics2D) {
        Paint paint = graphics2D.getPaint();
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            ColorInfo colorInfo;
            Color color;
            Cylinder cylinder = this.getOuterCylinder(i2);
            if (cylinder.getExtent() == 0.0 || (color = (colorInfo = cylinder.getColorInfo()).getSeriesAttrColor().getSeriesColor()) == null) continue;
            graphics2D.setPaint(ChartUtils.getColorFromBaseColor(color, 0.0, 0.1, -0.1));
            graphics2D.fill(cylinder.getBack());
        }
        graphics2D.setPaint(paint);
    }

    public void drawTop(Graphics2D graphics2D) {
        Paint paint = graphics2D.getPaint();
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            ColorInfo colorInfo;
            Color color;
            Cylinder cylinder = this.getOuterCylinder(i2);
            if (cylinder.getExtent() == 0.0 || (color = (colorInfo = cylinder.getColorInfo()).getSeriesAttrColor().getSeriesColor()) == null) continue;
            Area area = new Area(cylinder.top());
            area.subtract(new Area(this.getInnerCylinder(i2).top()));
            Arc2D arc2D = cylinder.top();
            Arc2D arc2D2 = this.getInnerCylinder(i2).top();
            double d2 = arc2D.getWidth();
            double d3 = arc2D.getHeight();
            double d4 = arc2D.getWidth() / 2.0;
            double d5 = d2 / 2.0 / d4;
            double d6 = d3 / 2.0 / d4;
            graphics2D.scale(d5, d6);
            Color color2 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.2, 0.25);
            float[] fArray = new float[]{0.0f, 1.0f};
            Color[] colorArray = new Color[]{color2, color};
            RadialGradientPaint radialGradientPaint = new RadialGradientPaint((float)(arc2D.getCenterX() / d5), (float)(arc2D.getCenterY() / d6), (float)d4, fArray, colorArray);
            graphics2D.setPaint((Paint)radialGradientPaint);
            Arc2D.Double double_ = new Arc2D.Double(arc2D.getX() / d5, arc2D.getY() / d6, d2, d2, arc2D.getAngleStart() + arc2D.getAngleExtent(), -arc2D.getAngleExtent(), 0);
            Arc2D.Double double_2 = new Arc2D.Double(arc2D2.getX() / d5, arc2D2.getY() / d6, arc2D2.getWidth(), arc2D2.getWidth(), arc2D2.getAngleStart(), arc2D2.getAngleExtent(), 0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)double_.getStartPoint().getX(), (float)double_.getStartPoint().getY());
            generalPath.append(double_, true);
            generalPath.lineTo((float)double_2.getStartPoint().getX(), (float)double_2.getStartPoint().getY());
            generalPath.append(double_2, true);
            generalPath.closePath();
            graphics2D.fill(generalPath);
            graphics2D.scale(1.0 / d5, 1.0 / d6);
        }
        graphics2D.setPaint(paint);
    }

    public void drawSide(Graphics2D graphics2D) {
        ArrayList<Cylinder.CylinderSide> arrayList = new ArrayList<Cylinder.CylinderSide>();
        ArrayList<Cylinder.CylinderSide> arrayList2 = new ArrayList<Cylinder.CylinderSide>();
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            if (this.getOuterCylinder(i2).isStartEnable()) {
                arrayList.add(new Cylinder.CylinderSide(this.getOuterCylinder(i2), true));
                arrayList2.add(new Cylinder.CylinderSide(this.getInnerCylinder(i2), true));
            }
            if (!this.getOuterCylinder(i2).isEndEnable()) continue;
            arrayList.add(new Cylinder.CylinderSide(this.getOuterCylinder(i2), false));
            arrayList2.add(new Cylinder.CylinderSide(this.getInnerCylinder(i2), false));
        }
        Object[] objectArray = arrayList.toArray(new Cylinder.CylinderSide[0]);
        Object[] objectArray2 = arrayList2.toArray(new Cylinder.CylinderSide[0]);
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        for (int i3 = 0; i3 < objectArray.length; ++i3) {
            Object object = objectArray[i3];
            Object object2 = objectArray2[i3];
            Ring3D ring3D = new Ring3D();
            ring3D.setProjection(this.projection);
            ring3D.addCylinder(((Cylinder.CylinderSide)object).cylinder, ((Cylinder.CylinderSide)object2).cylinder);
            if (((Cylinder.CylinderSide)object).isStart && ((Cylinder.CylinderSide)object).cylinder.isStartEnable()) {
                ring3D.paintStartSide(graphics2D);
                continue;
            }
            if (((Cylinder.CylinderSide)object).isStart || !((Cylinder.CylinderSide)object).cylinder.isEndEnable()) continue;
            ring3D.paintEndSide(graphics2D);
        }
    }

    private Color getSideColor(Color color) {
        return ChartUtils.getColorFromBaseColor(color, 0.0, 0.1, -0.15);
    }

    public void paintStartSide(Graphics2D graphics2D) {
        Paint paint = graphics2D.getPaint();
        Cylinder cylinder = this.getOuterCylinder(0);
        Cylinder cylinder2 = this.getInnerCylinder(0);
        Color color = cylinder.getColorInfo().getSeriesAttrColor().getSeriesColor();
        if (color != null) {
            graphics2D.setPaint(this.getSideColor(color));
            GeneralPath generalPath = new GeneralPath();
            Point2D point2D = cylinder2.bottom().getStartPoint();
            Point2D point2D2 = cylinder2.top().getStartPoint();
            Point2D point2D3 = cylinder.bottom().getStartPoint();
            Point2D point2D4 = cylinder.top().getStartPoint();
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.closePath();
            graphics2D.fill(generalPath);
        }
        graphics2D.setPaint(paint);
    }

    public void paintEndSide(Graphics2D graphics2D) {
        Paint paint = graphics2D.getPaint();
        Cylinder cylinder = this.getOuterCylinder(0);
        Cylinder cylinder2 = this.getInnerCylinder(0);
        Color color = cylinder.getColorInfo().getSeriesAttrColor().getSeriesColor();
        if (color != null) {
            graphics2D.setPaint(this.getSideColor(color));
            GeneralPath generalPath = new GeneralPath();
            Point2D point2D = cylinder2.bottom().getEndPoint();
            Point2D point2D2 = cylinder2.top().getEndPoint();
            Point2D point2D3 = cylinder.bottom().getEndPoint();
            Point2D point2D4 = cylinder.top().getEndPoint();
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.closePath();
            graphics2D.fill(generalPath);
        }
        graphics2D.setPaint(paint);
    }

    public void drawBack(Graphics2D graphics2D) {
        Paint paint = graphics2D.getPaint();
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            ColorInfo colorInfo;
            Color color;
            Cylinder cylinder = this.getInnerCylinder(i2);
            if (cylinder.getExtent() == 0.0 || (color = (colorInfo = cylinder.getColorInfo()).getSeriesAttrColor().getSeriesColor()) == null) continue;
            graphics2D.setPaint(color);
            graphics2D.fill(cylinder.getNegtiveBack());
        }
        graphics2D.setPaint(paint);
    }

    public Ring3D calculateFrontHalf() {
        Ring3D ring3D = new Ring3D();
        ring3D.setProjection(this.projection);
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            Cylinder[] cylinderArray;
            Cylinder[] cylinderArray2 = this.getOuterCylinder(i2).getFrontPie3d();
            if (cylinderArray2.length != (cylinderArray = this.getInnerCylinder(i2).getFrontPie3d()).length) continue;
            for (int i3 = 0; i3 < cylinderArray2.length; ++i3) {
                ring3D.addCylinder(cylinderArray2[i3], cylinderArray[i3]);
                ring3D.addOrigin(this.getOuterCylinder(i2));
            }
        }
        return ring3D;
    }

    public Ring3D calculateBackHalf() {
        Ring3D ring3D = new Ring3D();
        ring3D.setProjection(this.projection);
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            Cylinder[] cylinderArray;
            Cylinder[] cylinderArray2 = this.getOuterCylinder(i2).getBackPie3d();
            if (cylinderArray2.length != (cylinderArray = this.getInnerCylinder(i2).getBackPie3d()).length) continue;
            for (int i3 = 0; i3 < cylinderArray2.length; ++i3) {
                ring3D.addCylinder(cylinderArray2[i3], cylinderArray[i3]);
                ring3D.addOrigin(this.getOuterCylinder(i2));
            }
        }
        return ring3D;
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        return generalPath;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void addCylinder(Cylinder cylinder, Cylinder cylinder2) {
        this.outerCylinderList.add(cylinder);
        this.innerCylinderList.add(cylinder2);
    }

    public void addOrigin(Cylinder cylinder) {
        this.origin.add(cylinder);
    }

    public Cylinder getOuterCylinder(int n2) {
        return (Cylinder)this.outerCylinderList.get(n2);
    }

    public Cylinder getInnerCylinder(int n2) {
        return (Cylinder)this.innerCylinderList.get(n2);
    }

    public int getCylinderCount() {
        return this.innerCylinderList.size();
    }

    public void clearCylinder() {
        this.innerCylinderList.clear();
        this.outerCylinderList.clear();
    }

    public Point2D getTopCenterPoint() {
        Point2D point2D = this.getInnerCylinder(0).topMiddleEdgePoint();
        Point2D point2D2 = this.getOuterCylinder(0).topMiddleEdgePoint();
        return new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pie3D)) {
            return false;
        }
        Ring3D ring3D = (Ring3D)object;
        if (!ComparatorUtils.equals(ring3D.getProjection(), this.getProjection())) {
            return false;
        }
        if (ring3D.getCylinderCount() != this.getCylinderCount()) {
            return false;
        }
        for (int i2 = 0; i2 < ring3D.getCylinderCount(); ++i2) {
            if (ring3D.getInnerCylinder(i2) == null || ring3D.getOuterCylinder(i2) == null || !(!ComparatorUtils.equals(ring3D.getInnerCylinder(i2), this.getInnerCylinder(i2)) | !ComparatorUtils.equals(ring3D.getOuterCylinder(i2), this.getOuterCylinder(i2)))) continue;
            return false;
        }
        return true;
    }
}

