/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Pie;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Pie3D;
import com.fr.chart.chartglyph.PiePlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Pie3DPlotGlyph
extends PiePlotGlyph {
    private static final long serialVersionUID = -8454922131125531977L;
    private static final double BIG_ELLIPSE_WIDTH = 1.2;
    private static final double BIG_ELLIPSE_HEIGHT = 0.93;
    private static final double THICKNESS = 5.0;
    private static final double ROUND = 360.0;
    private int depth = 20;
    private Projection projection = new Projection();
    private Pie3D pie3d = new Pie3D();

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setDepth(int n2) {
        this.depth = n2;
    }

    public boolean equals(Object object) {
        return object instanceof Pie3DPlotGlyph && super.equals(object) && ((Pie3DPlotGlyph)object).depth == this.depth && ComparatorUtils.equals(((Pie3DPlotGlyph)object).projection, this.projection);
    }

    public void draw(Graphics graphics, int n2) {
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.pie3d.drawWithoutSide(graphics2D, n2);
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.getSeries(i2).drawLabel(graphics, n2);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public String getPlotGlyphType() {
        return "Pie3DPlotGlyph";
    }

    public Object clone() throws CloneNotSupportedException {
        Pie3DPlotGlyph pie3DPlotGlyph = (Pie3DPlotGlyph)super.clone();
        if (this.projection != null) {
            pie3DPlotGlyph.projection = (Projection)this.projection.clone();
        }
        return pie3DPlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("depth", this.depth);
        jSONObject.put("projection", this.projection.toJSONObject());
        return jSONObject;
    }

    protected boolean isSmallerThan(PiePlotGlyph.PointAndAngle pointAndAngle, PiePlotGlyph.PointAndAngle pointAndAngle2) {
        Pie3D pie3D = (Pie3D)pointAndAngle.dataPoint4Pie.getDrawImpl();
        Pie3D pie3D2 = (Pie3D)pointAndAngle2.dataPoint4Pie.getDrawImpl();
        return pie3D.getCylinder(0).getExtent() < pie3D2.getCylinder(0).getExtent();
    }

    public void layoutDataSeriesGlyph(int n2) {
        this.pie3d.clearCylinder();
        for (int i2 = 0; i2 < this.getCategoryCount(); ++i2) {
            this.deal4EachCategory(i2, n2);
        }
        this.dealLabelBoundsInOrder();
    }

    protected void deal4EachCategory(int n2, int n3) {
        double d2 = this.getBounds().getWidth() / (double)this.getCategoryCount();
        this.initLabelData(n2, n3);
        GeneralPath generalPath = new GeneralPath();
        this.pie3d.setProjection(this.projection);
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
            if (dataPoint4Pie.isValueIsNull()) continue;
            Pie3D pie3D = new Pie3D();
            pie3D.setProjection(this.projection);
            double d3 = this.getSeriesStartAngle(n2, i2);
            double d4 = (double)n2 * d2 + d2 / 2.0;
            Point2D.Double double_ = new Point2D.Double(d4, this.getBounds().getHeight() / 2.0);
            double d5 = this.radius / 5.0;
            Cylinder cylinder = new Cylinder(0.0, d5, this.radius);
            cylinder.setX(((Point2D)double_).getX());
            cylinder.setY(((Point2D)double_).getY());
            cylinder.setStart(d3);
            cylinder.setExtent(this.getPercent(i2, n2) * 360.0);
            cylinder.setProjection(this.projection);
            this.getConditionCollection().changeStyleConditionWithInfo(cylinder.getColorInfo(), dataPoint4Pie, this.createColors4Series());
            pie3D.addCylinder(cylinder);
            this.pie3d.addCylinder(cylinder);
            dataPoint4Pie.setDrawImpl(pie3D);
        }
        this.dealWithCategoryLabels(n2, n3);
    }

    protected boolean adjustLabelBoundsY(GeneralPath generalPath, PiePlotGlyph.PointAndAngle pointAndAngle, int n2, double d2, double d3, boolean bl) {
        Rectangle2D rectangle2D = pointAndAngle.dataPoint4Pie.getDataLabel().getBounds();
        double d4 = pointAndAngle.centerAngle;
        while (generalPath.intersects(rectangle2D)) {
            d4 = bl ? (d4 += 1.0) : (d4 -= 1.0);
            this.calculateLabelBoundsWithAngle(d4, pointAndAngle, n2, rectangle2D);
        }
        pointAndAngle.dataPoint4Pie.getDataLabel().setBounds(rectangle2D);
        generalPath.append(rectangle2D, false);
        if (d4 < d2 || d4 > d3) {
            return false;
        }
        if (!this.isGuideLineShow(pointAndAngle.dataPoint4Pie) || !pointAndAngle.dataPoint4Pie.isShowLabel()) {
            return true;
        }
        this.dealWidth3DLine(null, pointAndAngle, d4);
        return true;
    }

    protected void dealWidthLine(Point2D point2D, PiePlotGlyph.PointAndAngle pointAndAngle) {
        this.dealWidth3DLine(point2D, pointAndAngle, pointAndAngle.centerAngle);
    }

    private void dealWidth3DLine(Point2D point2D, PiePlotGlyph.PointAndAngle pointAndAngle, double d2) {
        GeneralPath generalPath = new GeneralPath();
        Pie3D pie3D = (Pie3D)pointAndAngle.dataPoint4Pie.getDrawImpl();
        Cylinder cylinder = pie3D.getCylinder(0);
        Point2D point2D2 = Cylinder.getArcPoint(cylinder.bottom(), pointAndAngle.centerAngle);
        if (pointAndAngle.centerAngle >= 0.0 && pointAndAngle.centerAngle <= 180.0) {
            point2D2 = Cylinder.getArcPoint(cylinder.top(), pointAndAngle.centerAngle);
        }
        double d3 = point2D2.getX();
        double d4 = point2D2.getY();
        generalPath.moveTo(d3, d4);
        Arc2D arc2D = cylinder.top();
        double d5 = arc2D.getWidth() / 2.0;
        Arc2D.Double double_ = new Arc2D.Double(new Rectangle((int)(arc2D.getCenterX() - d5 * 1.2), (int)(arc2D.getCenterY() - 0.93 * d5), (int)(arc2D.getWidth() * 1.2), (int)(arc2D.getWidth() * 0.93)), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
        point2D2 = Cylinder.getArcPoint(double_, d2);
        d3 = point2D2.getX();
        d4 = point2D2.getY();
        generalPath.lineTo(d3, d4);
        d3 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? (d3 -= this.radius * 0.1) : (d3 += this.radius * 0.1);
        generalPath.lineTo(d3, d4);
        pointAndAngle.dataPoint4Pie.setLeadLine(generalPath);
    }

    protected Point2D calculateLabelBoundsWithAngle(double d2, PiePlotGlyph.PointAndAngle pointAndAngle, int n2, Rectangle2D rectangle2D) {
        int n3 = pointAndAngle.dataPoint4Pie.getSeriesIndex();
        int n4 = pointAndAngle.dataPoint4Pie.getCategoryIndex();
        Point2D point2D = this.getCenterPoint(n3, n4);
        Dimension2D dimension2D = this.getLabelDim(pointAndAngle.dataPoint4Pie, n2);
        double d3 = dimension2D.getHeight();
        double d4 = dimension2D.getWidth();
        Pie3D pie3D = (Pie3D)pointAndAngle.dataPoint4Pie.getDrawImpl();
        Cylinder cylinder = pie3D.getCylinder(0);
        Arc2D arc2D = cylinder.top();
        double d5 = arc2D.getWidth() / 2.0;
        Arc2D.Double double_ = new Arc2D.Double(new Rectangle((int)(arc2D.getCenterX() - d5 * 1.2), (int)(arc2D.getCenterY() - 0.93 * d5), (int)(arc2D.getWidth() * 1.2), (int)(arc2D.getWidth() * 0.93)), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
        Point2D point2D2 = Cylinder.getArcPoint(double_, d2);
        double d6 = point2D2.getX();
        double d7 = point2D2.getY();
        double d8 = this.radius * 0.1 + 2.0;
        if (pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0) {
            rectangle2D.setRect(d6 - d8 - d4, d7 - d3 / 2.0, d4, d3);
        } else {
            rectangle2D.setRect(d6 + d8, d7 - d3 / 2.0, d4, d3);
        }
        return point2D;
    }

    public void dealLeadLineSeries() {
        for (int i2 = 0; i2 < this.getCategoryCount(); ++i2) {
            for (int i3 = 0; i3 < this.getSeriesSize(); ++i3) {
                DataSeries dataSeries = this.getSeries(i3);
                DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(i2);
                if (dataPoint4Pie.isValueIsNull()) continue;
                Pie3D pie3D = (Pie3D)dataPoint4Pie.getDrawImpl();
                Cylinder cylinder = pie3D.getCylinder(0);
                double d2 = this.getHalfAngle(this.getSeriesStartAngle(i2, i3), i3, i2);
                this.dealLeadLine(cylinder.top(), dataPoint4Pie, d2 % 360.0);
            }
        }
    }

    protected void dealInsideLabelBounds(DataPoint dataPoint, int n2) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        Point2D point2D = this.getTopArcCenterPoint(dataPoint);
        if (point2D != null) {
            double d2 = this.getLabelDim(dataPoint, n2).getHeight();
            double d3 = this.getLabelDim(dataPoint, n2).getWidth();
            double d4 = point2D.getX() - d3 / 2.0;
            double d5 = point2D.getY() - d2 / 2.0;
            textGlyph.setBounds(new Rectangle2D.Double(d4, d5, d3, d2));
        } else {
            textGlyph.setBounds(null);
        }
    }

    private Point2D getTopArcCenterPoint(DataPoint dataPoint) {
        if (dataPoint.getDrawImpl() != null) {
            Pie3D pie3D = (Pie3D)dataPoint.getDrawImpl();
            return pie3D.topCenterPoint(new Point2D.Double(this.getBounds().getWidth() / 2.0, this.getBounds().getHeight() / 2.0));
        }
        return null;
    }

    public boolean is3DPlotGlyph() {
        return true;
    }

    public String getChartType() {
        return "Pie3D";
    }

    public String getSmallIconType() {
        return "Pie";
    }

    protected boolean isNotNeedMoveChangeLabelRadius(Shape shape, Rectangle2D rectangle2D) {
        return true;
    }

    public void drawShape4Series(Graphics graphics, int n2) {
        this.pie3d.drawWithoutSide(graphics, n2);
    }

    protected double getPercent(int n2, int n3) {
        double d2 = this.getTotalValue(n3);
        if (d2 <= 0.0) {
            return 0.0;
        }
        DataSeries dataSeries = this.getSeries(n2);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n3);
        return Math.abs(dataPoint4Pie.getValue()) / d2;
    }
}

