/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.CoreDecimalFormat;
import com.fr.base.Formula;
import com.fr.chart.base.AreaColor;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.AxisHelper;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapHotAreaColor
implements XMLable {
    private static final long serialVersionUID = 1532455023184207954L;
    public static final String XML_TAG = "MapHotAreaColor";
    private static final double TEN = 10.0;
    private static final double FOUR = 4.0;
    private static final double BASEVALUE = 0.4;
    public static final int AUTO = 0;
    public static final int CUSTOM = 1;
    private double maxValue = 100.0;
    private double minValue = 0.0;
    private Color mainColor = new Color(36, 167, 255);
    private List areaColorList = new ArrayList();
    private int areaNumber = 5;
    private int useType = 0;

    public void refreshMinMax(double d2, double d3) {
        if (this.useType == 0) {
            this.minValue = d2;
            this.maxValue = d3;
        } else {
            int n2;
            this.areaNumber = n2 = this.areaColorList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
                this.minValue = Math.min(this.minValue, areaColor.getMinNum());
                this.maxValue = Math.max(this.maxValue, areaColor.getMaxNum());
            }
        }
    }

    public int getAreaNumber() {
        return this.areaNumber;
    }

    public void clearColor() {
        this.areaColorList.clear();
    }

    public void addAreaColor(AreaColor areaColor) {
        this.areaColorList.add(areaColor);
    }

    public Color[] initColor() {
        if (this.useType == 0) {
            this.clearColor();
            return MapHotAreaColor.getColorArrayFromMinAndMax(this.getMainColor(), this.areaNumber, this.minValue, this.maxValue, this.areaColorList);
        }
        int n2 = this.areaColorList.size();
        Color[] colorArray = new Color[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
            colorArray[i2] = areaColor.getAreaColor();
        }
        return colorArray;
    }

    public Formula[] initValues() {
        if (this.useType == 1) {
            int n2 = this.areaColorList.size();
            Formula[] formulaArray = new Formula[n2 + 1];
            for (int i2 = 0; i2 < n2; ++i2) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
                formulaArray[i2] = areaColor.getMin();
                formulaArray[i2 + 1] = areaColor.getMax();
            }
            return formulaArray;
        }
        return new Formula[0];
    }

    public void setUseType(int n2) {
        this.useType = n2;
    }

    public int getUseType() {
        return this.useType;
    }

    public void setMainColor(Color color) {
        this.mainColor = color;
    }

    public Color getMainColor() {
        return this.mainColor;
    }

    public List getAreaColorList() {
        return this.areaColorList;
    }

    public void setAreaNumber(int n2) {
        this.areaNumber = n2;
    }

    private boolean isUseChartFormat() {
        boolean bl = true;
        for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
            if (areaColor.getMinNum() == (double)((int)areaColor.getMinNum()) && areaColor.getMaxNum() == (double)((int)areaColor.getMaxNum())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public Color getColorByIndex(int n2) {
        if (n2 < this.areaColorList.size()) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(n2);
            return areaColor.getAreaColor();
        }
        return Color.white;
    }

    public String[] getNumberLabels() {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        String[] stringArray = new String[this.areaColorList.size() + 1];
        for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
            stringArray[i2] = decimalFormat.format(Math.max(areaColor.getMaxNum(), areaColor.getMinNum()));
            if (i2 != this.areaColorList.size() - 1) continue;
            stringArray[i2 + 1] = decimalFormat.format(Math.min(areaColor.getMaxNum(), areaColor.getMinNum()));
        }
        return stringArray;
    }

    public String getMaxLabelWithIndex(int n2) {
        CoreDecimalFormat coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat(), "#.##");
        if (this.areaColorList != null && n2 < this.areaColorList.size()) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(n2);
            return coreDecimalFormat.format(areaColor.getMaxNum());
        }
        return "0";
    }

    public String getMinLabelWithIndex(int n2) {
        CoreDecimalFormat coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat(), "#.##");
        if (this.areaColorList != null && n2 < this.areaColorList.size()) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(n2);
            return coreDecimalFormat.format(areaColor.getMinNum());
        }
        return "0";
    }

    public String getLabelWithInt(int n2) {
        AreaColor areaColor = (AreaColor)this.areaColorList.get(n2);
        boolean bl = this.isUseChartFormat();
        String string = "";
        String string2 = "";
        double d2 = Math.min(areaColor.getMaxNum(), areaColor.getMinNum());
        double d3 = Math.max(areaColor.getMaxNum(), areaColor.getMinNum());
        if (bl) {
            string = ChartBaseUtils.generalFormat(d2);
            string2 = ChartBaseUtils.generalFormat(d3);
        } else {
            CoreDecimalFormat coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat(), "#.##");
            string = coreDecimalFormat.format(d2);
            string2 = coreDecimalFormat.format(d3);
        }
        return string + "--" + string2;
    }

    public int getColorsIndex(double d2) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
            double d3 = Math.min(areaColor.getMinNum(), areaColor.getMaxNum());
            double d4 = Math.max(areaColor.getMinNum(), areaColor.getMaxNum());
            if (!(d3 <= d2) || !(d2 <= d4)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    public Color getColorWithValue(double d2) {
        Color color = Color.white;
        int n2 = this.areaColorList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
            double d3 = Math.min(areaColor.getMinNum(), areaColor.getMaxNum());
            double d4 = Math.max(areaColor.getMinNum(), areaColor.getMaxNum());
            if (!(d3 <= d2) || !(d2 <= d4)) continue;
            color = areaColor.getAreaColor();
            break;
        }
        return color;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        Object[] objectArray = new Object[this.areaColorList.size()];
        for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
            objectArray[i2] = ((AreaColor)this.areaColorList.get(i2)).toJSONObject();
        }
        jSONObject.put("areaColors", objectArray);
        return jSONObject;
    }

    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
            ((AreaColor)this.areaColorList.get(i2)).dependence(calculatorProvider, list);
        }
    }

    public void dealFormula(Calculator calculator) {
        for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
            ((AreaColor)this.areaColorList.get(i2)).dealFormula(calculator);
        }
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals("MC_Attr", string)) {
                this.minValue = xMLableReader.getAttrAsDouble("minValue", 0.0);
                this.maxValue = xMLableReader.getAttrAsDouble("maxValue", 100.0);
                this.useType = xMLableReader.getAttrAsInt("useType", 0);
                this.areaNumber = xMLableReader.getAttrAsInt("areaNumber", 5);
                this.mainColor = xMLableReader.getAttrAsColor("mainColor", null);
            } else if (ComparatorUtils.equals("ColorList", string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && ComparatorUtils.equals(xMLableReader.getTagName(), "AreaColor")) {
                            MapHotAreaColor.this.addAreaColor((AreaColor)xMLableReader.readXMLObject(new AreaColor()));
                        }
                    }
                });
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("MC_Attr").attr("minValue", this.minValue).attr("maxValue", this.maxValue).attr("useType", this.useType).attr("areaNumber", this.areaNumber);
        if (this.mainColor != null) {
            xMLPrintWriter.attr("mainColor", this.mainColor.getRGB());
        }
        xMLPrintWriter.end();
        if (this.areaColorList.size() > 0) {
            xMLPrintWriter.startTAG("ColorList");
            for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
                areaColor.writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MapHotAreaColor mapHotAreaColor = (MapHotAreaColor)super.clone();
        mapHotAreaColor.areaColorList = new ArrayList();
        mapHotAreaColor.clearColor();
        if (!this.areaColorList.isEmpty()) {
            for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
                mapHotAreaColor.addAreaColor((AreaColor)areaColor.clone());
            }
        }
        return mapHotAreaColor;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapHotAreaColor)) {
            return false;
        }
        MapHotAreaColor mapHotAreaColor = (MapHotAreaColor)object;
        if (this.areaColorList.size() != mapHotAreaColor.areaColorList.size()) {
            return false;
        }
        int n2 = this.areaColorList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (ComparatorUtils.equals(this.areaColorList.get(i2), mapHotAreaColor.getAreaColorList().get(i2))) continue;
            return false;
        }
        return this.useType == mapHotAreaColor.useType && this.areaNumber == mapHotAreaColor.areaNumber && ComparatorUtils.equals(this.mainColor, mapHotAreaColor.mainColor);
    }

    public static Color[] getColorArrayFromMinAndMax(Color color, int n2, double d2, double d3, List<AreaColor> list) {
        BigDecimal bigDecimal;
        Color[] colorArray = ChartBaseUtils.createColorsWithHSB(color, n2);
        double d4 = d2;
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d3 - d2));
        double d5 = AxisHelper.getMoveInt(bigDecimal2);
        if (d5 < 0.0) {
            BigDecimal bigDecimal3 = new BigDecimal(Double.toString(d4));
            bigDecimal = new BigDecimal(Math.pow(10.0, 1.0 - d5));
            bigDecimal3 = bigDecimal3.multiply(bigDecimal);
            bigDecimal3 = new BigDecimal(Math.floor(bigDecimal3.doubleValue()));
            bigDecimal3 = bigDecimal3.divide(bigDecimal);
            d4 = bigDecimal3.doubleValue();
        } else {
            int n3 = (int)Math.pow(10.0, d5);
            d4 = Math.floor(d2 / (double)n3) * (double)n3;
        }
        BigDecimal bigDecimal4 = new BigDecimal(Double.toString((double)n2 / 10.0 * Math.pow(10.0, d5)));
        bigDecimal = new BigDecimal(Double.toString(0.0));
        while (bigDecimal.doubleValue() < bigDecimal2.doubleValue()) {
            bigDecimal = bigDecimal.add(bigDecimal4);
        }
        double d6 = bigDecimal.doubleValue() / (double)n2;
        while (d4 + d6 * (double)n2 < d3) {
            bigDecimal = bigDecimal.add(bigDecimal4);
            d6 = bigDecimal.doubleValue() / (double)n2;
        }
        bigDecimal = bigDecimal.divide(new BigDecimal(n2));
        for (int i2 = 0; i2 < n2; ++i2) {
            AreaColor areaColor = new AreaColor(d4 + bigDecimal.multiply(new BigDecimal(n2 - i2 - 1)).doubleValue(), d4 + bigDecimal.multiply(new BigDecimal(n2 - i2)).doubleValue(), colorArray[i2]);
            list.add(i2, areaColor);
        }
        return colorArray;
    }
}

