/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.MapHotAreaColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class HeatMapControlBar {
    public static final int BAR_LONG = 26;
    public static final int BAR_SHORT = 13;
    public static final int BAR_GAP = 1;
    private int gap = 5;
    private Rectangle2D bounds;
    private int position;
    private MapHotAreaColor mapHotAreaColor;
    private List areaColorBlock;
    private TextAttr textAttr;
    private int resolution;

    public HeatMapControlBar(Rectangle2D rectangle2D, int n2, MapHotAreaColor mapHotAreaColor, int n3, TextAttr textAttr) {
        this.bounds = rectangle2D;
        this.position = n2;
        this.mapHotAreaColor = mapHotAreaColor;
        this.areaColorBlock = new ArrayList();
        this.textAttr = textAttr;
        this.resolution = n3;
        this.layoutAreaColorBlock();
    }

    private void layoutAreaColorBlock() {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.mapHotAreaColor.getAreaNumber();
        int n2 = 26;
        int n3 = 13;
        String string = this.mapHotAreaColor.getMaxLabelWithIndex(0);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.textAttr, this.resolution);
        double d5 = dimension2D.getWidth();
        double d6 = dimension2D.getHeight();
        double d7 = this.bounds.getX();
        double d8 = this.bounds.getY();
        switch (this.position) {
            case 2: {
                d2 = d7 + d5 + (double)this.gap;
                d3 = d8 + d6 / 2.0;
                break;
            }
            case 4: {
                d2 = d7;
                d3 = d8 + d6 / 2.0;
                break;
            }
            default: {
                d2 = d7 + d5 / 2.0;
                d3 = d8 + d6 + (double)this.gap;
            }
        }
        if (this.isInTopOrBottom()) {
            int n4 = 0;
            while ((double)n4 < d4) {
                double d9 = d2 + (double)(n2 * n4) + (double)n4;
                this.areaColorBlock.add(new Rectangle2D.Double(d9, d3, n2, n3));
                ++n4;
            }
        } else {
            int n5 = 0;
            while ((double)n5 < d4) {
                double d10 = d3 + (double)(n2 * n5) + (double)n5;
                this.areaColorBlock.add(new Rectangle2D.Double(d2, d10, n3, n2));
                ++n5;
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n2) {
        if (this.isInTopOrBottom()) {
            this.drawTopOrBottom(graphics2D, n2);
        } else {
            this.drawLeftOrRight(graphics2D, n2);
        }
    }

    private void drawTopOrBottom(Graphics2D graphics2D, int n2) {
        this.drawColorBlocks(graphics2D, n2);
        double d2 = 53.0;
        String[] stringArray = this.mapHotAreaColor.getNumberLabels();
        String string = this.mapHotAreaColor.getMaxLabelWithIndex(0);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.textAttr, n2);
        double d3 = dimension2D.getHeight();
        double d4 = 27.0;
        double d5 = this.bounds.getX();
        double d6 = this.bounds.getY();
        double d7 = this.bounds.getY() + d3 + 5.0 + 13.0 + 5.0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = this.getFinalDrawLabel(stringArray[i2], d2, n2);
            double d8 = i2 % 2 == 0 ? d6 : d7;
            this.drawLabel(graphics2D, string2, d5, d8);
            d5 += d4;
        }
    }

    private void drawLeftOrRight(Graphics2D graphics2D, int n2) {
        this.drawColorBlocks(graphics2D, n2);
        double d2 = this.bounds.getWidth() - 13.0 - 5.0;
        double d3 = this.bounds.getY();
        double d4 = this.position == 4 ? this.bounds.getX() + 13.0 + 5.0 : this.bounds.getX();
        String[] stringArray = this.mapHotAreaColor.getNumberLabels();
        double d5 = 27.0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = this.getFinalDrawLabel(stringArray[i2], d2, n2);
            this.drawLabel(graphics2D, string, d4, d3);
            d3 += d5;
        }
    }

    private void drawColorBlocks(Graphics2D graphics2D, int n2) {
        for (int i2 = 0; i2 < this.areaColorBlock.size(); ++i2) {
            Color color = this.mapHotAreaColor.getColorByIndex(i2);
            graphics2D.setColor(color);
            Rectangle2D rectangle2D = (Rectangle2D)this.areaColorBlock.get(i2);
            graphics2D.fillRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        graphics2D.setColor(Color.black);
    }

    private String getFinalDrawLabel(String string, double d2, int n2) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.textAttr, n2);
        if (dimension2D.getWidth() > d2) {
            return LegendItem.getTextWhenNotEnoughWidth(string, this.textAttr.getFRFont(), d2);
        }
        return string;
    }

    private void drawLabel(Graphics2D graphics2D, String string, double d2, double d3) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.textAttr, this.resolution);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight());
        GlyphUtils.drawStrings(graphics2D, string, this.textAttr, double_, this.resolution);
    }

    private boolean isInTopOrBottom() {
        return this.position == 1 || this.position == 3;
    }
}

