/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.ScreenResolution;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Funnel;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.stable.StringUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class FunnelPlotGlyph
extends PlotGlyph {
    private static final double TOP_BOTTOM_GAP = 0.1;
    private static final double LEFT_RIGHT_GAP = 0.05;
    private static final double LABEL_GAP = 0.06;
    private static final double LEAD_LINE_GAP = 0.01;
    private static final double MAX_LABEL_WIDTH = 0.46;
    private static final double LABEL_VALUE_GAP = 0.02;
    private static final double SERIES_GAP = 1.0;
    private double[] seriesX;
    private double[] seriesY;
    private double[] seriesHeight;
    private double[] seriesWidth;
    private double labelWidth = 0.0;
    private double labelX = 0.0;
    private Point originalPoint;
    private boolean isShowLabel = true;

    private double getTotalValue(int n2) {
        double d2 = 0.0;
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)dataSeries.getDataPoint(n2);
            d2 += Math.abs(dataPoint4Funnel.getValue());
        }
        return d2;
    }

    private double getTotalHeight(int n2) {
        double d2 = 0.0;
        for (int i2 = 1; i2 < this.getSeriesSize(); ++i2) {
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(i2 - 1).getDataPoint(n2);
            DataPoint4Funnel dataPoint4Funnel2 = (DataPoint4Funnel)this.getSeries(i2).getDataPoint(n2);
            d2 += Math.abs(dataPoint4Funnel.getValue() - dataPoint4Funnel2.getValue());
        }
        return d2;
    }

    private void initSeriesHeight(int n2) {
        double d2 = this.getTotalHeight(n2);
        double d3 = this.getBounds().getHeight() * 0.8;
        this.seriesHeight = new double[this.getSeriesSize()];
        this.seriesHeight[0] = 0.0;
        for (int i2 = 1; i2 < this.getSeriesSize(); ++i2) {
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(i2 - 1).getDataPoint(n2);
            DataPoint4Funnel dataPoint4Funnel2 = (DataPoint4Funnel)this.getSeries(i2).getDataPoint(n2);
            this.seriesHeight[i2] = Math.abs(dataPoint4Funnel.getValue() - dataPoint4Funnel2.getValue()) / d2 * d3;
        }
    }

    private void initSeriesWidth(int n2) {
        double d2 = this.getBounds().getWidth() * 0.8200000000000001 - this.labelWidth;
        if (!this.isShowLabel) {
            d2 = this.getBounds().getWidth() * 0.9;
        }
        this.seriesWidth = new double[this.getSeriesSize()];
        DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(0).getDataPoint(n2);
        double d3 = this.getMaxValue(n2);
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataPoint4Funnel dataPoint4Funnel2 = (DataPoint4Funnel)this.getSeries(i2).getDataPoint(n2);
            this.seriesWidth[i2] = Math.abs(dataPoint4Funnel2.getValue()) / d3 * d2;
        }
    }

    private double getMaxValue(int n2) {
        double d2 = Double.MIN_VALUE;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            d2 = Math.max(Math.abs(dataSeries.getDataPoint(n2).getValue()), d2);
        }
        return d2;
    }

    private double getMaxSeriesWidth() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.seriesWidth.length; ++i2) {
            d2 = Math.max(d2, this.seriesWidth[i2]);
        }
        return d2;
    }

    private void calculateOriginalPoint() {
        int n2 = (int)(this.getBounds().getWidth() * 0.05 + this.getMaxSeriesWidth() / 2.0);
        int n3 = (int)(this.getBounds().getHeight() * 0.1);
        this.originalPoint = new Point(n2, n3);
    }

    private void calculateSeriesXY() {
        this.seriesX = new double[this.getSeriesSize()];
        this.seriesY = new double[this.getSeriesSize()];
        this.calculateOriginalPoint();
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            this.seriesX[i2] = this.originalPoint.getX() - this.seriesWidth[i2] / 2.0;
            this.seriesY[i2] = this.originalPoint.getY() + (d2 += this.seriesHeight[i2]);
        }
    }

    private void initSeriesBounds(int n2) {
        this.initSeriesHeight(n2);
        this.initSeriesWidth(n2);
        this.calculateSeriesXY();
    }

    private void calculateLabelWidth(int n2, int n3) {
        TextGlyph textGlyph;
        DataPoint4Funnel dataPoint4Funnel;
        int n4;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.getBounds().getWidth() * 0.46;
        double d5 = this.getBounds().getWidth() * 0.02;
        for (n4 = 0; n4 < this.getSeriesSize(); ++n4) {
            dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(n4).getDataPoint(n2);
            textGlyph = dataPoint4Funnel.getDataLabel();
            if (textGlyph == null) {
                this.labelWidth = 0.0;
                this.isShowLabel = false;
                return;
            }
            dataPoint4Funnel.setValueGap(d5);
            String[] stringArray = dataPoint4Funnel.getSeriesValueString();
            TextAttr textAttr = textGlyph.getTextAttr();
            Dimension2D dimension2D = null;
            Dimension2D dimension2D2 = null;
            if (stringArray != null) {
                if (stringArray[0] != null && !StringUtils.isEmpty(stringArray[0])) {
                    dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(stringArray[0], textAttr, n3);
                }
                if (stringArray[1] != null && !StringUtils.isEmpty(stringArray[1])) {
                    dimension2D2 = GlyphUtils.calculateTextDimensionWithNoRotation(stringArray[1], textAttr, n3);
                }
            }
            if (dimension2D != null && dimension2D.getWidth() > d2) {
                d2 = dimension2D.getWidth();
            }
            if (dimension2D2 == null || !(dimension2D2.getWidth() > d3)) continue;
            d3 = dimension2D2.getWidth();
        }
        for (n4 = 0; n4 < this.getSeriesSize(); ++n4) {
            dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(n4).getDataPoint(n2);
            textGlyph = dataPoint4Funnel.getDataLabel();
            if (textGlyph == null) continue;
            dataPoint4Funnel.setValueWidth(d3);
        }
        this.labelWidth = Math.min(d2 + d3 + d5, d4);
        this.labelX = this.getBounds().getWidth() * 0.95 - this.labelWidth;
    }

    public void layoutAxisGlyph(int n2) {
    }

    protected void initLabelData(int n2, int n3) {
        this.calculateLabelWidth(n2, n3);
    }

    public void layoutDataSeriesGlyph(int n2) {
        for (int i2 = 0; i2 < this.getCategoryCount(); ++i2) {
            this.deal4EachCategory(i2, n2);
        }
        this.dealLabelBoundsInOrder();
    }

    private int indexOfDataPoint(DataPoint dataPoint) {
        int n2 = this.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            if (!ComparatorUtils.equals(dataPoint, dataSeries.getDataPoint(0))) continue;
            return i2;
        }
        return 0;
    }

    protected void dealLabelBoundsOutPlotBounds(Rectangle2D rectangle2D, GeneralPath generalPath, DataPoint dataPoint, List list, int n2) {
        String string;
        double d2;
        int n3;
        DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)dataPoint;
        if (!dataPoint4Funnel.isShowLabel()) {
            return;
        }
        if (dataPoint.getDataLabel() == null || StringUtils.isEmpty(dataPoint.getDataLabel().text)) {
            return;
        }
        if (rectangle2D.getX() >= this.getBounds().getX() && rectangle2D.getMaxX() <= this.getBounds().getMaxX()) {
            return;
        }
        double d3 = rectangle2D.getWidth();
        if (rectangle2D.getX() < this.getBounds().getX()) {
            d3 = rectangle2D.getMaxX() - this.getBounds().getX();
        } else if (rectangle2D.getMaxX() > this.getBounds().getMaxX()) {
            d3 = this.getBounds().getMaxX() - rectangle2D.getX();
        }
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        TextAttr textAttr = attrContents.getTextAttr();
        String string2 = dataPoint4Funnel.getDataLabel().getText();
        int n4 = ScreenResolution.getScreenResolution();
        for (n3 = 0; n3 < string2.length() && !((d2 = GlyphUtils.calculateTextDimensionWithNoRotation(string = string2.substring(0, n3) + "\u2026", textAttr, n4).getWidth()) > d3); ++n3) {
        }
        if (n3 == 0) {
            dataPoint4Funnel.setShowText("\u2026");
        } else {
            dataPoint4Funnel.setShowText(string2.substring(0, n3 - 1) + "\u2026");
        }
        double d4 = GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint4Funnel.getShowText(), textAttr, n4).getWidth();
        if (rectangle2D.getX() < this.getBounds().getX()) {
            rectangle2D.setRect(this.getBounds().getX(), rectangle2D.getY(), d4, rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d4, rectangle2D.getHeight());
        }
        dataPoint4Funnel.getDataLabel().setBounds(rectangle2D);
    }

    protected void deal4EachCategory(int n2, int n3) {
        this.initLabelData(n2, n3);
        this.initSeriesBounds(n2);
        this.dealLabelBounds(n2, n3);
        this.dealWithDataSeries(n2, n3);
    }

    protected void dealWithDataSeries(int n2, int n3) {
        int n4 = this.getSeriesSize();
        for (int i2 = 0; i2 < n4; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)dataSeries.getDataPoint(n2);
            DataPoint4Funnel dataPoint4Funnel2 = i2 > 0 ? (DataPoint4Funnel)this.getSeries(i2 - 1).getDataPoint(n2) : dataPoint4Funnel;
            if (dataPoint4Funnel.isValueIsNull()) continue;
            ShapeGlyph shapeGlyph = this.calculateShapeGlyph4DifferentSub(dataPoint4Funnel2, dataPoint4Funnel);
            dataPoint4Funnel.setDrawImpl(shapeGlyph);
        }
    }

    private ShapeGlyph calculateShapeGlyph4DifferentSub(DataPoint dataPoint, DataPoint dataPoint2) {
        int n2;
        GeneralPath generalPath = new GeneralPath();
        int n3 = this.indexOfDataPoint(dataPoint);
        if (n3 != (n2 = this.indexOfDataPoint(dataPoint2))) {
            generalPath.moveTo(this.seriesX[n3], this.seriesY[n3] + 1.0);
            generalPath.lineTo(this.seriesX[n3] + this.seriesWidth[n3], this.seriesY[n3] + 1.0);
            generalPath.lineTo(this.seriesX[n2] + this.seriesWidth[n2], this.seriesY[n2] - 1.0);
            generalPath.lineTo(this.seriesX[n2], this.seriesY[n2] - 1.0);
            generalPath.closePath();
        }
        ShapeGlyph shapeGlyph = new ShapeGlyph(generalPath);
        shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint2, this.createColors4Series());
        return shapeGlyph;
    }

    protected boolean isGuideLineShow(DataPoint dataPoint) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return false;
        }
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        String string = textGlyph.getText();
        return string != null && attrContents.isShowGuidLine() && textGlyph.getBounds() != null;
    }

    private boolean isCoverLabelBounds(GeneralPath generalPath, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return false;
        }
        if (!generalPath.intersects(rectangle2D)) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 2.0, rectangle2D.getHeight());
            generalPath.append(double_, false);
            return false;
        }
        return true;
    }

    private boolean checkCoverLabelBounds(int n2) {
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            String string;
            TextGlyph textGlyph;
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(i2).getDataPoint(n2);
            if (dataPoint4Funnel == null || (textGlyph = dataPoint4Funnel.getDataLabel()) == null || (string = textGlyph.getText()) == null || string.length() <= 0 || !this.isCoverLabelBounds(generalPath, textGlyph.getBounds())) continue;
            return true;
        }
        return false;
    }

    private void adjustCoverLabelBounds(int n2) {
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            String string;
            TextGlyph textGlyph;
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(i2).getDataPoint(n2);
            if (dataPoint4Funnel == null || (textGlyph = dataPoint4Funnel.getDataLabel()) == null || (string = textGlyph.getText()) == null || string.length() <= 0 || !this.isCoverLabelBounds(generalPath, textGlyph.getBounds())) continue;
            textGlyph.setBounds(null);
            dataPoint4Funnel.setLeadLine(null);
        }
    }

    protected void dealLabelBounds(int n2, int n3) {
        TextGlyph textGlyph;
        DataPoint4Funnel dataPoint4Funnel;
        int n4;
        for (n4 = 0; n4 < this.getSeriesSize(); ++n4) {
            dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(n4).getDataPoint(n2);
            if (dataPoint4Funnel == null) continue;
            textGlyph = dataPoint4Funnel.getDataLabel();
            if (textGlyph == null) {
                return;
            }
            String string = textGlyph.getText();
            if (string == null || string.length() <= 0) continue;
            this.dealOutsideLabelBounds(textGlyph, dataPoint4Funnel, this.indexOfDataPoint(dataPoint4Funnel), n3);
        }
        if (this.checkCoverLabelBounds(n2)) {
            this.dealLabelBoundsWithCover(n2, n3);
        }
        for (n4 = 0; n4 < this.getSeriesSize(); ++n4) {
            dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(n4).getDataPoint(n2);
            if (dataPoint4Funnel == null) continue;
            textGlyph = dataPoint4Funnel.getDataLabel();
            if (textGlyph == null) {
                return;
            }
            dataPoint4Funnel.initLabel(n3);
        }
    }

    protected void dealLabelBoundsWithCover(int n2, int n3) {
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(i2).getDataPoint(n2);
            if (dataPoint4Funnel == null) continue;
            TextGlyph textGlyph = dataPoint4Funnel.getDataLabel();
            if (textGlyph == null) {
                return;
            }
            String string = textGlyph.getText();
            if (string == null || string.length() <= 0) continue;
            this.dealOutsideLabelBoundsWithCover(textGlyph, dataPoint4Funnel, this.indexOfDataPoint(dataPoint4Funnel), n3);
        }
        this.adjustCoverLabelBounds(n2);
    }

    private void dealOutsideLabelBounds(TextGlyph textGlyph, DataPoint4Funnel dataPoint4Funnel, int n2, int n3) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(textGlyph.getText(), textGlyph.getTextAttr(), n3);
        double d2 = this.seriesY[n2] - dimension2D.getHeight() / 2.0;
        ((Rectangle2D)double_).setRect(this.labelX, d2, this.labelWidth, dimension2D.getHeight());
        this.dealOutsideLabelBoundsWhenNormal(double_, dataPoint4Funnel, n2);
    }

    private void dealOutsideLabelBoundsWithCover(TextGlyph textGlyph, DataPoint4Funnel dataPoint4Funnel, int n2, int n3) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(textGlyph.getText(), textGlyph.getTextAttr(), n3);
        double d2 = this.getBounds().getHeight() * 0.8 / (double)(this.seriesY.length - 1);
        double d3 = this.seriesY[0] + d2 * (double)n2 - dimension2D.getHeight() / 2.0;
        ((Rectangle2D)double_).setRect(this.labelX, d3, this.labelWidth, dimension2D.getHeight());
        this.dealOutsideLabelBoundsWhenNormal(double_, dataPoint4Funnel, n2);
    }

    private void dealOutsideLabelBoundsWhenNormal(Rectangle2D rectangle2D, DataPoint4Funnel dataPoint4Funnel, int n2) {
        dataPoint4Funnel.getDataLabel().setBounds(rectangle2D);
        if (this.isGuideLineShow(dataPoint4Funnel)) {
            this.dealWidthLine(dataPoint4Funnel, n2);
        }
    }

    protected void dealWidthLine(DataPoint4Funnel dataPoint4Funnel, int n2) {
        GeneralPath generalPath = new GeneralPath();
        double d2 = this.seriesX[n2] + this.seriesWidth[n2] + this.getBounds().getWidth() * 0.01;
        double d3 = this.seriesY[n2];
        double d4 = this.labelX - this.getBounds().getWidth() * 0.06999999999999999;
        double d5 = this.labelX - this.getBounds().getWidth() * 0.01;
        double d6 = d3;
        if (dataPoint4Funnel.getDataLabel() != null) {
            d6 = dataPoint4Funnel.getDataLabel().getBounds().getCenterY();
        }
        generalPath.moveTo(d2, d3);
        generalPath.lineTo(d4, d6);
        generalPath.lineTo(d5, d6);
        dataPoint4Funnel.setLeadLine(generalPath);
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawInfo(graphics);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics, n2);
    }

    public boolean equals(Object object) {
        return object instanceof FunnelPlotGlyph;
    }

    public String getPlotGlyphType() {
        return "FunnelPlotGlyph";
    }

    public String getChartType() {
        return "Funnel";
    }

    public boolean isSupportLegend() {
        return false;
    }
}

