/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.HighLightChart;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class DonutHighLightStyle
extends HighLightChart {
    private static final double FACTOR = 0.5;
    private static final double S_ANGLE = 135.0;
    private static final double E_ANGLE = 315.0;
    private static final double PIE_ANGLE = 180.0;
    private Point2D centerPoint;
    private double totalRadius;
    Shape shape;

    public DonutHighLightStyle(Color color, double d2, Point2D point2D, Shape shape) {
        this.baseColor = color;
        this.avoidOriginDraw = true;
        this.shape = shape;
        this.totalRadius = d2;
        this.centerPoint = point2D;
    }

    public void paintStyle(Graphics graphics) {
        if (this.baseColor == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        GradientPaint gradientPaint = new GradientPaint(this.getShadeStartPoint(), this.getPaintStartColor(), this.getShadeEndPoint(), this.getPaintEndColor());
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(this.shape);
        graphics2D.setPaint(paint);
    }

    private Point2D getShadeStartPoint() {
        double d2 = this.centerPoint.getX() - this.totalRadius * Math.cos(2.356194490192345);
        double d3 = this.centerPoint.getY() - this.totalRadius * Math.sin(2.356194490192345);
        return new Point2D.Double(d2, d3);
    }

    private Point2D getShadeEndPoint() {
        double d2 = this.centerPoint.getX() - this.totalRadius * Math.cos(5.497787143782138);
        double d3 = this.centerPoint.getY() - this.totalRadius * Math.sin(5.497787143782138);
        return new Point2D.Double(d2, d3);
    }

    private Color getPaintStartColor() {
        return ChartUtils.brighterWithFactor(this.baseColor, 0.5);
    }

    Color getPaintEndColor() {
        return this.baseColor;
    }
}

