/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.AttrContents;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DonutPlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.chart.chartglyph.Ring3D;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Donut3DPlotGlyph
extends DonutPlotGlyph {
    private int depth = 20;
    private static final double DEFAULT_DEPTH = 0.16;
    private Projection projection = new Projection();
    private ArrayList<Ring3D> ring4cate = new ArrayList();

    public void layoutDataSeriesGlyph(int n2) {
        this.initArcValues();
        this.labelBounds.clear();
        int n3 = this.getCategoryCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            Ring3D ring3D = new Ring3D();
            this.dealWithDataSeries(i2, ring3D, n2);
            this.ring4cate.add(ring3D);
        }
    }

    private void dealWithDataSeries(int n2, Ring3D ring3D, int n3) {
        int n4 = this.getSeriesSize();
        for (int i2 = 0; i2 < n4; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            DataPoint dataPoint = dataSeries.getDataPoint(n2);
            if (dataPoint.isValueIsNull()) continue;
            this.calculateShapeGlyph4DifferentSub(dataPoint, ring3D, n2, i2);
            this.dealLabelBounds(dataPoint, n3);
        }
        this.dealLabelBoundsInOrder();
    }

    private void calculateShapeGlyph4DifferentSub(DataPoint dataPoint, Ring3D ring3D, int n2, int n3) {
        double d2 = this.getArcInnerRadius(n2);
        double d3 = this.getActOuterRadius(n2);
        double d4 = this.getSeriesStartAngle(n2, n3) % 360.0;
        double d5 = this.getPercent(n3, n2) * 360.0 * (1.0 - this.getSeriesGap());
        double d6 = this.radius * 0.16;
        Cylinder cylinder = new Cylinder(0.0, d6, d3);
        Cylinder cylinder2 = new Cylinder(0.0, d6, d2);
        cylinder.setAttrbute(this.centerPoint.getX(), this.centerPoint.getY(), d4, d5, this.projection);
        cylinder2.setAttrbute(this.centerPoint.getX(), this.centerPoint.getY(), d4, d5, this.projection);
        this.getConditionCollection().changeStyleConditionWithInfo(cylinder.getColorInfo(), dataPoint, this.createColors4Series());
        this.getConditionCollection().changeStyleConditionWithInfo(cylinder2.getColorInfo(), dataPoint, this.createColors4Series());
        Ring3D ring3D2 = new Ring3D();
        ring3D2.addCylinder(cylinder, cylinder2);
        ring3D.addCylinder(cylinder, cylinder2);
        dataPoint.setDrawImpl(ring3D2);
    }

    protected void dealLabelBounds(DataPoint dataPoint, int n2) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return;
        }
        String string = textGlyph.getText();
        if (string != null && string.length() > 0) {
            Point2D point2D = this.getTopArcCenterPoint(dataPoint);
            if (point2D != null) {
                double d2 = this.getLabelDim(dataPoint, n2).getHeight();
                double d3 = this.getLabelDim(dataPoint, n2).getWidth();
                double d4 = point2D.getX() - d3 / 2.0;
                double d5 = point2D.getY() - d2 / 2.0;
                textGlyph.setBounds(new Rectangle2D.Double(d4, d5, d3, d2));
            } else {
                textGlyph.setBounds(null);
            }
        }
    }

    private Point2D getTopArcCenterPoint(DataPoint dataPoint) {
        if (dataPoint.getDrawImpl() != null) {
            Ring3D ring3D = (Ring3D)dataPoint.getDrawImpl();
            return ring3D.getTopCenterPoint();
        }
        return null;
    }

    protected Dimension2D getLabelDim(DataPoint dataPoint, int n2) {
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        TextAttr textAttr = attrContents.getTextAttr();
        return GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint.getDataLabel().getText(), textAttr, n2);
    }

    protected double getSeriesStartAngle(int n2, int n3) {
        double d2 = 135.0;
        double d3 = this.seriesGap * 360.0;
        double d4 = d3 / (double)this.getSeriesSize();
        double d5 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            d5 += this.getPercent(i2, n2) * (360.0 - d3);
        }
        return d2 += d5 + d4 * (double)n3 + d4 / 2.0;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setDepth(int n2) {
        this.depth = n2;
    }

    public void draw(Graphics graphics, int n2) {
        int n3;
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        for (n3 = this.ring4cate.size() - 1; n3 >= 0; --n3) {
            this.drawBackHalf(n3, graphics2D);
        }
        for (n3 = 0; n3 < this.ring4cate.size(); ++n3) {
            this.drawFrontHalf(n3, graphics2D);
        }
        this.drawLabel4Series(graphics, n2);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawBackHalf(int n2, Graphics2D graphics2D) {
        Ring3D ring3D = this.ring4cate.get(n2).calculateBackHalf();
        ring3D.drawSide(graphics2D);
        ring3D.drawBack(graphics2D);
        ring3D.drawPositive(graphics2D);
        ring3D.drawTop(graphics2D);
    }

    private void drawFrontHalf(int n2, Graphics2D graphics2D) {
        Ring3D ring3D = this.ring4cate.get(n2).calculateFrontHalf();
        ring3D.drawSide(graphics2D);
        ring3D.drawBack(graphics2D);
        ring3D.drawPositive(graphics2D);
        ring3D.drawTop(graphics2D);
    }

    public boolean is3DPlotGlyph() {
        return true;
    }

    public String getPlotGlyphType() {
        return "Donut3DPlotGlyph";
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("innerRadiusPercent", this.innerRadiusPercent);
        jSONObject.put("seriesGap", this.seriesGap);
        jSONObject.put("categoryGap", this.categoryGap);
        jSONObject.put("depth", this.depth);
        jSONObject.put("projection", this.projection.toJSONObject());
        return jSONObject;
    }

    public String getChartType() {
        return "Donut3D";
    }

    public String getSmallIconType() {
        return "Donut";
    }
}

