/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.Plane3DChart;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class ArcPlane3DStyle
extends Plane3DChart {
    private Shape arcShape;
    private Arc2D arc;
    private int cateCount = 1;
    private double totalRadius = 0.0;
    private static final double HALF = 0.5;

    public ArcPlane3DStyle(Color color, Arc2D.Double double_, Shape shape, boolean bl) {
        this.color = color;
        this.arc = double_;
        this.arcShape = shape;
        this.avoidOriginDraw = bl;
    }

    public ArcPlane3DStyle(Color color, Arc2D.Double double_, Shape shape, boolean bl, int n2, double d2) {
        this.color = color;
        this.arc = double_;
        this.arcShape = shape;
        this.avoidOriginDraw = bl;
        this.cateCount = n2;
        this.totalRadius = d2;
    }

    public void paintStyle(Graphics graphics) {
        if (this.color == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d2 = this.arc.getWidth() / 2.0;
        double d3 = this.totalRadius == 0.0 ? d2 : this.totalRadius;
        double d4 = this.arc.getX() + d2;
        double d5 = this.arc.getY() + d2;
        Color color = this.getStartColor();
        Color color2 = this.getEndColor();
        if ((float)d3 <= Float.MIN_VALUE) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        if (this.arc.getAngleExtent() <= 180.0 || this.cateCount != 1) {
            float[] fArray = new float[]{0.0f, 1.0f};
            Color[] colorArray = new Color[]{color, color2};
            RadialGradientPaint radialGradientPaint = new RadialGradientPaint((float)d4, (float)d5, (float)d3, fArray, colorArray);
            graphics2D.setPaint((Paint)radialGradientPaint);
            graphics2D.fill(this.arcShape);
        } else {
            Point2D point2D;
            Point2D point2D2;
            double d6 = this.arc.getAngleStart() + this.arc.getAngleExtent() / 2.0;
            if (d6 >= 45.0 && d6 < 135.0) {
                point2D2 = this.getPointWithAngle(90.0);
                point2D = this.getBottomPoint();
            } else if (d6 >= 135.0 && d6 < 225.0) {
                point2D2 = this.getPointWithAngle(180.0);
                point2D = this.getRightMostPoint();
            } else if (d6 >= 225.0 && d6 < 315.0) {
                point2D2 = this.getPointWithAngle(270.0);
                point2D = this.getTopPoint();
            } else {
                point2D2 = this.getPointWithAngle(360.0);
                point2D = this.getLeftMostPoint();
            }
            GradientPaint gradientPaint = new GradientPaint(point2D2, color2, point2D, color);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(this.arcShape);
        }
        graphics2D.setPaint(paint);
    }

    private Point2D getPointWithAngle(double d2) {
        d2 = Math.toRadians(-d2);
        double d3 = this.arc.getX() + (Math.cos(d2) * 0.5 + 0.5) * this.arc.getWidth();
        double d4 = this.arc.getY() + (Math.sin(d2) * 0.5 + 0.5) * this.arc.getHeight();
        return new Point2D.Double(d3, d4);
    }

    private Point2D getBottomPoint() {
        Point2D point2D = this.arc.getStartPoint();
        Point2D point2D2 = this.arc.getEndPoint();
        return point2D.getY() > point2D2.getY() ? point2D : point2D2;
    }

    private Point2D getLeftMostPoint() {
        Point2D point2D = this.arc.getStartPoint();
        Point2D point2D2 = this.arc.getEndPoint();
        return point2D.getX() > point2D2.getX() ? point2D2 : point2D;
    }

    private Point2D getTopPoint() {
        Point2D point2D = this.arc.getStartPoint();
        Point2D point2D2 = this.arc.getEndPoint();
        return point2D.getY() > point2D2.getY() ? point2D2 : point2D;
    }

    private Point2D getRightMostPoint() {
        Point2D point2D = this.arc.getStartPoint();
        Point2D point2D2 = this.arc.getEndPoint();
        return point2D.getX() > point2D2.getX() ? point2D : point2D2;
    }

    private Color getStartColor() {
        return ChartUtils.getShadeStartColor(this.color, 0.35f);
    }

    private Color getEndColor() {
        return ChartUtils.getShadeEndColor(this.color, 0.35f);
    }
}

