/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.Shadow;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Arc3DStyleBase {
    private Arc2D shape;
    private Shape ring;
    private static final double HALF = 0.5;
    Shadow shadow = new Shadow(new Color(0.0f, 0.0f, 0.0f, 0.45f), 12, 1.0f);

    public Arc3DStyleBase(Arc2D.Double double_) {
        this.shape = double_;
    }

    public Arc3DStyleBase(Shape shape, Arc2D arc2D) {
        this.shape = arc2D;
        this.ring = shape;
    }

    public void paintStyle(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Point2D point2D = this.getPointWithAngle(135.0);
        Point2D point2D2 = this.getPointWithAngle(315.0);
        GradientPaint gradientPaint = new GradientPaint(point2D, new Color(232, 229, 226), point2D2, new Color(185, 182, 177));
        graphics2D.setPaint(gradientPaint);
        if (this.ring != null) {
            GeneralPath generalPath = new GeneralPath(this.ring);
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.setToTranslation(-5.0, -10.0);
            generalPath.transform(affineTransform2);
            this.shadow.paint(graphics, generalPath);
            graphics2D.fill(this.ring);
        } else {
            this.shadow.paint(graphics, this.shape);
            graphics2D.fill(this.shape);
        }
        graphics2D.setPaint(paint);
    }

    private Point2D getPointWithAngle(double d2) {
        double d3 = Math.toRadians(-d2);
        double d4 = this.shape.getX() + (Math.cos(d3) * 0.5 + 0.5) * this.shape.getWidth();
        double d5 = this.shape.getY() + (Math.sin(d3) * 0.5 + 0.5) * this.shape.getHeight();
        return new Point2D.Double(d4, d5);
    }
}

