/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.present.Present;
import com.fr.chart.chartdata.TopChartData;
import com.fr.data.util.function.AverageFunction;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NormalChartData
extends TopChartData
implements ChartData {
    public static final String XML_TAG = "ReportChartData";
    private Object[] category_array = null;
    private Object[] series_array = null;
    private Object[][] series_value_2D = null;
    private Object[] secondCates = null;
    private Object[] thirdCates = null;

    public NormalChartData() {
    }

    public NormalChartData(Object[] objectArray, Object[] objectArray2, Object[][] objectArray3) {
        this.initsData(objectArray, objectArray2, objectArray3);
    }

    public void initsData(Object[] objectArray, Object[] objectArray2, Object[][] objectArray3) {
        this.setCategory_array(objectArray);
        this.setSeries_array(objectArray2);
        this.setSeries_value_2D(objectArray3);
    }

    public Object getCategoryOriginalLabel(int n2) {
        if (this.getCategory_array() != null && this.getCategory_array().length > n2) {
            return this.getCategory_array()[n2];
        }
        return "";
    }

    public int getCategoryLabelCount() {
        return this.getCategory_array() == null ? 0 : this.getCategory_array().length;
    }

    public int getSeriesCount() {
        return this.getSeries_array() == null ? 0 : this.getSeries_array().length;
    }

    public Object getSeriesPresentLabel(int n2) {
        if (this.seriesPresentList != null && n2 < this.seriesPresentList.size() && n2 >= 0) {
            return this.seriesPresentList.get(n2);
        }
        return this.getSeriesOriginalLabel(n2);
    }

    public Object getSeriesOriginalLabel(int n2) {
        if (this.getSeries_array() != null && this.getSeries_array().length > n2 && n2 >= 0) {
            return this.getSeries_array()[n2];
        }
        return "";
    }

    public Number getValueAt(int n2, int n3) {
        return this.getDataValue(n2, n3);
    }

    public void setCategory_array(Object[] objectArray) {
        this.category_array = objectArray;
    }

    public Object[] getCategory_array() {
        return this.category_array;
    }

    public void setSecondCates(Object[] objectArray) {
        this.secondCates = objectArray;
    }

    public Object[] getSecondCates() {
        return this.secondCates;
    }

    public void setThirdCates(Object[] objectArray) {
        this.thirdCates = objectArray;
    }

    public Object[] getThirdCates() {
        return this.thirdCates;
    }

    public void setSeries_array(Object[] objectArray) {
        this.series_array = objectArray;
    }

    public Object[] getSeries_array() {
        return this.series_array;
    }

    public void setSeries_value_2D(Object[][] objectArray) {
        this.series_value_2D = objectArray;
    }

    public Object[][] getSeries_value_2D() {
        return this.series_value_2D;
    }

    public Number getDataValue(int n2, int n3) {
        return this.dealDataObject2Number(this.getDataObject(n2, n3));
    }

    private Object getDataObject(int n2, int n3) {
        Object object = null;
        if (this.getSeries_value_2D() == null || this.getSeries_value_2D().length <= n2 || n2 < 0) {
            return null;
        }
        Object[] objectArray = this.getSeries_value_2D()[n2];
        if (objectArray.length <= n3) {
            return null;
        }
        object = objectArray[n3];
        return object;
    }

    public void dealDiscard(int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        List list;
        int n4;
        if (!bl3 && !bl4 && n2 == -1 && n3 == -1) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(this.category_array));
        ArrayList<Object> arrayList2 = new ArrayList<Object>(Arrays.asList(this.series_array));
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        boolean[] blArray = new boolean[arrayList.size()];
        Arrays.fill(blArray, true);
        boolean[] blArray2 = new boolean[arrayList2.size()];
        Arrays.fill(blArray2, true);
        for (n4 = 0; n4 < this.series_value_2D.length; ++n4) {
            list = new ArrayList<Object>();
            arrayList3.add(list);
            for (int i2 = 0; i2 < this.series_value_2D[n4].length; ++i2) {
                list.add(this.series_value_2D[n4][i2]);
                boolean bl5 = false;
                if (Utils.objectToNumber(this.series_value_2D[n4][i2], true) == null) {
                    bl5 = true;
                }
                if (n4 < blArray2.length) {
                    boolean bl6 = blArray2[n4] = blArray2[n4] && bl5;
                }
                if (i2 >= blArray.length) continue;
                blArray[i2] = blArray[i2] && bl5;
            }
        }
        this.removeNullCateAndNullSeries(bl3, bl4, blArray, blArray2, arrayList3, arrayList2, arrayList);
        this.dealDiscardOther2DValue(n2, n3, bl, bl2, arrayList3);
        this.dealDiscardOtherList(n3, bl2, arrayList2, true);
        this.dealDiscardOtherList(n2, bl, arrayList, true);
        for (n4 = 0; n4 < arrayList3.size(); ++n4) {
            list = (List)arrayList3.remove(n4);
            arrayList3.add(n4, list.toArray());
        }
        this.category_array = arrayList.toArray();
        this.series_array = arrayList2.toArray();
        this.series_value_2D = (Object[][])arrayList3.toArray((T[])new Object[arrayList3.size()][]);
    }

    private void removeNullCateAndNullSeries(boolean bl, boolean bl2, boolean[] blArray, boolean[] blArray2, List list, List list2, List list3) {
        int n2;
        if (bl2) {
            for (n2 = blArray2.length - 1; n2 >= 0; --n2) {
                if (!blArray2[n2]) continue;
                list2.remove(n2);
                list.remove(n2);
            }
        }
        if (bl) {
            for (n2 = blArray.length - 1; n2 >= 0; --n2) {
                if (!blArray[n2]) continue;
                list3.remove(n2);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    List list4 = (List)list.get(i2);
                    list4.remove(n2);
                }
            }
        }
    }

    public void dealPresent(Present present, Present present2, Calculator calculator) {
        int n2;
        if (present != null) {
            this.clearCate();
            for (n2 = 0; n2 < this.getCategoryLabelCount(); ++n2) {
                this.addCategoryPresent(Utils.objectToString(present.present(this.getCategoryOriginalLabel(n2), calculator)));
            }
            if (this.secondCates != null) {
                for (n2 = 0; n2 < this.secondCates.length; ++n2) {
                    this.secondCates[n2] = Utils.objectToString(present.present(this.secondCates[n2], calculator));
                }
            }
            if (this.thirdCates != null) {
                for (n2 = 0; n2 < this.thirdCates.length; ++n2) {
                    this.thirdCates[n2] = Utils.objectToString(present.present(this.thirdCates[n2], calculator));
                }
            }
        }
        if (present2 != null) {
            this.clearSeries();
            for (n2 = 0; n2 < this.getSeriesCount(); ++n2) {
                this.addSeriesPresent(Utils.objectToString(present2.present(this.getSeriesOriginalLabel(n2), calculator)));
            }
        }
    }

    public void dealHugeData() {
        List<Object> list;
        int n2;
        if (this.category_array.length < 1000) {
            return;
        }
        int n3 = (int)Math.ceil((double)this.category_array.length / 1000.0);
        AverageFunction averageFunction = new AverageFunction();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n2 = 0; n2 < this.series_array.length; ++n2) {
            list = new ArrayList();
            arrayList2.add(list);
            averageFunction.reset();
            boolean bl = false;
            for (int i2 = 0; i2 < this.category_array.length; ++i2) {
                averageFunction.addData(this.series_value_2D[n2][i2]);
                if (StableUtils.isNull(this.series_value_2D[n2][i2]) || StringUtils.isEmpty(Utils.objectToString(this.series_value_2D[n2][i2]))) {
                    bl = true;
                }
                if (i2 != this.category_array.length - 1 && (i2 + 1) % n3 != 0) continue;
                if (bl) {
                    list.add(null);
                } else {
                    list.add(averageFunction.getResult());
                    averageFunction.reset();
                }
                bl = false;
            }
        }
        for (n2 = 0; n2 < this.category_array.length; ++n2) {
            if (n2 != this.category_array.length - 1 && (n2 + 1) % n3 != 0) continue;
            arrayList.add(this.category_array[n2]);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            list = (List)arrayList2.remove(n2);
            arrayList2.add(n2, list.toArray());
        }
        this.category_array = arrayList.toArray();
        this.series_value_2D = (Object[][])arrayList2.toArray((T[])new Object[arrayList2.size()][]);
    }
}

