/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.chartdata.GisMapChartData;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.chart.chartdata.TableDataDefinition;
import com.fr.data.core.DataCoreUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GisMapTableDefinition
extends TableDataDefinition {
    private static final long serialVersionUID = 5503541167095029143L;
    public static final String XML_TAG = "GisMapTableDefinition";
    private String address;
    private String addressName;
    private boolean isAddress;
    private boolean isLngFirst;
    private List list = new ArrayList();

    public GisMapTableDefinition() {
        this.setAddressType(true);
        this.setLnglatOrder(true);
    }

    public ChartData createChartData(DataModel dataModel, DataProcessor dataProcessor) {
        GisMapChartData gisMapChartData = new GisMapChartData();
        this.createGisMapChartData(dataModel, gisMapChartData);
        return gisMapChartData;
    }

    public void createGisMapChartData(DataModel dataModel, GisMapChartData gisMapChartData) {
        int n2 = this.list.size();
        HashMap<String, MapAreaValue> hashMap = null;
        HashMap hashMap2 = null;
        if (StringUtils.isNotEmpty(this.address)) {
            try {
                int n3 = dataModel.getRowCount();
                int n4 = DataCoreUtils.getColumnIndexByName(dataModel, this.getAddress());
                if (n4 != -1) {
                    hashMap = new HashMap<String, MapAreaValue>();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Object object = dataModel.getValueAt(i2, n4);
                        if (object == null || !StringUtils.isNotEmpty(Utils.objectToString(object))) continue;
                        MapAreaValue mapAreaValue = new MapAreaValue();
                        hashMap.put(Utils.objectToString(object), mapAreaValue);
                        for (int i3 = 0; i3 < n2; ++i3) {
                            SeriesDefinition seriesDefinition = (SeriesDefinition)this.list.get(i3);
                            if (seriesDefinition == null || seriesDefinition.getValue() == null) continue;
                            String string = Utils.objectToString(seriesDefinition.getSeriesName());
                            String string2 = Utils.objectToString(seriesDefinition.getValue());
                            int n5 = DataCoreUtils.getColumnIndexByName(dataModel, string2);
                            if (n5 == -1) continue;
                            Object object2 = dataModel.getValueAt(i2, n5);
                            mapAreaValue.addTitleValue(new MapTitleValue(string, Utils.objectToString(object2)));
                        }
                    }
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage());
            }
        }
        hashMap2 = new HashMap();
        this.dealWithAddressName(dataModel, hashMap2);
        gisMapChartData.addGisMapData(hashMap2, hashMap, this.isAddress, this.isLngFirst);
    }

    private void dealWithAddressName(DataModel dataModel, HashMap hashMap) {
        if (StringUtils.isNotBlank(this.getAddressName())) {
            try {
                int n2 = dataModel.getRowCount();
                int n3 = DataCoreUtils.getColumnIndexByName(dataModel, this.getAddress());
                if (n3 != -1) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int n4;
                        Object object = dataModel.getValueAt(i2, n3);
                        if (object == null || !StringUtils.isNotEmpty(Utils.objectToString(object)) || (n4 = DataCoreUtils.getColumnIndexByName(dataModel, this.getAddressName())) == -1) continue;
                        Object object2 = dataModel.getValueAt(i2, n4);
                        hashMap.put(Utils.objectToString(object), Utils.objectToString(object2));
                    }
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage());
            }
        }
    }

    public JSONObject createDataConfig() throws JSONException {
        JSONObject jSONObject = super.createDataConfig();
        jSONObject.put("address", this.address);
        jSONObject.put("addressName", this.addressName);
        jSONObject.put("isAddress", this.isAddress);
        if (!this.isAddress) {
            jSONObject.put("isLngFirst", this.isLngFirst);
        }
        if (this.list != null) {
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < this.list.size(); ++i2) {
                jSONArray.put(((SeriesDefinition)this.list.get(i2)).toJSONObject());
            }
            jSONObject.put("titleValues", jSONArray);
        }
        return jSONObject;
    }

    public String getDataDefinitionType() {
        return "GisMapDefinition";
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public String getAddressName() {
        return this.addressName;
    }

    public void setAddressName(String string) {
        this.addressName = string;
    }

    public void addTittleValue(SeriesDefinition seriesDefinition) {
        this.list.add(seriesDefinition);
    }

    public void clearTittleValue() {
        this.list.clear();
    }

    public int getTittleValueSize() {
        return this.list.size();
    }

    public boolean isAddress() {
        return this.isAddress;
    }

    public void setAddressType(boolean bl) {
        this.isAddress = bl;
    }

    public boolean isLngFirst() {
        return this.isLngFirst;
    }

    public void setLnglatOrder(boolean bl) {
        this.isLngFirst = bl;
    }

    public SeriesDefinition getTittleValueWithIndex(int n2) {
        if (n2 >= 0 && n2 < this.list.size()) {
            return (SeriesDefinition)this.list.get(n2);
        }
        return null;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("AddressAndName");
        xMLPrintWriter.attr("address", this.getAddress());
        if (this.addressName != null && StringUtils.isNotBlank(this.addressName)) {
            xMLPrintWriter.attr("addressName", this.getAddressName());
        }
        xMLPrintWriter.end();
        int n2 = this.list.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                xMLPrintWriter.startTAG("DefinitionList");
                SeriesDefinition seriesDefinition = (SeriesDefinition)this.list.get(i2);
                seriesDefinition.writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
        xMLPrintWriter.startTAG("AddressType").attr("addressType", this.isAddress).attr("latLngOrder", this.isLngFirst).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof GisMapTableDefinition && super.equals(object) && ((GisMapTableDefinition)object).isAddress == this.isAddress && ((GisMapTableDefinition)object).isLngFirst == this.isLngFirst && ComparatorUtils.equals(this.addressName, ((GisMapTableDefinition)object).getAddressName()) && ComparatorUtils.equals((Object)this.list, (Object)((GisMapTableDefinition)object).getTittleValue());
    }

    public List getTittleValue() {
        return this.list;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        String string = xMLableReader.getTagName();
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if (ComparatorUtils.equals("AddressAndName", string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string = xMLableReader.getAttrAsString("address", "");
                        GisMapTableDefinition.this.setAddress(xMLableReader.getAttrAsString("address", ""));
                        GisMapTableDefinition.this.setAddressName(xMLableReader.getAttrAsString("addressName", ""));
                    }
                });
            } else if (ComparatorUtils.equals("DefinitionList", string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        SeriesDefinition seriesDefinition = (SeriesDefinition)xMLableReader.readXMLObject(new SeriesDefinition());
                        GisMapTableDefinition.this.addTittleValue(seriesDefinition);
                    }
                });
            } else if (ComparatorUtils.equals("AddressType", string2)) {
                this.setAddressType(xMLableReader.getAttrAsBoolean("addressType", true));
                this.setLnglatOrder(xMLableReader.getAttrAsBoolean("latLngOrder", true));
            }
        }
    }
}

