/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.chartattr.RectanglePlot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartdata.TopChartData;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.stable.xml.XMLableReader;

public abstract class XYPlot
extends RectanglePlot {
    private static final long serialVersionUID = -7820354209332093183L;
    private static final double MAXBU = 500.0;
    private static final double MINBU = 300.0;

    public XYPlot() {
        this.setxAxis(new ValueAxis(3));
        this.setyAxis(new ValueAxis(2));
    }

    public void installAxisGlyph(RectanglePlotGlyph rectanglePlotGlyph, ChartData chartData) {
        AxisGlyph axisGlyph = this.getxAxis().createAxisGlyph(chartData);
        axisGlyph.setAxisType("xAxis");
        rectanglePlotGlyph.setxAxisGlyph(axisGlyph);
        double d2 = this.getMaxValue4XValue(chartData);
        double d3 = this.getMinValue4XValue(chartData, axisGlyph.isLog());
        double d4 = (d2 - d3) * this.getMarkerSize() / 500.0;
        axisGlyph.initMinMaxValue(d3 -= d4, d2 += d4);
        AxisGlyph axisGlyph2 = this.getyAxis().createAxisGlyph(chartData);
        axisGlyph2.setAxisType("yAxis");
        rectanglePlotGlyph.setyAxisGlyph(axisGlyph2);
        d2 = this.getMaxValueFromData(chartData, ChartAxisPosition.AXIS_LEFT);
        d3 = this.getMinValueFromData(chartData, axisGlyph2.isLog(), ChartAxisPosition.AXIS_LEFT);
        d4 = (d2 - d3) * this.getMarkerSize() / 300.0;
        axisGlyph2.initMinMaxValue(d3 -= d4, d2 += d4);
        rectanglePlotGlyph.axisExtendsMaxMinValueWithTrendLine(axisGlyph);
    }

    public String[] getAlertLinePaneTitle() {
        return new String[]{"X_Axis", "Y_Axis"};
    }

    protected abstract double getMaxValue4XValue(ChartData var1);

    public double getMinValue4XValue(ChartData chartData, boolean bl) {
        TopChartData topChartData = (TopChartData)chartData;
        double d2 = 0.0;
        if (bl) {
            d2 = Double.MAX_VALUE;
        }
        for (int i2 = 0; i2 < topChartData.getItemCount(); ++i2) {
            for (int i3 = 0; i3 < topChartData.getCategoryLabelCount(); ++i3) {
                Number number = topChartData.getX(i2, i3);
                if (number == null) continue;
                if (bl) {
                    if (!(number.doubleValue() > 0.0) || !(number.doubleValue() < d2)) continue;
                    d2 = number.doubleValue();
                    continue;
                }
                d2 = d2 < number.doubleValue() ? d2 : number.doubleValue();
            }
        }
        if (bl && d2 == Double.MAX_VALUE) {
            d2 = 1.0;
        }
        return d2;
    }

    protected double getMarkerSize() {
        return 0.0;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("XAxis".equals(string)) {
                this.setxAxis((ValueAxis)xMLableReader.readXMLObject(new ValueAxis()));
            } else if ("YAxis".equals(string)) {
                this.setyAxis((ValueAxis)xMLableReader.readXMLObject(new ValueAxis()));
            } else if (string.equals("XYAttr")) {
                boolean bl = false;
                String string2 = xMLableReader.getAttrAsString("bgStagger", null);
                if (string2 != null) {
                    bl = Boolean.valueOf(string2);
                }
                if (bl && (string2 = xMLableReader.getAttrAsString("bgColor", null)) != null) {
                    this.setHorizontalIntervalBackgroundColor(xMLableReader.getAttrAsColor("bgColor", null));
                }
            }
        }
    }
}

