/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Formula;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.chartattr.NumberAxis;
import com.fr.chart.chartattr.Title;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.RadarAxisGlyph;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class RadarAxis
extends NumberAxis {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "RadarAxis";
    private boolean isAllMaxMin = true;

    public RadarAxis() {
        this.setTickMarkType(0);
        this.setMainGridStyle(1);
        this.setMainGridColor(new Color(192, 192, 192));
    }

    public Title getTitle() {
        return null;
    }

    public void setTitle(Title title) {
    }

    public void setAllMaxMin(boolean bl) {
        this.isAllMaxMin = bl;
    }

    public boolean isAllMaxMin() {
        return this.isAllMaxMin;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("RadarAttr")) {
                this.isAllMaxMin = xMLableReader.getAttrAsBoolean("isAllMaxMin", false);
            } else if (string2.equals("MinValue")) {
                String string3 = xMLableReader.getAttrAsString("minValue", null);
                if (string3 != null) {
                    this.setMinValue(new Formula(string3));
                    this.setCustomMinValue(true);
                }
            } else if (string2.equals("MaxValue") && (string = xMLableReader.getAttrAsString("maxValue", null)) != null) {
                this.setMaxValue(new Formula(string));
                this.setCustomMaxValue(true);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("RadarAttr");
        xMLPrintWriter.attr("isAllMaxMin", this.isAllMaxMin);
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof RadarAxis && ((RadarAxis)object).isAllMaxMin == this.isAllMaxMin && super.equals(object);
    }

    public AxisGlyph createAxisGlyph(ChartData chartData) {
        RadarAxisGlyph radarAxisGlyph = new RadarAxisGlyph();
        this.initAxisGlyph(radarAxisGlyph);
        return radarAxisGlyph;
    }

    public void initAxisGlyph(RadarAxisGlyph radarAxisGlyph) {
        super.initAxisGlyph(radarAxisGlyph);
        radarAxisGlyph.setAllMaxMin(this.isAllMaxMin);
    }
}

