/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.FRContext;
import com.fr.base.MapHelper;
import com.fr.chart.base.MapSvgAttr;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class MapSvgXMLHelper
implements MapHelper {
    public static final String MAP_CATEGORY_WORLD = Inter.getLocText("FR-Chart-World_Map");
    public static final String MAP_CATEGORY_NATION = Inter.getLocText("FR-Chart-State_Map");
    public static final String MAP_CATEGORY_PROVINCE = Inter.getLocText("FR-Chart-Province_Map");
    public static final String MAP_CATEGORY_CUSTOMER = Inter.getLocText("FR-Chart-Custom_Map");
    public static int customIndex = 0;
    public static MapSvgXMLHelper mapSvgXMLHelper = null;
    private static boolean isMapLoaded = false;
    private static HashMap<Object, List> cateMaps = new HashMap();
    private static HashMap<String, MapSvgAttr> mapAttrsMap = new HashMap();
    private static HashMap<String, MapSvgAttr> newAttrsMap = new HashMap();

    public static synchronized MapSvgXMLHelper getInstance() {
        if (mapSvgXMLHelper == null) {
            MapSvgXMLHelper.readSvgMaps();
        }
        return mapSvgXMLHelper;
    }

    private static synchronized void envChanged() {
        mapSvgXMLHelper = null;
    }

    public List getNamesListWithCateName(Object object) {
        if (!cateMaps.containsKey(object)) {
            cateMaps.put(object, new ArrayList());
        }
        return cateMaps.get(object);
    }

    public JSONArray asJsonOfCategoriedMaps() throws JSONException {
        return new JSONArray().put(new JSONObject().put("category", MAP_CATEGORY_WORLD).put("map_names", this.getNamesListWithCateName(MAP_CATEGORY_WORLD))).put(new JSONObject().put("category", MAP_CATEGORY_NATION).put("map_names", this.getNamesListWithCateName(MAP_CATEGORY_NATION))).put(new JSONObject().put("category", MAP_CATEGORY_PROVINCE).put("map_names", this.getNamesListWithCateName(MAP_CATEGORY_PROVINCE))).put(new JSONObject().put("category", MAP_CATEGORY_CUSTOMER).put("map_names", this.getNamesListWithCateName(MAP_CATEGORY_CUSTOMER)));
    }

    public void clearCateNames() {
        cateMaps.clear();
    }

    public void clearNames4Cate(String string) {
        if (cateMaps.containsKey(string)) {
            cateMaps.remove(string);
        }
    }

    public void removeCateNames(String string, Object object) {
        if (cateMaps.containsKey(string)) {
            cateMaps.get(string).remove(object);
        }
    }

    public void addCateNames(String string, Object object) {
        if (cateMaps.containsKey(string)) {
            List list = cateMaps.get(string);
            if (!list.contains(object)) {
                list.add(object);
            }
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            cateMaps.put(string, arrayList);
        }
    }

    public MapSvgAttr[] getAllMapObjects4Cate(String string) {
        List list = this.getNamesListWithCateName(string);
        if (list.isEmpty()) {
            return new MapSvgAttr[0];
        }
        MapSvgAttr[] mapSvgAttrArray = new MapSvgAttr[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            mapSvgAttrArray[i2] = this.getMapAttr((String)list.get(i2));
        }
        return mapSvgAttrArray;
    }

    public static boolean hasLoadMap() {
        return isMapLoaded;
    }

    private static void readSvgMaps() {
        if (mapSvgXMLHelper == null) {
            mapSvgXMLHelper = new MapSvgXMLHelper();
        }
        mapSvgXMLHelper.reset();
        mapSvgXMLHelper.readDefaultMaps();
        mapSvgXMLHelper.readCustomMaps();
        isMapLoaded = true;
    }

    private static File[] getSvgFiles(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.exists() && file.isDirectory()) {
            return file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith("svg");
                }
            });
        }
        return new File[0];
    }

    private void readDefaultMaps() {
        File[] fileArray = FRContext.getCurrentEnv().readPathSvgFiles("chartmapsvg");
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            this.readSingleSVGMap(fileArray[i2]);
        }
    }

    private void readCustomMaps() {
        String string = StableUtils.pathJoin("chartmapsvg", "user-defined");
        File[] fileArray = FRContext.getCurrentEnv().readPathSvgFiles(string);
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            this.readSingleSVGMap(fileArray[i2]);
        }
    }

    public MapSvgAttr readSvgMapAttr(File file) {
        return new MapSvgAttr(file.getPath());
    }

    public void readSingleSVGMap(File file) {
        String string = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(string, true);
        try {
            SVGDocument sVGDocument = (SVGDocument)sAXSVGDocumentFactory.createDocument(file.toURI().toString());
            SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
            if (sVGSVGElement != null) {
                String string2 = sVGSVGElement.getAttribute("mapType");
                String string3 = sVGSVGElement.getAttribute("mapName");
                if (StringUtils.isBlank(string2)) {
                    string2 = MAP_CATEGORY_CUSTOMER;
                    sVGSVGElement.setAttribute("mapType", string2);
                }
                if (StringUtils.isBlank(string3)) {
                    string3 = MAP_CATEGORY_CUSTOMER + customIndex++;
                    sVGSVGElement.setAttribute("mapName", string3);
                }
                this.addCateNames(string2, string3);
                MapSvgAttr mapSvgAttr = new MapSvgAttr(file.getPath());
                mapSvgAttr.setName(string3);
                mapAttrsMap.put(string3, mapSvgAttr);
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage());
        }
    }

    public void reset() {
        cateMaps.clear();
        mapAttrsMap.clear();
    }

    public void addCustomSvgMap(String string, MapSvgAttr mapSvgAttr) {
        mapAttrsMap.put(string, mapSvgAttr);
    }

    public void addNewSvgMaps(String string, MapSvgAttr mapSvgAttr) {
        newAttrsMap.put(string, mapSvgAttr);
    }

    public void removeMapAttr(String string) {
        if (mapAttrsMap.containsKey(string) && mapAttrsMap.get(string).removeSvgFile()) {
            mapAttrsMap.remove(string);
        }
    }

    public void refreshMapName(String string, String string2) {
        MapSvgAttr mapSvgAttr = this.getMapAttr(string);
        if (mapSvgAttr != null) {
            this.removeMapAttr(string);
            this.pushMapAttr(string2, mapSvgAttr);
        } else {
            mapSvgAttr = this.getNewMapAttr(string);
            if (mapSvgAttr != null) {
                this.removeNewMapAttr(string);
                this.addNewSvgMaps(string2, mapSvgAttr);
            }
        }
    }

    public void pushMapAttr(String string, MapSvgAttr mapSvgAttr) {
        mapAttrsMap.put(string, mapSvgAttr);
    }

    public MapSvgAttr getMapAttr(String string) {
        if (mapAttrsMap.containsKey(string)) {
            return mapAttrsMap.get(string);
        }
        return null;
    }

    public MapSvgAttr getNewMapAttr(String string) {
        if (newAttrsMap.containsKey(string)) {
            return newAttrsMap.get(string);
        }
        return null;
    }

    public void removeNewMapAttr(String string) {
        if (newAttrsMap.containsKey(string) && newAttrsMap.get(string).removeSvgFile()) {
            newAttrsMap.remove(string);
        }
    }

    public void clearTempAttrMaps() {
        newAttrsMap.clear();
    }

    public String[] mapAllNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String stringArray2 : mapAttrsMap.keySet()) {
            arrayList.add(stringArray2.toString());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Collator collator = Collator.getInstance(Locale.CHINA);
        Arrays.sort(stringArray, collator);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(Inter.getLocText("Chart-Use_None"));
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList2.add(stringArray[i2]);
        }
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    public boolean containsMapName(String string) {
        return mapAttrsMap.containsKey(string);
    }

    public static String relativeDefaultMapPath() {
        return StableUtils.pathJoin("resources", "chartmapsvg");
    }

    public static String relativeCustomMapPath() {
        return StableUtils.pathJoin("resources", "chartmapsvg", "user-defined");
    }

    public static String defaultMapPath() {
        return StableUtils.pathJoin(GeneralContext.getEnvProvider().getPath(), MapSvgXMLHelper.relativeDefaultMapPath());
    }

    public static String customMapPath() {
        return StableUtils.pathJoin(GeneralContext.getEnvProvider().getPath(), MapSvgXMLHelper.relativeCustomMapPath());
    }

    public void saveEditedMaps(String[] stringArray) {
        for (String string : stringArray) {
            MapSvgAttr mapSvgAttr = mapAttrsMap.get(string);
            if (mapSvgAttr == null) continue;
            mapSvgAttr.writeBack(string);
        }
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                MapSvgXMLHelper.envChanged();
            }
        });
    }
}

