/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.concurrentlinkedhashmap;

import com.fr.cache.concurrentlinkedhashmap.Linked;
import com.fr.cache.concurrentlinkedhashmap.NotThreadSafe;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
final class LinkedDeque<E extends Linked<E>>
extends AbstractCollection<E> {
    E first;
    E last;
    int size;

    LinkedDeque() {
    }

    void linkFirst(E e2) {
        E e3 = this.first;
        this.first = e2;
        if (e3 == null) {
            this.last = e2;
        } else {
            e3.setPrevious(e2);
            e2.setNext(e3);
        }
    }

    void linkLast(E e2) {
        E e3 = this.last;
        this.last = e2;
        if (e3 == null) {
            this.first = e2;
        } else {
            e3.setNext(e2);
            e2.setPrevious(e3);
        }
    }

    E unlinkFirst() {
        E e2 = this.first;
        Object object = e2.getNext();
        e2.setNext(null);
        this.first = object;
        if (object == null) {
            this.last = null;
        } else {
            object.setPrevious(null);
        }
        return e2;
    }

    E unlinkLast() {
        E e2 = this.last;
        Object object = e2.getPrevious();
        e2.setPrevious(null);
        this.last = object;
        if (object == null) {
            this.first = null;
        } else {
            object.setNext(null);
        }
        return e2;
    }

    void unlink(E e2) {
        Object t2 = e2.getPrevious();
        Object t3 = e2.getNext();
        if (t2 == null) {
            this.first = t3;
        } else {
            t2.setNext(t3);
            e2.setPrevious(null);
        }
        if (t3 == null) {
            this.last = t2;
        } else {
            t3.setPrevious(t2);
            e2.setNext(null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first == null;
    }

    void checkNotEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Object object = this.first;
        while (object != null) {
            Object t2 = object.getNext();
            object.setPrevious(null);
            object.setNext(null);
            object = t2;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof Linked)) {
            return false;
        }
        Linked linked = (Linked)object;
        return linked.getPrevious() != null || linked.getNext() != null || linked == this.first;
    }

    public void moveToFront(E e2) {
        if (e2 != this.first) {
            this.unlink(e2);
            this.linkFirst(e2);
        }
    }

    public void moveToBack(E e2) {
        if (e2 != this.last) {
            this.unlink(e2);
            this.linkLast(e2);
        }
    }

    public E peek() {
        return this.peekFirst();
    }

    public E peekFirst() {
        return this.first;
    }

    public E peekLast() {
        return this.last;
    }

    public E getFirst() {
        this.checkNotEmpty();
        return this.peekFirst();
    }

    public E getLast() {
        this.checkNotEmpty();
        return this.peekLast();
    }

    public E element() {
        return this.getFirst();
    }

    public boolean offer(E e2) {
        return this.offerLast(e2);
    }

    public boolean offerFirst(E e2) {
        if (this.contains(e2)) {
            return false;
        }
        ++this.size;
        this.linkFirst(e2);
        return true;
    }

    public boolean offerLast(E e2) {
        if (this.contains(e2)) {
            return false;
        }
        ++this.size;
        this.linkLast(e2);
        return true;
    }

    @Override
    public boolean add(E e2) {
        return this.offerLast(e2);
    }

    public void addFirst(E e2) {
        if (!this.offerFirst(e2)) {
            throw new IllegalArgumentException();
        }
    }

    public void addLast(E e2) {
        if (!this.offerLast(e2)) {
            throw new IllegalArgumentException();
        }
    }

    public E poll() {
        return this.pollFirst();
    }

    public E pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        --this.size;
        return this.unlinkFirst();
    }

    public E pollLast() {
        if (this.isEmpty()) {
            return null;
        }
        --this.size;
        return this.unlinkLast();
    }

    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        if (this.contains(object)) {
            --this.size;
            this.unlink((Linked)object);
            return true;
        }
        return false;
    }

    public E removeFirst() {
        this.checkNotEmpty();
        return this.pollFirst();
    }

    public boolean removeFirstOccurrence(Object object) {
        return this.remove(object);
    }

    public E removeLast() {
        this.checkNotEmpty();
        return this.pollLast();
    }

    public boolean removeLastOccurrence(Object object) {
        return this.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    public void push(E e2) {
        this.addFirst(e2);
    }

    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> iterator() {
        return new AbstractLinkedIterator((Linked)this.first){

            @Override
            E computeNext() {
                return this.cursor.getNext();
            }
        };
    }

    public Iterator<E> descendingIterator() {
        return new AbstractLinkedIterator((Linked)this.last){

            @Override
            E computeNext() {
                return this.cursor.getPrevious();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractLinkedIterator
    implements Iterator<E> {
        E cursor;
        final /* synthetic */ LinkedDeque this$0;

        AbstractLinkedIterator(E e2) {
            this.this$0 = var1_1;
            this.cursor = e2;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object e2 = this.cursor;
            this.cursor = this.computeNext();
            return e2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        abstract E computeNext();
    }
}

