/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache;

import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.ManagerFactory;
import com.fr.stable.StableUtils;
import com.fr.stable.serialize.SerializationUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DiskCacheMap
extends AbstractMap {
    private File cacheDirectory = null;
    private String prefix = "MapCache";
    private Map key_file_map = new Hashtable();

    public DiskCacheMap() {
        this.cacheDirectory = this.getCacheDirectory();
    }

    public boolean containsKey(Object object) {
        return this.key_file_map.containsKey(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        Object object3;
        if (this.key_file_map.containsKey(object)) {
            object3 = this.key_file_map;
            synchronized (object3) {
                File file = (File)this.key_file_map.get(object);
                if (file != null) {
                    Object object4 = null;
                    try {
                        object4 = SerializationUtils.deserializable(file);
                        SerializationUtils.serializable((Serializable)object2, file);
                    }
                    catch (Exception exception) {
                        FRLogger.getLogger().error(exception.getMessage(), exception);
                    }
                    return object4;
                }
            }
        }
        object3 = new File(this.getCacheDirectory(), this.getPrefix() + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
        try {
            SerializationUtils.serializable((Serializable)object2, (File)object3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FRLogger.getLogger().errorWithServerLevel("\n" + Inter.getLocText("Cache_Dir_File_Permission_Error") + "\n" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.key_file_map.put(object, object3);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        Map map = this.key_file_map;
        synchronized (map) {
            File file = (File)this.key_file_map.remove(object);
            if (file != null) {
                Object object2 = null;
                try {
                    object2 = SerializationUtils.deserializable(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StableUtils.deleteFile(file);
                return object2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Map map = this.key_file_map;
        synchronized (map) {
            File file = (File)this.key_file_map.get(object);
            if (file != null) {
                try {
                    return SerializationUtils.deserializable(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FRLogger.getLogger().errorWithServerLevel("\n" + Inter.getLocText("Cache_Dir_File_Permission_Error") + "\n" + fileNotFoundException.getMessage(), fileNotFoundException);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public int size() {
        return this.key_file_map.size();
    }

    public Set entrySet() {
        return new CacheEntrySet();
    }

    public void clear() {
        this.key_file_map.clear();
        if (this.cacheDirectory != null) {
            StableUtils.deleteFile(this.cacheDirectory);
        }
    }

    private String getPrefix() {
        return this.prefix;
    }

    private File getCacheDirectory() {
        if (this.cacheDirectory == null || !this.cacheDirectory.exists()) {
            this.cacheDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
            int n2 = 0;
            while (this.cacheDirectory.exists()) {
                this.cacheDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n2);
                ++n2;
            }
            StableUtils.mkdirs(this.cacheDirectory);
            this.cacheDirectory.deleteOnExit();
        }
        return this.cacheDirectory;
    }

    public void release() {
        if (this.cacheDirectory != null) {
            StableUtils.deleteFile(this.cacheDirectory);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    static class CacheEntry
    implements Map.Entry {
        Map.Entry key_file_entry;

        CacheEntry(Map.Entry entry) {
            this.key_file_entry = entry;
        }

        public Object getKey() {
            return this.key_file_entry.getKey();
        }

        public Object getValue() {
            File file = (File)this.key_file_entry.getValue();
            if (file != null) {
                try {
                    return SerializationUtils.deserializable(file);
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
            }
            return null;
        }

        public Object setValue(Object object) {
            File file = (File)this.key_file_entry.getValue();
            if (file != null) {
                Object object2 = null;
                try {
                    object2 = SerializationUtils.deserializable(file);
                    SerializationUtils.serializable((Serializable)object, file);
                    return object2;
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
            }
            return null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CacheEntry)) {
                return false;
            }
            CacheEntry cacheEntry = (CacheEntry)object;
            return this.key_file_entry.equals(cacheEntry.key_file_entry);
        }

        public int hashCode() {
            return this.key_file_entry.hashCode() + 1;
        }

        public String toString() {
            return "CacheEntry" + this.key_file_entry.toString();
        }
    }

    private class CacheEntryIterator
    implements Iterator {
        Iterator key_file_iterator = null;
        private transient Map.Entry entry = null;

        public CacheEntryIterator() {
            this.key_file_iterator = DiskCacheMap.this.key_file_map.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.key_file_iterator.hasNext();
        }

        public Object next() {
            this.entry = (Map.Entry)this.key_file_iterator.next();
            return new CacheEntry(this.entry);
        }

        public void remove() {
            this.key_file_iterator.remove();
            if (this.entry != null) {
                DiskCacheMap.this.remove(this.entry.getKey());
            }
        }
    }

    private class CacheEntrySet
    extends AbstractSet {
        private CacheEntrySet() {
        }

        public Iterator iterator() {
            return new CacheEntryIterator();
        }

        public boolean contains(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return DiskCacheMap.this.size();
        }

        public void clear() {
            DiskCacheMap.this.clear();
        }
    }
}

