/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.platform.msg.cache;

import com.fr.base.platform.msg.Message;
import com.fr.base.platform.msg.cache.MobileMessageCache;
import com.fr.base.platform.msg.cache.MobileMessageCacheProvider;
import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;

public class MobileMessageCacheImpl
implements MobileMessageCacheProvider {
    private static MobileMessageCacheProvider messageCacheProvider;

    public static MobileMessageCacheProvider getInstance() {
        if (messageCacheProvider == null) {
            MobileMessageCacheImpl.initCacheImpl();
        }
        return messageCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                messageCacheProvider = new MobileMessageCacheImpl();
                RPC.registerSkeleton(messageCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                messageCacheProvider = (MobileMessageCacheProvider)RPC.getProxy(MobileMessageCacheImpl.class, string);
                break;
            }
            default: {
                messageCacheProvider = new MobileMessageCacheImpl();
            }
        }
    }

    public boolean cache(String string, Message message) throws Exception {
        return MobileMessageCache.cache(string, message);
    }

    public boolean removeCache(String string) throws Exception {
        return MobileMessageCache.removeCache(string);
    }

    public Message[] getMessages(String string, String string2) throws Exception {
        return MobileMessageCache.getAllMessages(string, string2);
    }

    public boolean updateToasted(String string) throws Exception {
        return MobileMessageCache.updateToasted(string);
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                messageCacheProvider = null;
            }
        });
    }
}

