/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.platform.msg;

import com.fr.general.DateUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.util.Date;

public abstract class Message {
    public static final String TOASTED = "toasted";
    public static final String USER_ID = "userId";
    public static final String USER_NAME = "username";
    public static final String ID = "id";
    public static final String DATETIME = "datetime";
    public static final String CREATETIME = "createTime";
    public static final String MESSAGE = "message";
    public static final String URL = "url";
    public static final String TYPE = "type";
    public static final String DEFAULT_TERMINALTYPE = "0";
    public static final String READED = "readed";
    public static final String DF1 = "yyyy-MM-dd";
    public static final String DF2 = "yyyy-MM-dd HH:mm";
    protected long id = -1L;
    protected long userId;
    protected String username;
    protected Date datetime = new Date();
    private Date createTime;
    protected String message;
    protected String type = this.getType();
    protected String url;
    protected boolean toasted = false;
    protected boolean readed = false;

    public Message() {
    }

    public Message(long l2, String string, String string2) {
        this.userId = l2;
        this.message = string;
        this.url = string2;
    }

    public Message(long l2, String string, String string2, String string3) {
        this.userId = l2;
        this.username = string;
        this.message = string2;
        this.url = string3;
    }

    public String getTerminaltype() {
        return DEFAULT_TERMINALTYPE;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date date) {
        this.createTime = date;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l2) {
        this.id = l2;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long l2) {
        this.userId = l2;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public abstract String getType();

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public boolean isReaded() {
        return this.readed;
    }

    public void setReaded(boolean bl) {
        this.readed = bl;
    }

    public boolean isToasted() {
        return this.toasted;
    }

    public void setToasted(boolean bl) {
        this.toasted = bl;
    }

    public JSONObject createJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(ID, this.id);
        if (this.type == null) {
            jSONObject.put(TYPE, this.getType());
        } else {
            jSONObject.put(TYPE, this.type);
        }
        jSONObject.put(USER_ID, this.userId);
        jSONObject.put(USER_NAME, this.username);
        jSONObject.put(MESSAGE, this.message);
        jSONObject.put(TOASTED, this.toasted);
        jSONObject.put(READED, this.readed);
        if (this.createTime == null) {
            jSONObject.put(CREATETIME, DateUtils.getDate2Str(DF1, this.datetime));
        } else {
            jSONObject.put(CREATETIME, DateUtils.getDate2Str(DF2, this.createTime));
        }
        jSONObject.put(URL, this.url);
        return jSONObject;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

