/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.io;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.base.io.XMLEncryptKey;
import com.fr.general.ComparatorUtils;
import com.fr.general.DesUtils;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.stable.CodeUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.LicUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class XMLEncryptUtils {
    public static final String XML_TAG = "<FREncrypted>";
    public static final String KEY_NAME = "encryption.key";
    private static XMLEncryptKey KEY;

    public static boolean isCptEncoded() {
        return StringUtils.isNotEmpty(KEY.toString());
    }

    public static boolean checkVaild(String string) {
        return ComparatorUtils.equals(CodeUtils.passwordDecode(string), KEY.toString());
    }

    private static void readKey() {
        try {
            String string = XMLEncryptUtils.readKeyFromLic();
            String string2 = XMLEncryptUtils.readKeyFromLocal();
            KEY = StringUtils.isEmpty(string) ? new XMLEncryptKey(string2, true) : new XMLEncryptKey(string, ComparatorUtils.equals(string, string2));
        }
        catch (Exception exception) {
            KEY = new XMLEncryptKey();
        }
    }

    private static String readKeyFromLocal() throws Exception {
        InputStream inputStream = FRContext.getCurrentEnv().readBean(KEY_NAME, "resources");
        if (inputStream == null) {
            return "";
        }
        return CodeUtils.passwordDecode(XMLEncryptUtils.readStreamAsString(inputStream));
    }

    private static String readKeyFromLic() throws Exception {
        return LicUtils.getItemFromLic("KEY");
    }

    public static void setKEY(String string) {
        KEY = new XMLEncryptKey(string, true);
        try {
            Env env = FRContext.getCurrentEnv();
            if (StringUtils.isEmpty(string)) {
                File file = new File(StableUtils.pathJoin(env.getPath(), "resources", KEY_NAME));
                StableUtils.deleteFile(file);
            } else {
                OutputStream outputStream = env.writeBean(KEY_NAME, "resources");
                XMLEncryptUtils.writeToOutputStream(CodeUtils.passwordEncode(string), outputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getKEY() {
        return KEY.toString();
    }

    public static File getReportletFolder() {
        Env env = FRContext.getCurrentEnv();
        return new File(StableUtils.pathJoin(env.getPath(), "reportlets"));
    }

    public static void encodeAllFile(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2].isDirectory()) {
                XMLEncryptUtils.encodeAllFile(fileArray[i2]);
                continue;
            }
            if (!fileArray[i2].getName().endsWith(".cpt") && !fileArray[i2].getName().endsWith(".frm")) continue;
            XMLEncryptUtils.encodeSingleFile(fileArray[i2]);
        }
    }

    public static void decodeAllFile(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2].isDirectory()) {
                XMLEncryptUtils.decodeAllFile(fileArray[i2]);
                continue;
            }
            if (!fileArray[i2].getName().endsWith(".cpt") && !fileArray[i2].getName().endsWith(".frm")) continue;
            XMLEncryptUtils.decodeSingleFile(fileArray[i2]);
        }
    }

    public static void decodeSingleFile(File file) {
        String string = XMLEncryptUtils.readFileAsString(file);
        if (string.indexOf(XML_TAG) == -1 || StringUtils.isEmpty(KEY.toString())) {
            return;
        }
        string = string.replaceAll(XML_TAG, "");
        String string2 = DesUtils.getDecString(string, KEY.toString());
        XMLEncryptUtils.writeToFile(string2, file);
    }

    public static InputStream decodeInputStream(InputStream inputStream) {
        try {
            if (StringUtils.isEmpty(KEY.toString())) {
                return inputStream;
            }
            String string = XMLEncryptUtils.readStreamAsString(inputStream);
            if (string.indexOf(XML_TAG) == -1 && KEY.isMatchedInlic()) {
                return new ByteArrayInputStream(string.getBytes("UTF-8"));
            }
            string = string.replaceAll(XML_TAG, "");
            String string2 = DesUtils.getDecString(string, KEY.toString());
            return new ByteArrayInputStream(string2.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(Inter.getLocText("FR-Engine_ECP_decode_failed") + exception.getMessage());
            return inputStream;
        }
    }

    public static InputStream encodeInputStream(InputStream inputStream) {
        try {
            if (StringUtils.isEmpty(KEY.toString())) {
                return inputStream;
            }
            String string = XMLEncryptUtils.readStreamAsString(inputStream);
            if (string.indexOf(XML_TAG) != -1 || !KEY.isMatchedInlic()) {
                return new ByteArrayInputStream(string.getBytes("UTF-8"));
            }
            String string2 = XML_TAG + DesUtils.getEncString(string, KEY.toString());
            return new ByteArrayInputStream(string2.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(Inter.getLocText("FR-Engine_ECP_encode_failed") + exception.getMessage());
            return inputStream;
        }
    }

    public static void encodeSingleFile(File file) {
        String string = XMLEncryptUtils.readFileAsString(file);
        if (string.indexOf(XML_TAG) != -1 || StringUtils.isEmpty(KEY.toString())) {
            return;
        }
        String string2 = XML_TAG + DesUtils.getEncString(string, KEY.toString());
        XMLEncryptUtils.writeToFile(string2, file);
    }

    private static void writeToOutputStream(String string, OutputStream outputStream) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage());
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void writeToFile(String string, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            XMLEncryptUtils.writeToOutputStream(string, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static String readFileAsString(File file) {
        try {
            return XMLEncryptUtils.readStreamAsString(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            FRContext.getLogger().error(fileNotFoundException.getMessage());
            return "";
        }
    }

    private static String readStreamAsString(InputStream inputStream) {
        try {
            return Utils.inputStream2String(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    static {
        XMLEncryptUtils.readKey();
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                XMLEncryptUtils.readKey();
            }
        });
    }
}

