/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.io;

import com.fr.base.FRContext;
import com.fr.base.io.XMLEncryptUtils;
import com.fr.data.AbstractTableDataSource;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.ProductConstants;
import com.fr.stable.StringUtils;
import com.fr.stable.core.UUID;
import com.fr.stable.fun.IOFileAttrMark;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLVersion;
import com.fr.stable.xml.XMLableReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IOFile
extends AbstractTableDataSource {
    private String designerVersion = null;
    protected XMLVersion xmlVersion = null;
    private String templateID = null;
    private int previewType;
    public static final int DEFAULT_PREVIEW_TYPE = 0;
    public static final int WRITE_PREVIEW_TYPE = 1;
    public static final int ANA_PREVIEW_TYPE = 2;
    private Map<String, IOFileAttrMark> attrMarkMap;

    public void addAttrMark(IOFileAttrMark iOFileAttrMark) {
        if (this.attrMarkMap == null) {
            this.attrMarkMap = new HashMap<String, IOFileAttrMark>();
        }
        this.attrMarkMap.put(iOFileAttrMark.xmlTag(), iOFileAttrMark);
    }

    public void initTemplateID() {
        this.templateID = UUID.randomUUID().toString();
    }

    public String getTemplateID() {
        return this.templateID;
    }

    public <T extends IOFileAttrMark> T getAttrMark(String string) {
        if (this.attrMarkMap == null) {
            return null;
        }
        IOFileAttrMark iOFileAttrMark = this.attrMarkMap.get(string);
        return (T)iOFileAttrMark;
    }

    public abstract void readStream(InputStream var1) throws Exception;

    public boolean export(OutputStream outputStream) throws Exception {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(byteArrayOutputStream);
        xMLPrintWriter.startTAG(this.openTag());
        this.mainContent(xMLPrintWriter);
        this.writeDesign(xMLPrintWriter);
        this.writeExtra(xMLPrintWriter);
        xMLPrintWriter.end();
        xMLPrintWriter.flush();
        xMLPrintWriter.close();
        InputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        inputStream = XMLEncryptUtils.encodeInputStream(inputStream);
        byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n2);
        }
        byteArrayOutputStream.writeTo(outputStream);
        outputStream.flush();
        outputStream.close();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return true;
    }

    protected abstract String openTag();

    protected abstract void mainContent(XMLPrintWriter var1);

    protected void readDesign(XMLableReader xMLableReader) {
        if (!xMLableReader.isChildNode()) {
            return;
        }
        String string = xMLableReader.getAttrAsString("DesignerVersion", null);
        if (string != null) {
            this.designerVersion = string;
            if (this.isHigherThanCurrent(this.designerVersion)) {
                FRContext.getLogger().log(Level.WARNING, Inter.getLocText("FR-Designer_Template-Version-Warning"));
            }
        }
        this.templateID = xMLableReader.getAttrAsString("TemplateID", null);
        this.previewType = xMLableReader.getAttrAsInt("PreviewType", 0);
    }

    public String getXMLDesignerVersion() {
        return this.designerVersion;
    }

    public XMLVersion getXmlVersion() {
        return this.xmlVersion;
    }

    protected boolean isHigherThanCurrent(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        int n2 = ComparatorUtils.compare(string, ProductConstants.DESIGNER_VERSION);
        return n2 > 0;
    }

    private void writeDesign(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("DesignerVersion").attr("DesignerVersion", ProductConstants.DESIGNER_VERSION);
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("PreviewType").attr("PreviewType", this.previewType);
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("TemplateID").attr("TemplateID", this.templateID);
        xMLPrintWriter.end();
    }

    protected void readExtra(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            Set set = ExtraClassManager.getInstance().getArray("IOFileAttrMark");
            for (IOFileAttrMark iOFileAttrMark : set) {
                if (!string.equals(iOFileAttrMark.xmlTag())) continue;
                IOFileAttrMark iOFileAttrMark2 = iOFileAttrMark.clone();
                xMLableReader.readXMLObject(iOFileAttrMark2);
                this.addAttrMark(iOFileAttrMark2);
            }
        }
    }

    private void writeExtra(XMLPrintWriter xMLPrintWriter) {
        if (this.attrMarkMap != null) {
            for (Map.Entry<String, IOFileAttrMark> entry : this.attrMarkMap.entrySet()) {
                GeneralXMLTools.writeXMLable(xMLPrintWriter, entry.getValue(), entry.getKey());
            }
        }
    }

    public int getPreviewType() {
        return this.previewType;
    }

    public void setPreviewType(int n2) {
        this.previewType = n2;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        IOFile iOFile = (IOFile)super.clone();
        if (this.attrMarkMap != null) {
            HashMap<String, IOFileAttrMark> hashMap = new HashMap<String, IOFileAttrMark>();
            for (Map.Entry<String, IOFileAttrMark> entry : this.attrMarkMap.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().clone());
            }
            iOFile.attrMarkMap = hashMap;
        }
        return iOFile;
    }
}

