/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core.serializable;

import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ShapeSerializable
implements Serializable {
    private transient Shape shape;

    public ShapeSerializable(Shape shape) {
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Shape shape = this.getShape();
        if (shape == null) {
            objectOutputStream.writeBoolean(true);
        } else {
            objectOutputStream.writeBoolean(false);
            if (shape instanceof Line2D) {
                Line2D line2D = (Line2D)shape;
                objectOutputStream.writeObject(Line2D.class);
                objectOutputStream.writeDouble(line2D.getX1());
                objectOutputStream.writeDouble(line2D.getY1());
                objectOutputStream.writeDouble(line2D.getX2());
                objectOutputStream.writeDouble(line2D.getY2());
            } else if (shape instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)shape;
                objectOutputStream.writeObject(Rectangle2D.class);
                objectOutputStream.writeDouble(rectangle2D.getX());
                objectOutputStream.writeDouble(rectangle2D.getY());
                objectOutputStream.writeDouble(rectangle2D.getWidth());
                objectOutputStream.writeDouble(rectangle2D.getHeight());
            } else if (shape instanceof Ellipse2D) {
                Ellipse2D ellipse2D = (Ellipse2D)shape;
                objectOutputStream.writeObject(Ellipse2D.class);
                objectOutputStream.writeDouble(ellipse2D.getX());
                objectOutputStream.writeDouble(ellipse2D.getY());
                objectOutputStream.writeDouble(ellipse2D.getWidth());
                objectOutputStream.writeDouble(ellipse2D.getHeight());
            } else if (shape instanceof Arc2D) {
                Arc2D arc2D = (Arc2D)shape;
                objectOutputStream.writeObject(Arc2D.class);
                objectOutputStream.writeDouble(arc2D.getX());
                objectOutputStream.writeDouble(arc2D.getY());
                objectOutputStream.writeDouble(arc2D.getWidth());
                objectOutputStream.writeDouble(arc2D.getHeight());
                objectOutputStream.writeDouble(arc2D.getAngleStart());
                objectOutputStream.writeDouble(arc2D.getAngleExtent());
                objectOutputStream.writeInt(arc2D.getArcType());
            } else if (shape instanceof GeneralPath) {
                objectOutputStream.writeObject(GeneralPath.class);
                PathIterator pathIterator = shape.getPathIterator(null);
                float[] fArray = new float[6];
                objectOutputStream.writeBoolean(pathIterator.isDone());
                while (!pathIterator.isDone()) {
                    int n2 = pathIterator.currentSegment(fArray);
                    objectOutputStream.writeInt(n2);
                    for (int i2 = 0; i2 < 6; ++i2) {
                        objectOutputStream.writeFloat(fArray[i2]);
                    }
                    objectOutputStream.writeInt(pathIterator.getWindingRule());
                    pathIterator.next();
                    objectOutputStream.writeBoolean(pathIterator.isDone());
                }
            } else {
                objectOutputStream.writeObject(shape.getClass());
                objectOutputStream.writeObject(shape);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Shape shape = null;
        boolean bl = objectInputStream.readBoolean();
        if (!bl) {
            Class clazz = (Class)objectInputStream.readObject();
            if (clazz.equals(Line2D.class)) {
                double d2 = objectInputStream.readDouble();
                double d3 = objectInputStream.readDouble();
                double d4 = objectInputStream.readDouble();
                double d5 = objectInputStream.readDouble();
                shape = new Line2D.Double(d2, d3, d4, d5);
            } else if (clazz.equals(Rectangle2D.class)) {
                double d6 = objectInputStream.readDouble();
                double d7 = objectInputStream.readDouble();
                double d8 = objectInputStream.readDouble();
                double d9 = objectInputStream.readDouble();
                shape = new Rectangle2D.Double(d6, d7, d8, d9);
            } else if (clazz.equals(Ellipse2D.class)) {
                double d10 = objectInputStream.readDouble();
                double d11 = objectInputStream.readDouble();
                double d12 = objectInputStream.readDouble();
                double d13 = objectInputStream.readDouble();
                shape = new Ellipse2D.Double(d10, d11, d12, d13);
            } else if (clazz.equals(Arc2D.class)) {
                double d14 = objectInputStream.readDouble();
                double d15 = objectInputStream.readDouble();
                double d16 = objectInputStream.readDouble();
                double d17 = objectInputStream.readDouble();
                double d18 = objectInputStream.readDouble();
                double d19 = objectInputStream.readDouble();
                int n2 = objectInputStream.readInt();
                shape = new Arc2D.Double(d14, d15, d16, d17, d18, d19, n2);
            } else if (clazz.equals(GeneralPath.class)) {
                GeneralPath generalPath = new GeneralPath();
                float[] fArray = new float[6];
                boolean bl2 = objectInputStream.readBoolean();
                while (!bl2) {
                    int n3 = objectInputStream.readInt();
                    for (int i2 = 0; i2 < 6; ++i2) {
                        fArray[i2] = objectInputStream.readFloat();
                    }
                    switch (n3) {
                        case 0: {
                            generalPath.moveTo(fArray[0], fArray[1]);
                            break;
                        }
                        case 1: {
                            generalPath.lineTo(fArray[0], fArray[1]);
                            break;
                        }
                        case 3: {
                            generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                            break;
                        }
                        case 2: {
                            generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("No GeneralPath");
                        }
                    }
                    generalPath.setWindingRule(objectInputStream.readInt());
                    bl2 = objectInputStream.readBoolean();
                }
                shape = generalPath;
            } else {
                shape = (Shape)objectInputStream.readObject();
            }
        }
        this.setShape(shape);
    }
}

