/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core;

import com.fr.base.BaseUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;

public class KV
implements XMLable {
    public static final String XML_TAG = "KV";
    public static final String ARRAY_XML_TAG = "KVS";
    private String key;
    private Object value;

    public KV() {
    }

    public KV(String string, Object object) {
        this.key = string;
        this.value = object;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr() && (string = xMLableReader.getAttrAsString("key", null)) != null) {
            this.key = string;
        }
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("O")) {
            this.value = GeneralXMLTools.readObject(xMLableReader);
        }
    }

    public static KV[] readKTVArray(XMLableReader xMLableReader) {
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                String string;
                if (xMLableReader.isChildNode() && (KV.XML_TAG.equals(string = xMLableReader.getTagName()) || "KTV".equals(string))) {
                    KV kV = new KV();
                    xMLableReader.readXMLObject(kV);
                    arrayList.add(kV);
                }
            }
        });
        return arrayList.toArray(new KV[arrayList.size()]);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("key", this.getKey());
        GeneralXMLTools.writeObject(xMLPrintWriter, this.value);
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof KV)) {
            return false;
        }
        KV kV = (KV)object;
        return ComparatorUtils.equals(this.getKey(), kV.getKey()) && ComparatorUtils.equals(this.getValue(), kV.getValue());
    }

    public String toString() {
        return "[key:" + this.getKey() + " value:" + this.getValue() + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        KV kV = (KV)super.clone();
        if (this.value != null) {
            kV.value = BaseUtils.cloneObject(this.value);
        }
        return kV;
    }
}

