/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.Base64;
import com.fr.base.background.AbstractBackground;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class GradientBackground
extends AbstractBackground {
    public static final int LEFT2RIGHT = 0;
    public static final int TOP2BOTTOM = 1;
    private int direction = 0;
    private boolean useCell = true;
    private boolean cyclic = false;
    private float begin = 0.0f;
    private float finish = 0.0f;
    private Color startColor;
    private Color endColor;

    public GradientBackground() {
    }

    public GradientBackground(Color color, Color color2) {
        this(color, color2, 0);
    }

    public GradientBackground(Color color, Color color2, int n2) {
        this.startColor = color;
        this.endColor = color2;
        this.direction = n2;
    }

    public void setStartColor(Color color) {
        this.startColor = color;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setEndColor(Color color) {
        this.endColor = color;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setDirection(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Illegal direction!");
        }
        this.direction = n2;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean isUseCell() {
        return this.useCell;
    }

    public void setUseCell(boolean bl) {
        this.useCell = bl;
    }

    public boolean isCycle() {
        return this.cyclic;
    }

    public void setCycle(boolean bl) {
        this.cyclic = bl;
    }

    public void setBeginPlace(float f2) {
        this.begin = f2;
    }

    public float getBeginPlace() {
        return this.begin;
    }

    public void setFinishPlace(float f2) {
        this.finish = f2;
    }

    public float getFinishPlace() {
        return this.finish;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (shape == null || this.startColor == null || this.endColor == null) {
            return;
        }
        Paint paint = this.createPaint(shape);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint2 = graphics2D.getPaint();
        graphics2D.setPaint(paint);
        graphics2D.fill(shape);
        graphics2D.setPaint(paint2);
    }

    public void drawWithGradientLine(Graphics graphics, Shape shape) {
        if (shape == null || this.startColor == null || this.endColor == null) {
            return;
        }
        Paint paint = this.createPaint(shape);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint2 = graphics2D.getPaint();
        graphics2D.setPaint(paint);
        graphics2D.draw(shape);
        graphics2D.setPaint(paint2);
    }

    private Paint createPaint(Shape shape) {
        GradientPaint gradientPaint = null;
        Point2D.Float float_ = null;
        Point2D.Float float_2 = null;
        if (this.isUseCell()) {
            float_ = new Point2D.Float(shape.getBounds().x, shape.getBounds().y);
            if (this.direction == 0) {
                float_2 = new Point2D.Float((float)shape.getBounds().x + (float)shape.getBounds().width, shape.getBounds().y);
            } else if (this.direction == 1) {
                float_2 = new Point2D.Float(shape.getBounds().x, (float)shape.getBounds().y + (float)shape.getBounds().height);
            }
        } else if (this.direction == 0) {
            float_ = new Point2D.Float(this.begin, shape.getBounds().y);
            float_2 = new Point2D.Float(this.finish, shape.getBounds().y);
        } else if (this.direction == 1) {
            float_ = new Point2D.Float(shape.getBounds().x, this.begin);
            float_2 = new Point2D.Float(shape.getBounds().x, this.finish);
        }
        gradientPaint = new GradientPaint(float_, this.startColor, float_2, this.endColor, this.cyclic);
        return gradientPaint;
    }

    public boolean equals(Object object) {
        return object instanceof GradientBackground && ((GradientBackground)object).begin == this.begin && ((GradientBackground)object).finish == this.finish && ((GradientBackground)object).cyclic == this.cyclic && ((GradientBackground)object).useCell == this.useCell && ((GradientBackground)object).direction == this.direction && ComparatorUtils.equals(((GradientBackground)object).startColor, this.startColor) && ComparatorUtils.equals(((GradientBackground)object).endColor, this.endColor);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("direction", this.direction);
        jSONObject.put("beginColor", StableUtils.javaColorToCSSColor(this.startColor));
        jSONObject.put("endColor", StableUtils.javaColorToCSSColor(this.endColor));
        jSONObject.put("begin", this.begin);
        jSONObject.put("finish", this.finish);
        jSONObject.put("cyclic", this.cyclic);
        jSONObject.put("useCell", this.useCell);
        jSONObject.put("image", Base64.encode(this.createBufferedImage(160, 160), "png"));
        return jSONObject;
    }

    public String getBackgroundType() {
        return "GradientBackground";
    }

    public Background readAdditionalAttr(XMLableReader xMLableReader) {
        this.setStartColor(xMLableReader.getAttrAsColor("color1", Color.black));
        this.setEndColor(xMLableReader.getAttrAsColor("color2", Color.black));
        this.setDirection(xMLableReader.getAttrAsInt("direction", 0));
        this.setUseCell(xMLableReader.getAttrAsBoolean("useCell", true));
        if (!this.isUseCell()) {
            this.setBeginPlace(xMLableReader.getAttrAsFloat("begin", 0.0f));
            this.setFinishPlace(xMLableReader.getAttrAsFloat("finish", 0.0f));
            this.setCycle(xMLableReader.getAttrAsBoolean("cyclic", false));
        }
        return this;
    }

    public void writeAdditionalAttr(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.attr("name", "GradientBackground");
        if (this.getStartColor() != null) {
            xMLPrintWriter.attr("color1", this.getStartColor().getRGB());
        }
        if (this.getEndColor() != null) {
            xMLPrintWriter.attr("color2", this.getEndColor().getRGB());
        }
        xMLPrintWriter.attr("direction", this.getDirection()).attr("useCell", this.isUseCell()).attr("begin", this.getBeginPlace()).attr("finish", this.getFinishPlace()).attr("cyclic", this.isCycle());
    }
}

