/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.Base64;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.bridge.ObjectHolder;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class AbstractBackground
implements Background {
    private static final long serialVersionUID = 383043117498931335L;

    public void paint(Graphics graphics, Repository repository, Shape shape) {
        this.paint(graphics, shape);
    }

    public void layoutDidChange(int n2, int n3) {
    }

    public int fixHashCode(int n2) {
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("backgroundType", this.getBackgroundType());
        return jSONObject;
    }

    public JSONObject toJSONObject(Repository repository, Dimension dimension) throws JSONException {
        JSONObject jSONObject = this.toJSONObject();
        BufferedImage bufferedImage = this.createBufferedImage(dimension.width, dimension.height);
        if (bufferedImage != null) {
            jSONObject.put("image", Base64.encode(bufferedImage, "png"));
        }
        return jSONObject;
    }

    protected BufferedImage createBufferedImage(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return null;
        }
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paint(graphics2D, new Rectangle2D.Double(0.0, 0.0, n2, n3));
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public Background readAdditionalAttr(XMLableReader xMLableReader) {
        return this;
    }

    public void writeAdditionalAttr(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.attr("class", this.getClass().getName());
    }

    public void preDealBackground(Graphics graphics, Repository repository, Point point, int n2, int n3) {
    }

    public Background traverseForExport(ObjectHolder objectHolder) {
        return this;
    }
}

