/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.data.DataUtils;
import com.fr.data.PresentationType;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.IOUtils;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class Utils {
    private static String[] availableFontFamilyNames4Report = null;

    private Utils() {
    }

    public static void nativeExcuteInstallHomePrograms(String string) {
        String string2 = StableUtils.getInstallHome();
        if (string2 == null) {
            FRContext.getLogger().error("Can not find the install home, please check it.");
            return;
        }
        String string3 = StableUtils.pathJoin(string2, "bin", string);
        if (!new File(string3).exists()) {
            FRContext.getLogger().error(string3 + " can not be found.");
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(string3);
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage(), iOException);
        }
    }

    public static String doubleToString(double d2) {
        return StableUtils.doubleToString(d2);
    }

    public static String doubleToString(double d2, boolean bl) {
        return Utils.convertNumberStringToString(new Double(d2), bl);
    }

    public static String convertNumberStringToString(Number number) {
        return StableUtils.convertNumberStringToString(number, false);
    }

    public static String convertNumberStringToString(Number number, boolean bl) {
        return StableUtils.convertNumberStringToString(number, bl);
    }

    public static String inputStream2String(InputStream inputStream, String string) throws UnsupportedEncodingException {
        return new String(Utils.inputStream2Bytes(inputStream), string);
    }

    public static byte[] inputStream2Bytes(InputStream inputStream) {
        return IOUtils.inputStream2Bytes(inputStream);
    }

    public static Number objectToNumber(Object object, boolean bl) {
        return GeneralUtils.objectToNumber(object, bl);
    }

    public static Number string2Number(String string) {
        return StableUtils.string2Number(string);
    }

    public static String objectToString(Object object) {
        return GeneralUtils.objectToString(object);
    }

    public static Color getXORColor(Color color) {
        if (color == null) {
            return null;
        }
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static int filterRGB(int n2, int n3) {
        int n4 = (int)((0.3 * (double)(n2 >> 16 & 0xFF) + 0.59 * (double)(n2 >> 8 & 0xFF) + 0.11 * (double)(n2 & 0xFF)) / 3.0);
        if ((n4 = 255 - (255 - n4) * (100 - n3) / 100) < 0) {
            n4 = 0;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        return n2 & 0xFF000000 | n4 << 16 | n4 << 8 | n4;
    }

    public static void swapElementsInList(List list, int n2, int n3) {
        Object e2 = list.get(n2);
        list.set(n2, list.get(n3));
        list.set(n3, e2);
    }

    public static String replaceAllString(String string, String[] stringArray, String[] stringArray2) {
        return StableUtils.replaceAllString(string, stringArray, stringArray2);
    }

    public static String replaceAllString(String string, String string2, String string3) {
        return StableUtils.replaceAllString(string, string2, string3);
    }

    public static void copyBinaryTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copyBinaryTo(inputStream, outputStream);
    }

    public static void copyCharTo(Reader reader, Writer writer) throws IOException {
        IOUtils.copyCharTo(reader, writer);
    }

    public static Field[] getInstanceFields(Class clazz) {
        return Utils.getInstanceFields(clazz, Object.class);
    }

    public static Field[] getInstanceFields(Class clazz, Class clazz2) {
        Class clazz3 = clazz;
        ArrayList<Field> arrayList = new ArrayList<Field>();
        do {
            Field[] fieldArray = clazz3.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                Field field = fieldArray[i2];
                if (Modifier.isStatic(field.getModifiers())) continue;
                arrayList.add(field);
            }
        } while (clazz3 != clazz2 && (clazz3 = clazz3.getSuperclass()) != Object.class);
        return arrayList.toArray(new Field[0]);
    }

    public static Field getDeclaredField(Class clazz, String string) {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            clazz = clazz.getSuperclass();
            if (clazz != null) {
                return Utils.getDeclaredField(clazz, string);
            }
            return null;
        }
    }

    public static String[] getAvailableFontFamilyNames4Report() {
        if (availableFontFamilyNames4Report == null) {
            List<String> list = Arrays.asList("serif", "sansserif", "monospaced", "dialog", "dialoginput");
            ArrayList<String> arrayList = new ArrayList<String>();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (graphicsEnvironment != null) {
                String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (list.indexOf(stringArray[i2].toLowerCase()) >= 0) continue;
                    arrayList.add(stringArray[i2]);
                }
            }
            availableFontFamilyNames4Report = arrayList.toArray(new String[arrayList.size()]);
        }
        return availableFontFamilyNames4Report;
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    public static float round5(float f2) {
        return (float)Math.round(f2 * 2.0f) / 2.0f;
    }

    public static void dealFormulaValue(Object object, Calculator calculator) {
        Object object2 = null;
        if (object instanceof Formula) {
            Formula formula = (Formula)object;
            String string = formula.getContent();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            if (StringUtils.isEmpty(string) || StringUtils.isBlank(string)) {
                return;
            }
            if (calculator == null) {
                calculator = Calculator.createCalculator();
            }
            try {
                object2 = calculator.evalValue(string);
            }
            catch (UtilEvalError utilEvalError) {
                String string2 = "Formula Error";
                FRContext.getLogger().error(string2, utilEvalError);
                object2 = string;
            }
            formula.setResult(object2);
        }
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return string;
        }
        if (string.indexOf(string2) == -1) {
            return string;
        }
        int n2 = string2.length();
        for (int i2 = 0; i2 <= string.length() - n2; ++i2) {
            String string4 = string.substring(i2, i2 + n2);
            if (!ComparatorUtils.equals(string4, string2)) continue;
            string = string.substring(0, i2) + string3 + string.substring(i2 + n2);
        }
        return string;
    }

    public static Object resolveOtherValue(Object object, boolean bl) {
        return Utils.resolveOtherValue(object, bl, PresentationType.PREVIEW);
    }

    public static Object resolveOtherValue(Object object, boolean bl, PresentationType presentationType) {
        return DataUtils.resolveOtherValue(object, bl, false, null, true, presentationType);
    }

    public static boolean isEmbeddedParameter(String string) {
        boolean bl = false;
        String[] stringArray = new String[]{"formlet", "chartlet", "reportlet", "reportlets"};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (string.indexOf(stringArray[i2]) == -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static Object min(Object object, Object object2) {
        try {
            return Utils.compare(object, object2) ? object : object2;
        }
        catch (Exception exception) {
            return object;
        }
    }

    public static Object max(Object object, Object object2) {
        try {
            return Utils.compare(object, object2) ? object2 : object;
        }
        catch (Exception exception) {
            return object;
        }
    }

    private static boolean compare(Object object, Object object2) throws Exception {
        if (object instanceof Number) {
            return ((Number)object).doubleValue() < ((Number)object2).doubleValue();
        }
        if (object instanceof Date) {
            return ((Date)object).compareTo((Date)object2) < 0;
        }
        return object.toString().compareTo(object2.toString()) < 0;
    }

    public static boolean isNumeric(String string) {
        int n2 = string.length();
        while (--n2 >= 0) {
            if (Character.isDigit(string.charAt(n2))) continue;
            return false;
        }
        return true;
    }
}

