/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.DynamicUnitList;
import com.fr.general.ComparatorUtils;
import com.fr.stable.unit.FU;

public class DynamicPixList {
    private long[] elements;
    private long defaultValue;
    private int size;

    public DynamicPixList(DynamicUnitList dynamicUnitList) {
        this.elements = new long[dynamicUnitList.size() + 1];
        this.size = dynamicUnitList.size();
        long l2 = 0L;
        for (int i2 = 0; i2 < this.size; ++i2) {
            l2 += dynamicUnitList.elementInts[i2];
            if (this.elements.length <= i2 + 1) continue;
            this.elements[i2 + 1] = l2;
        }
        this.defaultValue = dynamicUnitList.getDefaultUnit().toFU();
    }

    public int get(int n2, int n3) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= this.size) {
            return FU.toPixI(this.elements[this.size] + (long)(n2 - this.size + 1) * this.defaultValue, n3) - FU.toPixI(this.elements[this.size] + (long)(n2 - this.size) * this.defaultValue, n3);
        }
        return FU.toPixI(this.elements[n2 + 1], n3) - FU.toPixI(this.elements[n2], n3);
    }

    public long getElement(int n2) {
        if (n2 < 0 || n2 > this.size) {
            return 0L;
        }
        return this.elements[n2];
    }

    public int getElementSize() {
        return this.elements != null ? this.elements.length : 0;
    }

    public int getRangeValueFromZero(int n2, int n3) {
        return this.getRangeValue(0, n2, n3);
    }

    public int getRangeValue(int n2, int n3, int n4) {
        int n5 = 0;
        n2 = Math.max(0, n2);
        n3 = Math.max(0, n3);
        int n6 = Math.min(n2, n3);
        int n7 = Math.max(n2, n3);
        if (n6 >= this.size) {
            n5 = FU.toPixI(this.elements[this.size] + (long)(n7 - this.size) * this.defaultValue, n4) - FU.toPixI(this.elements[this.size] + (long)(n6 - this.size) * this.defaultValue, n4);
        } else {
            long l2 = this.elements[n6];
            long l3 = n7 > this.size ? this.elements[this.size] + (long)(n7 - this.size) * this.defaultValue : this.elements[n7];
            n5 = FU.toPixI(l3, n4) - FU.toPixI(l2, n4);
        }
        return n2 <= n3 ? n5 : -n5;
    }

    public boolean equals(Object object) {
        return object instanceof DynamicPixList && ComparatorUtils.equals(this.elements, ((DynamicPixList)object).elements) && this.defaultValue == ((DynamicPixList)object).defaultValue && this.size == ((DynamicPixList)object).size;
    }
}

