/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.FRContext;
import com.fr.general.GeneralUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    private static final int CLASS_SUFFIX_LEN = 6;

    public static Set<Class<?>> getInterfaces(Class<?> clazz) {
        HashSet hashSet = new HashSet();
        while (!Object.class.equals(clazz)) {
            hashSet.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return hashSet;
    }

    public static Set<Class<?>> getClasses(String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        boolean bl = true;
        String string2 = string;
        String string3 = string2.replace('.', '/');
        try {
            Enumeration<URL> enumeration = ClassUtils.class.getClassLoader().getResources(string3);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                String string4 = uRL.getProtocol();
                if ("file".equals(string4)) {
                    ClassUtils.scanFiles(linkedHashSet, bl, string2, uRL);
                    continue;
                }
                if (!"jar".equals(string4)) continue;
                string2 = ClassUtils.scanJars(linkedHashSet, bl, string2, string3, uRL);
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage(), iOException);
        }
        return linkedHashSet;
    }

    private static String scanJars(Set<Class<?>> set, boolean bl, String string, String string2, URL uRL) {
        try {
            JarFile jarFile = ((JarURLConnection)uRL.openConnection()).getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string3 = jarEntry.getName();
                if (string3.charAt(0) == '/') {
                    string3 = string3.substring(1);
                }
                if (!string3.startsWith(string2)) continue;
                int n2 = string3.lastIndexOf(47);
                if (n2 != -1) {
                    string = string3.substring(0, n2).replace('/', '.');
                }
                if (n2 == -1 && !bl || !string3.endsWith(".class") || jarEntry.isDirectory()) continue;
                String string4 = string3.substring(string.length() + 1, string3.length() - 6);
                try {
                    Thread.currentThread().getClass().getClassLoader();
                    set.add(GeneralUtils.classForName(string + '.' + string4));
                }
                catch (Throwable throwable) {
                    FRContext.getLogger().error(throwable.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage(), iOException);
        }
        return string;
    }

    private static void scanFiles(Set<Class<?>> set, boolean bl, String string, URL uRL) throws UnsupportedEncodingException {
        String string2 = URLDecoder.decode(uRL.getFile(), "UTF-8");
        ClassUtils.findAndAddClassesInPackageByFile(string, string2, bl, set);
    }

    public static void findAndAddClassesInPackageByFile(String string, String string2, final boolean bl, Set<Class<?>> set) {
        File[] fileArray;
        File file = new File(string2);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return bl && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file2.isDirectory()) {
                ClassUtils.findAndAddClassesInPackageByFile(string + "." + file2.getName(), file2.getAbsolutePath(), bl, set);
                continue;
            }
            String string3 = file2.getName().substring(0, file2.getName().length() - 6);
            try {
                set.add(GeneralUtils.classForName(string + '.' + string3));
            }
            catch (Throwable throwable) {
                FRContext.getLogger().error(throwable.getMessage());
            }
        }
    }
}

