/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.ConfigManager;
import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.base.FRCoreContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Style;
import com.fr.base.SynchronizedLiveDataModelUtils;
import com.fr.base.TableData;
import com.fr.base.Utils;
import com.fr.data.core.DataCoreUtils;
import com.fr.form.data.DataBinding;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRFont;
import com.fr.general.GeneralUtils;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.js.JavaScript;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.JSONUtils;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.fun.VerticalTextProcessor;
import com.fr.report.fun.impl.DefaultVerticalTextProcessor;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.ListSet;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.FontProcessor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.unit.PT;
import com.fr.stable.web.Repository;
import com.fr.third.antlr.ANTLRException;
import com.fr.web.core.SessionDealWith;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class BaseUtils {
    private static boolean isAuthorityEditing = false;

    private BaseUtils() {
    }

    public static BufferedImage readImageWithCache(String string) {
        return IOUtils.readImageWithCache(string);
    }

    public static BufferedImage readCacheImage(String string) {
        return IOUtils.readCacheImage(string);
    }

    public static BufferedImage readImage(String string) {
        return IOUtils.readImage(string);
    }

    public static Icon readIcon(String string) {
        return IOUtils.readIcon(string);
    }

    public static BufferedImage readImage(InputStream inputStream) throws IOException {
        return IOUtils.readImage(inputStream);
    }

    public static String convertColumnRowToCellString(ColumnRow columnRow) {
        if (columnRow == null) {
            return "";
        }
        return columnRow.toString();
    }

    public static ColumnRow convertCellStringToColumnRow(String string) {
        return ColumnRow.valueOf(string);
    }

    public static String readBuildNO() {
        return GeneralUtils.readBuildNO();
    }

    public static String readResourceAsString(String string) {
        return IOUtils.readResourceAsString(string);
    }

    public static String readResourceAsString(String string, String string2) {
        return IOUtils.readResourceAsString(string, string2);
    }

    public static InputStream readResource(String string) {
        return IOUtils.readResource(string);
    }

    public static ImageIcon createIcon(Image image, int n2, int n3, int n4, int n5) {
        JFrame jFrame = new JFrame();
        Image image2 = jFrame.createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(n2, n3, n4, n5)));
        return new ImageIcon(image2);
    }

    public static String toLongArrayString(long[] lArray, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (lArray != null) {
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                if (i2 != 0) {
                    stringBuffer.append(c2);
                }
                stringBuffer.append(lArray[i2]);
            }
        }
        return stringBuffer.toString();
    }

    public static long[] toLongArrayFromStr(String string, char c2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (string == null) {
            return new long[0];
        }
        String[] stringArray = StableUtils.splitString(string, String.valueOf(c2));
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2].trim();
            arrayList.add(Long.valueOf(string2));
        }
        long[] lArray = new long[arrayList.size()];
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            lArray[i3] = (Long)arrayList.get(i3);
        }
        return lArray;
    }

    public static Font getStyleFont(Graphics2D graphics2D, Style style, int n2) {
        Color color;
        FRFont fRFont = style.getFRFont();
        Font font = BaseUtils.initFontWithLocaleAndG2d(graphics2D, fRFont, n2);
        if (!ComparatorUtils.equals(font, graphics2D.getFont())) {
            graphics2D.setFont(font);
        }
        if (!ComparatorUtils.equals(color = fRFont.getForeground(), graphics2D.getPaint())) {
            graphics2D.setPaint(color);
        }
        return font;
    }

    private static Font initFontWithLocaleAndG2d(Graphics2D graphics2D, FRFont fRFont, int n2) {
        Font font;
        Locale locale = FRContext.getLocale();
        if (ComparatorUtils.equals(Locale.ENGLISH, locale)) {
            font = FRFont.getInstance("Dialog", fRFont.getStyle(), fRFont.getSize());
        }
        font = fRFont.applyResolutionNP(n2);
        if (graphics2D.toString().indexOf("PdfGraphics2D") != -1 && ComparatorUtils.equals("SimSun", fRFont.getName())) {
            font = FRFont.getInstance(Inter.getLocText("FR-Base-Song_TypeFace"), font.getStyle(), font.getSize(), fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
        }
        return font;
    }

    public static int getAlignment4Horizontal(Style style) {
        return BaseUtils.getAlignment4Horizontal(style, null);
    }

    public static Object[] getDistinctValues(DataModel dataModel, int n2) throws TableDataException {
        ListSet<Object> listSet = new ListSet<Object>();
        if (n2 != -1) {
            int n3 = dataModel.getRowCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                listSet.add(dataModel.getValueAt(i2, n2));
            }
        }
        return listSet.toArray();
    }

    public static int getAlignment4Horizontal(Style style, Object object) {
        int n2 = style.getHorizontalAlignment();
        if (object != null && n2 == -1) {
            if (object instanceof String) {
                n2 = style.getFormat() instanceof NumberFormat || Utils.string2Number((String)object) != null ? 4 : 2;
            } else if (object instanceof Number) {
                n2 = 4;
            }
        }
        return n2;
    }

    public static void drawStringStyleInRotation(Graphics2D graphics2D, int n2, int n3, String string, Style style, int n4) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        Font font = graphics2D.getFont();
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        Font font2 = BaseUtils.getStyleFont(graphics2D, style, n4);
        font2 = BaseUtils.readExtraFont(graphics2D, font2);
        int n5 = BaseUtils.getAlignment4Horizontal(style, string);
        if (style.getRotation() != 0 && style.getVerticalText() == 0) {
            BaseUtils.drawHorizontalText(graphics2D, string, font2, style, n2, n3, n5);
        } else {
            BaseUtils.drawRotationText(graphics2D, string, style, font2, n2, n3, n5, n4);
        }
        graphics2D.setFont(font);
        graphics2D.setPaint(paint);
    }

    private static Font readExtraFont(Graphics2D graphics2D, Font font) {
        FontProcessor fontProcessor = (FontProcessor)ExtraClassManager.getInstance().getSingle("FontProcessor");
        if (fontProcessor != null) {
            font = fontProcessor.readExtraFont(font);
            graphics2D.setFont(font);
        }
        return font;
    }

    private static void drawHorizontalText(Graphics2D graphics2D, String string, Font font, Style style, double d2, double d3, int n2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(-Math.toRadians(style.getRotation()));
        double d4 = d2 / 2.0;
        double d5 = d3 / 2.0;
        Dimension2D dimension2D = GraphHelper.stringDimensionWithRotation(string, font, -style.getRotation(), graphics2D.getFontRenderContext());
        if (dimension2D.getWidth() < d2) {
            if (n2 == 2) {
                d4 = dimension2D.getWidth() / 2.0;
            } else if (n2 == 4) {
                d4 = d2 - dimension2D.getWidth() / 2.0 - (double)style.getPaddingLeft() * Math.cos(Math.toRadians(style.getRotation()));
            }
        }
        if (dimension2D.getHeight() < d3) {
            if (style.getVerticalAlignment() == 1) {
                d5 = dimension2D.getHeight() / 2.0;
            } else if (style.getVerticalAlignment() == 3) {
                d5 = d3 - dimension2D.getHeight() / 2.0 - (double)style.getPaddingLeft() * Math.sin(Math.toRadians(style.getRotation()));
            }
        }
        GraphHelper.drawRotatedString(graphics2D, string, d4, d5, -style.getRotation());
    }

    private static void drawRotationText(Graphics2D graphics2D, String string, Style style, Font font, int n2, int n3, int n4, int n5) {
        int n6;
        String string2;
        int n7;
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(font);
        List list = BaseUtils.getLineTextList(string, style, font, n3, n2, n5);
        if (n2 <= 0 || list.isEmpty()) {
            return;
        }
        int n8 = fontMetrics.getAscent();
        int n9 = fontMetrics.getHeight();
        int n10 = BaseUtils.calculateTextY(style, n3, n9, n8, list, n5);
        int n11 = 0;
        for (n7 = 0; n7 < list.size(); ++n7) {
            string2 = (String)list.get(n7);
            n6 = fontMetrics.stringWidth(string2);
            if (n6 <= n11) continue;
            n11 = n6;
        }
        for (n7 = 0; n7 < list.size(); ++n7) {
            string2 = (String)list.get(n7);
            if (style.getRotation() == 0) {
                if (style.getVerticalText() == 0) {
                    n11 = fontMetrics.stringWidth(string2);
                }
            }
            n6 = 0;
            if (n11 > n2 - style.getPaddingLeft() - style.getPaddingRight()) {
                n6 = 1;
            }
            int n12 = BaseUtils.calculateTextX(style, font, string2, n2, n11, n4);
            if (BaseUtils.isAutomaticLine(style, n4, n6 != 0)) {
                GraphHelper.drawString2(graphics2D, string2, n12, n10, n2);
            } else if (BaseUtils.isDistributeAlign(style, n4, n6 != 0)) {
                BaseUtils.drawTextWihenDistributeAlign(graphics2D, string2, fontMetrics, n2, n12, n10);
            } else {
                GraphHelper.drawString(graphics2D, string2, n12, n10);
            }
            n10 += n9;
            n10 = (int)((double)n10 + PT.pt2pix(style.getLineSpacing(), n5));
        }
    }

    public static int calculateTextY(Style style, int n2, int n3, int n4, List list, int n5) {
        int n6 = 0;
        int n7 = n3 * list.size();
        double d2 = PT.pt2pix(style.getSpacingBefore(), n5);
        double d3 = PT.pt2pix(style.getSpacingAfter(), n5);
        double d4 = PT.pt2pix(style.getLineSpacing(), n5);
        n7 = (int)((double)n7 + (d2 + d3 + d4 * (double)list.size()));
        if (style.getVerticalAlignment() != 1) {
            if (style.getVerticalAlignment() == 0) {
                if (n2 > n7) {
                    n6 = (n2 - n7) / 2;
                }
            } else if (style.getVerticalAlignment() == 3 && n2 > n7) {
                n6 = n2 - n7;
            }
        }
        n6 += n4;
        n6 = (int)((double)n6 + (d2 + d4));
        return n6;
    }

    public static int calculateTextX(Style style, Font font, String string, int n2, int n3, int n4) {
        int n5 = style.getPaddingLeft();
        if (n4 == 0) {
            n5 = (n2 - n3) / 2;
        } else if (n4 == 4) {
            n5 = n2 - style.getPaddingRight() - n3;
            if (Boolean.TRUE == FRCoreContext.TMAP.get() && ComparatorUtils.equals(font.getFontName(), "Tahoma")) {
                n5 -= string.length() / 3;
            }
        }
        return n5;
    }

    private static boolean isAutomaticLine(Style style, int n2, boolean bl) {
        return n2 == 6 && style.getTextStyle() == 0 || n2 == 6 && style.getTextStyle() == 1 && !bl;
    }

    private static boolean isDistributeAlign(Style style, int n2, boolean bl) {
        return n2 == 6 && style.getTextStyle() == 1 && bl;
    }

    private static void drawTextWihenDistributeAlign(Graphics2D graphics2D, String string, FontMetrics fontMetrics, int n2, int n3, int n4) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            stringBuffer.append(string2.charAt(i2));
            int n5 = fontMetrics.stringWidth(new String(stringBuffer));
            if (n5 <= n2) continue;
            char[] cArray = new char[128];
            stringBuffer.getChars(0, i2 - 1, cArray, 0);
            cArray[i2] = '\u0000';
            GraphHelper.drawString(graphics2D, new String(cArray), n3, n4);
            break;
        }
    }

    public static String textToString(String string) {
        if (string == null) {
            return "";
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = string.charAt(i2);
            if (n3 == 92 && i2 + 1 < n2) {
                char c2 = string.charAt(i2 + 1);
                if (c2 == 'n') {
                    ++i2;
                    n3 = 10;
                } else if (c2 == '\\') {
                    ++i2;
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public static List getLineTextList(String string, Style style, Font font, double d2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() <= 0) {
            return arrayList;
        }
        Style style2 = style = style == null ? Style.DEFAULT_STYLE : style;
        if (style.getRotation() != 0) {
            arrayList.add(string);
            return arrayList;
        }
        if (font == null) {
            font = style.getFRFont();
        }
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(font);
        if (style.getTextStyle() != 0) {
            return BaseUtils.lineTextListNotChangeLine(arrayList, string);
        }
        BaseUtils.lineTextListAutoChangeLine(arrayList, string, fontMetrics, style, d2);
        return arrayList;
    }

    private static List lineTextListNotChangeLine(List list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                if (i2 + 1 < string.length() && string.charAt(i2 + 1) == 'n') {
                    ++i2;
                    list.add(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        if (stringBuffer.length() > 0) {
            list.add(stringBuffer.toString());
            stringBuffer.delete(0, stringBuffer.length());
        }
        return list;
    }

    private static void lineTextListAutoChangeLine(List list, String string, FontMetrics fontMetrics, Style style, double d2) {
        double d3 = d2 - (double)style.getPaddingLeft() - (double)(style.getPaddingRight() == 2 ? 0 : style.getPaddingRight()) - (double)style.getBorderLeftWidth();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = 0;
        int[] nArray = new int[]{n3, n2};
        BaseUtils.lineTextListDealWithText(string, list, d3, nArray, stringBuffer2, stringBuffer, fontMetrics);
        if ((double)(nArray[1] + nArray[0]) > d3 && stringBuffer.length() > 0) {
            list.add(stringBuffer.toString());
            list.add(stringBuffer2.toString());
        } else {
            stringBuffer.append(stringBuffer2);
            list.add(stringBuffer.toString());
        }
    }

    private static void lineTextListDealWithText(String string, List list, double d2, int[] nArray, StringBuffer stringBuffer, StringBuffer stringBuffer2, FontMetrics fontMetrics) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (i2 != 0 && BaseUtils.isNumOrLetter(string.charAt(i2)) && BaseUtils.isNumOrLetter(string.charAt(i2 - 1))) {
                BaseUtils.dealWithTextNumOrLetter(string, i2, list, d2, nArray, stringBuffer, stringBuffer2, fontMetrics);
                continue;
            }
            if (string.charAt(i2) == '\n' || string.charAt(i2) == '\r' && i2 + 1 < string.length() - 1 && string.charAt(i2 + 1) != '\n') {
                BaseUtils.dealWithTextChangeLineSymbol(string, i2, list, d2, nArray, stringBuffer, stringBuffer2, fontMetrics);
                continue;
            }
            if (string.charAt(i2) == '\\' && i2 + 1 < string.length() && string.charAt(i2 + 1) == 'n') {
                BaseUtils.dealWidthTextManualChangeLine(string, i2, list, d2, nArray, stringBuffer, stringBuffer2, fontMetrics);
                ++i2;
                continue;
            }
            if (string.charAt(i2) == '\\' && i2 + 1 < string.length() && string.charAt(i2 + 1) == '\\') {
                ++i2;
            }
            if ((double)(nArray[1] + nArray[0]) > d2 && stringBuffer2.length() > 0) {
                if (BaseUtils.isPunctuationAtLineHead(i2, string)) {
                    for (int i3 = stringBuffer2.length(); i3 > 0; --i3) {
                        char c2 = stringBuffer2.charAt(i3 - 1);
                        stringBuffer2.deleteCharAt(i3 - 1);
                        if (!BaseUtils.isPunctuation(c2)) break;
                    }
                }
                list.add(stringBuffer2.toString());
                stringBuffer2.delete(0, stringBuffer2.length());
                nArray[1] = BaseUtils.isPunctuationAtLineHead(i2, string) ? BaseUtils.dealWithPunctuationAtLinehead(i2, fontMetrics, string, stringBuffer2) : 0;
            }
            stringBuffer2.append(stringBuffer);
            nArray[1] = nArray[1] + nArray[0];
            stringBuffer.delete(0, stringBuffer.length());
            nArray[0] = 0;
            stringBuffer.append(string.charAt(i2));
            nArray[0] = fontMetrics.charWidth(string.charAt(i2));
        }
    }

    private static boolean isPunctuationAtLineHead(int n2, String string) {
        return n2 > 1 && BaseUtils.isPunctuation(string.charAt(n2 - 1));
    }

    private static int dealWithPunctuationAtLinehead(int n2, FontMetrics fontMetrics, String string, StringBuffer stringBuffer) {
        if (n2 < 2) {
            return 0;
        }
        int n3 = 0;
        for (int i2 = n2 - 2; i2 >= 0; --i2) {
            n3 += fontMetrics.charWidth(string.charAt(i2));
            stringBuffer.insert(0, string.charAt(i2));
            if (!BaseUtils.isPunctuation(string.charAt(i2))) break;
        }
        return n3;
    }

    private static void dealWithTextNumOrLetter(String string, int n2, List list, double d2, int[] nArray, StringBuffer stringBuffer, StringBuffer stringBuffer2, FontMetrics fontMetrics) {
        if ((double)(nArray[0] + fontMetrics.charWidth(string.charAt(n2))) > d2) {
            if (nArray[1] > 0) {
                list.add(stringBuffer2.toString());
                stringBuffer2.delete(0, stringBuffer2.length());
                nArray[1] = 0;
            }
            list.add(stringBuffer.toString());
            stringBuffer.delete(0, stringBuffer.length());
            nArray[0] = 0;
        }
        stringBuffer.append(string.charAt(n2));
        nArray[0] = nArray[0] + fontMetrics.charWidth(string.charAt(n2));
    }

    private static void dealWithTextChangeLineSymbol(String string, int n2, List list, double d2, int[] nArray, StringBuffer stringBuffer, StringBuffer stringBuffer2, FontMetrics fontMetrics) {
        stringBuffer.append('\n');
        if ((double)(nArray[1] + nArray[0]) > d2 && stringBuffer2.length() > 0) {
            list.add(stringBuffer2.toString());
            list.add(stringBuffer.toString());
        } else {
            stringBuffer2.append(stringBuffer);
            list.add(stringBuffer2.toString());
        }
        stringBuffer2.delete(0, stringBuffer2.length());
        nArray[1] = 0;
        stringBuffer.delete(0, stringBuffer.length());
        nArray[0] = 0;
    }

    private static void dealWidthTextManualChangeLine(String string, int n2, List list, double d2, int[] nArray, StringBuffer stringBuffer, StringBuffer stringBuffer2, FontMetrics fontMetrics) {
        ++n2;
        stringBuffer.append('\n');
        if ((double)(nArray[1] + nArray[0]) > d2 && stringBuffer2.length() > 0) {
            list.add(stringBuffer2.toString());
            list.add(stringBuffer.toString());
        } else {
            stringBuffer2.append(stringBuffer);
            list.add(stringBuffer2.toString());
        }
        stringBuffer2.delete(0, stringBuffer2.length());
        nArray[1] = 0;
        stringBuffer.delete(0, stringBuffer.length());
        nArray[0] = 0;
    }

    public static boolean isNum(char c2) {
        return StableUtils.isNum(c2);
    }

    public static boolean isNumOrLetter(char c2) {
        return GeneralUtils.isLetter(c2) || StableUtils.isNum(c2);
    }

    public static boolean isPunctuation(char c2) {
        int n2 = Character.getType(c2);
        return n2 == 24 || n2 == 20 || n2 == 21 || n2 == 22 || n2 == 23;
    }

    public static List getLineTextList(String string, Style style, Font font, double d2, double d3) {
        return BaseUtils.getLineTextList(string, style, font, d2, d3, 72);
    }

    public static List getLineTextList(String string, Style style, Font font, double d2, double d3, int n2) {
        if (style == null || style.getVerticalText() != 1) {
            return BaseUtils.getLineTextList(string, style, font, d3);
        }
        VerticalTextProcessor verticalTextProcessor = (VerticalTextProcessor)((Object)ExtraClassManager.getInstance().getSingle("VerticalText", DefaultVerticalTextProcessor.class));
        String[] stringArray = verticalTextProcessor.process(string, style, font, d2, d3, n2);
        return Arrays.asList(stringArray);
    }

    public static int getBorderWidth(int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 14: {
                return 1;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    public static String border2Style(int n2) {
        switch (n2) {
            case 0: {
                return "none";
            }
            case 1: {
                return "solid";
            }
            case 2: {
                return "solid";
            }
            case 5: {
                return "solid";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "double";
            }
            case 9: {
                return "double";
            }
            case 11: {
                return "dotted";
            }
        }
        return "dashed";
    }

    public static Object cloneObject(Object object) throws CloneNotSupportedException {
        return StableUtils.cloneObject(object);
    }

    public static JSONObject map2JSON(Map map) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry entry : map.keySet()) {
            Object object = entry.getValue();
            if (object instanceof FArray) {
                JSONArray jSONArray = new JSONArray();
                FArray fArray = (FArray)object;
                for (int i2 = 0; i2 < fArray.length(); ++i2) {
                    jSONArray.put(fArray.elementAt(i2));
                }
                object = jSONArray;
            }
            jSONObject.put((String)entry.getKey(), object);
        }
        return jSONObject;
    }

    public static String jsonEncode(Object object) throws JSONException {
        return JSONObject.valueToString(object);
    }

    public static Object jsonDecode(String string) throws JSONException {
        return JSONUtils.jsonDecode(string);
    }

    public static FArray JSONArrayToFArray(JSONArray jSONArray) {
        return new FArray<Object>(JSONUtils.JSONArrayToList(jSONArray));
    }

    public static boolean imageEquals(Image image, Image image2) {
        byte[] byArray;
        if (image == image2) {
            return true;
        }
        if (image == null || image2 == null) {
            return image == null && image2 == null;
        }
        byte[] byArray2 = GeneralXMLTools.imageEncode(image);
        if (byArray2.length != (byArray = GeneralXMLTools.imageEncode(image2)).length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray2[i2] == byArray[i2]) continue;
            return false;
        }
        return true;
    }

    public static DataModel getDataModelFromTableDataName(Calculator calculator, String string) {
        String string2 = string;
        DataModel dataModel = SynchronizedLiveDataModelUtils.getSELiveDataModel4Share(calculator, string2);
        if (dataModel == null) {
            TableData tableData = DataCoreUtils.getTableData(calculator, string2);
            dataModel = tableData == null ? null : tableData.createDataModel(calculator);
        }
        return dataModel;
    }

    public static String writeJSLinkContent(NameJavaScriptGroup nameJavaScriptGroup, Repository repository) throws JSONException {
        JSONArray jSONArray = BaseUtils.createJSLink(nameJavaScriptGroup, repository);
        return jSONArray.toString();
    }

    public static JSONArray createJSLink(NameJavaScriptGroup nameJavaScriptGroup, Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < nameJavaScriptGroup.size(); ++i2) {
            JSONObject jSONObject = new JSONObject();
            if (nameJavaScriptGroup.getNameHyperlink(i2) == null || nameJavaScriptGroup.getNameHyperlink(i2).getJavaScript() == null) continue;
            String string = nameJavaScriptGroup.getNameHyperlink(i2).getName();
            JavaScript javaScript = nameJavaScriptGroup.getNameHyperlink(i2).getJavaScript();
            javaScript.setLinkTitle(string);
            String string2 = nameJavaScriptGroup.getNameHyperlink(i2).getJavaScript().createJS(repository);
            jSONObject.put("data", string2 == null ? "" : string2.replaceAll("\n", ""));
            jSONObject.put("name", string);
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    public static Object[][] list2Array2D(List list) {
        int n2 = list.size();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            List list2 = (List)list.get(i2);
            if (list2.size() <= n3) continue;
            n3 = list2.size();
        }
        Object[][] objectArray = new Object[n2][n3];
        for (int i3 = 0; i3 < n2; ++i3) {
            List list3 = (List)list.get(i3);
            for (int i4 = 0; i4 < n3; ++i4) {
                objectArray[i3][i4] = i4 < list3.size() ? list3.get(i4) : null;
            }
        }
        return objectArray;
    }

    public static String[] getDependence(Object object, CalculatorProvider calculatorProvider) {
        TableData tableData;
        if (object instanceof Formula) {
            try {
                return Calculator.relatedParameters(((Formula)object).getContent());
            }
            catch (ANTLRException aNTLRException) {
                FRContext.getLogger().error(aNTLRException.getMessage(), aNTLRException);
                return new String[0];
            }
        }
        if (object instanceof DataBinding && ((DataBinding)object).getDataBindingKey() != null && (tableData = DataCoreUtils.getTableData((Calculator)calculatorProvider, ((DataBinding)object).getDataSourceName())) != null) {
            ParameterProvider[] parameterProviderArray = tableData.getParameters((Calculator)calculatorProvider);
            String[] stringArray = new String[parameterProviderArray.length];
            for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
                stringArray[i2] = parameterProviderArray[i2].getName().charAt(0) == '$' ? parameterProviderArray[i2].getName() : "$" + parameterProviderArray[i2].getName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public static void setAuthorityEditing(boolean bl) {
        isAuthorityEditing = bl;
    }

    public static boolean isAuthorityEditing() {
        return isAuthorityEditing;
    }

    public static List getVisitInforFromSession(Locale locale) throws JSONException {
        return SessionDealWith.getVisitInforFromSession((Locale)locale);
    }

    public static boolean checkLicExist() {
        if (ConfigManager.getProviderInstance().isLicUseLock()) {
            return true;
        }
        try {
            Env env = FRContext.getCurrentEnv();
            String string = env.getLicName();
            InputStream inputStream = env.readBean(string, "resources");
            return inputStream != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isChartCell(JSONObject jSONObject) {
        JSONObject jSONObject2;
        if (jSONObject != null && (jSONObject2 = jSONObject.optJSONObject("value")) != null) {
            return ComparatorUtils.equals("simplechart", jSONObject2.optString("type"));
        }
        return false;
    }
}

