/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.web.core;

import com.fr.base.ChartPreStyleServerManager;
import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.chart.web.core.ChartSessionIDInfor;
import com.fr.data.TableDataSource;
import com.fr.form.ui.ChartBook;
import com.fr.general.DeclareRecordType;
import com.fr.general.ExecuteInfo;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.general.LogDuration;
import com.fr.script.Calculator;
import com.fr.stable.web.Repository;
import com.fr.stable.web.Weblet;
import com.fr.web.RepositoryDeal;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartletDealWith {
    private static final long TEN = 10L;

    private ChartletDealWith() {
    }

    public static void dealWithChartlet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Weblet weblet) throws Exception {
        String string = SessionDealWith.generateSessionID((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Weblet)weblet);
        if (string == null || !SessionDealWith.hasSessionID((String)string)) {
            return;
        }
        ChartletDealWith.dealWithChartHtml(httpServletRequest, httpServletResponse, string);
    }

    private static void dealWithChartHtml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        ChartSessionIDInfor chartSessionIDInfor = (ChartSessionIDInfor)SessionDealWith.getSessionIDInfor((String)string);
        if (chartSessionIDInfor == null) {
            return;
        }
        RepositoryDeal repositoryDeal = new RepositoryDeal(httpServletRequest, (SessionIDInfor)chartSessionIDInfor, 96);
        long l = System.currentTimeMillis();
        ChartletDealWith.noCache(httpServletResponse);
        Map<String, Object> map = ChartletDealWith.initMap4Chart(chartSessionIDInfor, (Repository)repositoryDeal, string);
        WebUtils.writeOutTemplate((String)"/com/fr/chart/web/core/chart.html", (HttpServletResponse)httpServletResponse, map);
        long l2 = System.currentTimeMillis();
        if (ConfigManager.getProviderInstance().getLogConfig().isRecordExe4Chart()) {
            ChartletDealWith.chartExecuteLogRecord(chartSessionIDInfor, l, l2, map, FRLogManager.getDeclareSQLContent());
        }
    }

    private static Map<String, Object> initMap4Chart(ChartSessionIDInfor chartSessionIDInfor, Repository repository, String string) {
        ChartBook chartBook = chartSessionIDInfor.getChartBook2Show();
        Calculator calculator = ChartletDealWith.mixCalculate2Chart(chartBook);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            hashMap.put("charset", ConfigManager.getProviderInstance().getServerCharset());
            hashMap.put("chartlet_title", chartSessionIDInfor.getWebTitle());
            hashMap.put("config", chartBook.createContentJSONConfig(repository, calculator));
            hashMap.put("Baidu", ChartPreStyleServerManager.getProviderInstance().getBaiduSource());
            hashMap.put("Google", ChartPreStyleServerManager.getProviderInstance().getGoogleSource());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return hashMap;
    }

    public static Calculator mixCalculate2Chart(ChartBook chartBook) {
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(TableDataSource.KEY, (Object)chartBook);
        return calculator;
    }

    private static void noCache(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", -10L);
    }

    private static void chartExecuteLogRecord(ChartSessionIDInfor chartSessionIDInfor, long l, long l2, Map map, String string) {
        FRLogManager.setSession((LogDuration)chartSessionIDInfor);
        try {
            String string2 = FRLogger.createParamString((Map)map);
            long l3 = l2 - l;
            ExecuteInfo executeInfo = new ExecuteInfo(string2, l3, string);
            FRContext.getLogger().getRecordManager().recordExecuteInfo(chartSessionIDInfor.getChartPath(), DeclareRecordType.EXECUTE_TYPE_FORM, executeInfo);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }
}

