/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Utils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.chartglyph.Meter;
import com.fr.chart.chartglyph.MeterInterval;
import com.fr.chart.chartglyph.MeterStyle;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.FRFont;
import com.fr.stable.CoreConstants;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class SimpleMeter
extends Meter {
    private static final double INNER_RADIUS = 0.88;
    private static final double START_ANGLE = 240.0;
    private static final double EXTEND_ANGLE = -300.0;
    private static final double GAP_ANGLE = 5.0;
    private static final double TICK_Y_GAP = 4.0;
    private Arc2D bellowCircleShape;
    private Color bellowCircleColor = new Color(214, 214, 214);
    private Color unitColor = new Color(96, 96, 96);
    private Color tickColor = new Color(51, 51, 51);
    private Color lightColor;

    public SimpleMeter(TextGlyph textGlyph, double d, MeterStyle meterStyle) {
        super(textGlyph, d, meterStyle);
        meterStyle.setMaxArrowAngle(300);
    }

    public void draw(Graphics graphics, int n) {
        this.resetBeforeDraw();
        this.initTransientValue(n);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.bounds.getX(), this.bounds.getY());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.arcWidth = this.radius * 0.12;
        this.maxOuterSize = Math.max(this.maxOuterSize, this.arcWidth);
        graphics2D.setStroke(new BasicStroke((float)this.arcWidth, 1, 1));
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setPaint(this.bellowCircleColor);
        graphics2D.draw(this.bellowCircleShape);
        alphaComposite = AlphaComposite.getInstance(3, 1.0f);
        graphics2D.setComposite(alphaComposite);
        for (int i = 0; i < this.meterStyle.getIntervalCount(); ++i) {
            MeterInterval meterInterval = this.meterStyle.getInterval(i);
            double d = this.deal4Begin(i, meterInterval);
            double d2 = this.deal4End(i, meterInterval);
            if (!(d <= this.value) || !(d2 >= this.value)) continue;
            this.lightColor = meterInterval.getBackgroundColor();
            break;
        }
        if (this.value < this.meterStyle.getStartValueResult()) {
            this.lightColor = this.meterStyle.getInterval(0).getBackgroundColor();
        }
        if (this.value > this.meterStyle.getEndValueFormula()) {
            this.lightColor = this.meterStyle.getInterval(this.meterStyle.getIntervalCount() - 1).getBackgroundColor();
        }
        graphics2D.setPaint(this.lightColor);
        graphics2D.draw(this.meterShape);
        this.drawStrings(graphics2D, n);
        this.drawTitle(graphics2D, n);
        graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
    }

    private void drawStrings(Graphics2D graphics2D, int n) {
        String string = "No value";
        string = Utils.doubleToString((double)this.dealWithDoubleValue(this.getValue() / this.getOrder()));
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.meterStyle.getValueTextAttr(), n);
        double d = this.meterMiddleX - dimension2D.getWidth() / 2.0;
        double d2 = this.meterMiddleY;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
        this.meterStyle.getValueTextAttr().setFRFontColor(this.lightColor);
        GlyphUtils.drawStrings(graphics2D, string, this.meterStyle.getValueTextAttr(), double_, n);
        String string2 = this.meterStyle.getUnits();
        Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithNoRotation(string2, this.meterStyle.getUnitTextAttr(), n);
        double d3 = this.meterMiddleX - dimension2D2.getWidth() / 2.0;
        double d4 = d2 - this.radius * 0.1 - dimension2D2.getHeight();
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d3, d4, dimension2D2.getWidth(), dimension2D2.getHeight());
        this.meterStyle.getUnitTextAttr().setFRFontColor(this.unitColor);
        GlyphUtils.drawStrings(graphics2D, string2, this.meterStyle.getUnitTextAttr(), double_2, n);
        double d5 = this.meterMiddleX + this.radius * Math.cos(4.276056667386107);
        double d6 = this.meterMiddleY - this.radius * Math.sin(4.276056667386107);
        double d7 = this.meterMiddleX + this.radius * Math.cos(-1.1344640137963142);
        double d8 = this.meterMiddleY - this.radius * Math.sin(-1.1344640137963142);
        FRFont fRFont = FRFont.getInstance((String)"Century Gothic", (int)0, (float)15.0f);
        graphics2D.setFont((Font)fRFont);
        graphics2D.setPaint(this.tickColor);
        double d9 = this.getOrder();
        String string3 = Utils.doubleToString((double)(this.meterStyle.getStartValueResult() / d9));
        graphics2D.drawString(string3, (int)d5, (int)(d6 + 4.0));
        String string4 = Utils.doubleToString((double)(this.meterStyle.getEndValueFormula() / d9));
        Rectangle2D rectangle2D = fRFont.getStringBounds(string4, CoreConstants.DEFAULT_FRC);
        graphics2D.drawString(string4, (int)(d7 - rectangle2D.getWidth()), (int)(d8 + 4.0));
    }

    protected void calculateMeterShape() {
        double d = this.meterStyle.getEndValueFormula() - this.meterStyle.getStartValueResult();
        double d2 = Math.min(this.value, this.meterStyle.getEndValueFormula());
        d2 = Math.max(d2, this.meterStyle.getStartValueResult());
        double d3 = -300.0 * (d2 - this.meterStyle.getStartValueResult()) / d;
        this.meterShape = new Arc2D.Double(this.meterMiddleX - this.radius, this.meterMiddleY - 0.88 * this.radius, 2.0 * this.radius, 2.0 * this.radius, 240.0, d3, 0);
        this.bellowCircleShape = new Arc2D.Double(this.meterMiddleX - this.radius, this.meterMiddleY - this.radius * 0.88, 2.0 * this.radius, 2.0 * this.radius, 240.0, -300.0, 0);
    }
}

