/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.FRContext;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RangeAxisGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.core.IteratorChain;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RangePlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = -3079867047500181470L;
    private static final double AXISHEIGHT = 50.0;
    private RangeAxisGlyph rangeAxisGlyph = new RangeAxisGlyph();
    private double seriesWidth = 2.0;
    private List rangeAxisGlyphList = new ArrayList();

    public void layoutAxisGlyph(int n) {
        this.rangeAxisGlyphList.clear();
        int n2 = this.getCategoryCount();
        for (int i = 0; i < n2; ++i) {
            double d = this.getBounds().getHeight();
            double d2 = this.getBounds().getWidth();
            double d3 = d / (double)(n2 * 2) > 50.0 ? 50.0 : d / (double)(n2 * 2);
            double d4 = (double)(i + 1) * d / (double)(1 + n2) - d3 / 2.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, d4, d2, d3);
            RangeAxisGlyph rangeAxisGlyph = new RangeAxisGlyph();
            try {
                rangeAxisGlyph = (RangeAxisGlyph)this.rangeAxisGlyph.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
            }
            rangeAxisGlyph.dealPlotBoundsWithAxisLabel(double_, n);
            rangeAxisGlyph.setPlotZeroBounds(this.getBounds());
            rangeAxisGlyph.init(double_, d);
            rangeAxisGlyph.calculateAxisLengthUnit();
            this.rangeAxisGlyphList.add(rangeAxisGlyph);
        }
    }

    public void layoutDataSeriesGlyph(int n) {
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            for (int j = 0; j < this.getSeriesSize(); ++j) {
                DataSeries dataSeries = this.getSeries(j);
                DataPoint dataPoint = dataSeries.getDataPoint(i);
                if (dataPoint.isValueIsNull()) continue;
                RangeAxisGlyph rangeAxisGlyph = (RangeAxisGlyph)this.rangeAxisGlyphList.get(i);
                Point2D point2D = rangeAxisGlyph.getPoint2D(dataPoint.getValue());
                double d = rangeAxisGlyph.getBounds().getHeight();
                double d2 = rangeAxisGlyph.getBounds().getY();
                Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - this.seriesWidth / 2.0, d2 + point2D.getY() - d / 2.0, this.seriesWidth, d);
                ShapeGlyph shapeGlyph = new ShapeGlyph(double_);
                shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
                dataPoint.setDrawImpl(shapeGlyph);
                this.dealDataPointLabel(dataPoint, n);
            }
        }
        this.dealLabelBoundsInOrder();
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n) {
        double d = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
        double d2 = 0.0;
        double d3 = 2.0;
        switch (n) {
            case 1: {
                d2 = rectangle2D.getY() - dimension2D.getHeight() - d3;
                break;
            }
            case 3: {
                d2 = rectangle2D.getY() + rectangle2D.getHeight() + d3;
                break;
            }
            default: {
                d = rectangle2D.getX() + rectangle2D.getWidth() + d3;
                d2 = rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0;
            }
        }
        return new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void setRangeAxisGlyph(RangeAxisGlyph rangeAxisGlyph) {
        this.rangeAxisGlyph = rangeAxisGlyph;
    }

    public RangeAxisGlyph getRangeAxisGlyph() {
        return this.rangeAxisGlyph;
    }

    public void setSeriesWidth(double d) {
        this.seriesWidth = d;
    }

    public Iterator selectableChildren() {
        ArrayList arrayList = new ArrayList();
        if (this.rangeAxisGlyphList != null && !this.rangeAxisGlyphList.isEmpty()) {
            arrayList.addAll(this.rangeAxisGlyphList);
        }
        return new IteratorChain(new Iterator[]{super.selectableChildren(), arrayList.iterator()});
    }

    public void draw(Graphics graphics, int n) {
        super.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisGird(graphics);
        if (this.rangeAxisGlyphList != null && !this.rangeAxisGlyphList.isEmpty()) {
            for (int i = 0; i < this.rangeAxisGlyphList.size(); ++i) {
                ((RangeAxisGlyph)this.rangeAxisGlyphList.get(i)).draw(graphics2D, n);
            }
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D, n);
    }

    private void drawAxisGird(Graphics graphics) {
        if (this.rangeAxisGlyphList != null && !this.rangeAxisGlyphList.isEmpty()) {
            for (int i = 0; i < this.rangeAxisGlyphList.size(); ++i) {
                ((RangeAxisGlyph)this.rangeAxisGlyphList.get(i)).drawAxisGrid(graphics);
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof RangePlotGlyph && super.equals(object) && ((RangePlotGlyph)object).seriesWidth == this.seriesWidth && ComparatorUtils.equals((Object)((RangePlotGlyph)object).rangeAxisGlyph, (Object)this.rangeAxisGlyph);
    }

    public Object clone() throws CloneNotSupportedException {
        RangePlotGlyph rangePlotGlyph = (RangePlotGlyph)super.clone();
        if (this.rangeAxisGlyph != null) {
            rangePlotGlyph.rangeAxisGlyph = (RangeAxisGlyph)this.rangeAxisGlyph.clone();
        }
        return rangePlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.rangeAxisGlyph != null) {
            jSONObject.put("rangeAxisGlyph", (Object)this.rangeAxisGlyph.toJSONObject(repository));
        }
        jSONObject.put("seriesWidth", this.seriesWidth);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "RangePlotGlyph";
    }

    public String getChartType() {
        return "Range";
    }
}

