/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.Marker;
import com.fr.chart.chartglyph.MarkerFactory;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class MarkerGlyph
extends SpecialGlyph {
    private static final long serialVersionUID = 7868484475190979219L;
    private Marker marker;
    private double x;
    private double y;
    private double width;
    private double height;
    private float alpha = 1.0f;

    public MarkerGlyph() {
    }

    public MarkerGlyph(Marker marker, Color color) {
        this.setMarker(marker);
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getMarker() == null) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        this.getMarker().paint(graphics2D, this.x + this.width / 2.0, this.y + this.height / 2.0);
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    public Shape getShape() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public void setShape(Rectangle2D rectangle2D) {
        this.x = rectangle2D.getX();
        this.y = rectangle2D.getY();
        this.width = rectangle2D.getWidth();
        this.height = rectangle2D.getHeight();
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void dealCondition4Line(ConditionCollection conditionCollection, DataPoint dataPoint, Color[] colorArray) {
        AttrMarkerType attrMarkerType = (AttrMarkerType)conditionCollection.getDataSeriesCondition(AttrMarkerType.class, dataPoint, null);
        Marker marker = MarkerFactory.createMarker(attrMarkerType.getMarkerType());
        this.setMarker(marker);
        AttrColor attrColor = (AttrColor)conditionCollection.getDataSeriesCondition(AttrColor.class, dataPoint, colorArray);
        marker.setBackground((Background)ColorBackground.getInstance((Color)attrColor.getSeriesColor()));
        AttrAlpha attrAlpha = (AttrAlpha)conditionCollection.getDataSeriesCondition(AttrAlpha.class, dataPoint, null);
        this.setAlpha(attrAlpha.getAlpha());
    }

    public boolean equals(Object object) {
        return object instanceof MarkerGlyph && ((MarkerGlyph)object).getAlpha() == this.getAlpha() && ((MarkerGlyph)object).width == this.width && ((MarkerGlyph)object).height == this.height && ((MarkerGlyph)object).x == this.x && ((MarkerGlyph)object).y == this.y && ComparatorUtils.equals((Object)((MarkerGlyph)object).getMarker(), (Object)this.getMarker());
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("alpha", (double)this.alpha);
        return jSONObject;
    }

    protected boolean isNeedBorderBG() {
        return true;
    }
}

