/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.BaseXMLUtils;
import com.fr.base.background.ColorBackground;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;

public abstract class Marker
implements XMLable {
    private static final long serialVersionUID = 6913605407851388493L;
    public static final String XML_TAG = "Marker";
    protected double size = 4.5;
    protected static final double GAP_SIZE = 2.0;
    public static final String ROUND_M = "RoundMarker";
    public static final String ROUND_FM = "RoundFilledMarker";
    public static final String SUEARE_FM = "SquareFilledMarker";
    public static final String TRI_FM = "TriangleFilledMarker";
    public static final String DIAMOND_FM = "DiamondFilledMarker";
    public static final String CORSS_M = "CrossMarker";
    public static final String PLUSSIGN_M = "PlusSignMarker";
    public static final String CIRCLE_FM = "CircleFilledMarker";
    public static final String MINUSSIGN_M = "MinusSignMarker";
    public static final String DIAMON_M = "DiamondMarker";
    public static final String SQUARE_M = "SquareMarker";
    public static final String TRIANGLE_M = "TriangleMarker";
    public static final String CIRCLE_M = "CircleMarker";
    public static final String ALLEQUAL_M = "AllEqualMarker";
    public static final String CLOCKLINE_M = "ClockLineMarker";
    public static final String ANTICLOCKLINE_M = "AntiClockLineMarker";
    public static final String STAR_M = "StarMarker";
    public static final String X_M = "XMarker";
    public static final String NULL_M = "NullMarker";
    public static final String POINT_M = "PointMarker";
    public static final String DOWJONES_M = "DowJonesMarker";
    public static final ColorBackground SCATTER_PLOT_BACKROUNG = ColorBackground.getInstance((Color)new Color(0, 0, 0, 0));
    protected Background background;
    protected Background plotBackground;

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public void setPlotBackground(Background background) {
        this.plotBackground = background;
    }

    public Background getBackground() {
        return this.background;
    }

    public void paint(Graphics2D graphics2D, double d, double d2) {
        Paint paint = graphics2D.getPaint();
        if (this.background != null) {
            this.paintMarker(graphics2D, d, d2);
        }
        graphics2D.setPaint(paint);
    }

    protected abstract void paintMarker(Graphics2D var1, double var2, double var4);

    protected void paintPlotBackground(Background background, Graphics2D graphics2D, Shape shape) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        background.paint((Graphics)graphics2D, shape);
        graphics2D.setComposite(composite);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Style".equals(xMLableReader.getTagName())) {
                this.size = xMLableReader.getAttrAsDouble("size", 5.0);
                String string2 = xMLableReader.getAttrAsString("color", null);
                if (string2 != null) {
                    this.background = ColorBackground.getInstance((Color)new Color(Integer.parseInt(string2), true));
                }
            } else if (string.equals("Background")) {
                this.background = BaseXMLUtils.readBackground((XMLableReader)xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Style").attr("size", this.size);
        xMLPrintWriter.end();
        BaseXMLUtils.writeBackground((XMLPrintWriter)xMLPrintWriter, (Background)this.background);
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return this.getClass().isInstance(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("size", this.size);
        if (this.background != null) {
            jSONObject.put("background", (Object)ChartBaseUtils.background2JS(repository, this.background));
        }
        return jSONObject;
    }

    public abstract String getMarkerType();

    public boolean isNullMarker() {
        return false;
    }
}

