/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ColorSelect4Shape;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Point;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;

public class MapShapeValue
implements XMLable {
    public static final int POINT = 0;
    public static final int AREA = 1;
    public static final String XML_TAG = "MapShapeValue";
    private static final double RADIUSSIZE = 5.0;
    private static final long serialVersionUID = -6419781384619370060L;
    private String name;
    private List shape = new ArrayList();
    private int markType = 1;
    private String nameTo;

    public MapShapeValue() {
    }

    public MapShapeValue(String string, Point[] pointArray, int n) {
        this.setName(string);
        for (int i = 0; i < pointArray.length; ++i) {
            this.shape.add(pointArray[i]);
        }
        this.setMarkType(n);
    }

    public void setNameTo(String string) {
        this.nameTo = string;
    }

    public String getNameTo() {
        return this.nameTo;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setShape(Point[] pointArray) {
        this.shape.add(pointArray);
    }

    public Point[] getShape() {
        return this.shape.toArray(new Point[this.shape.size()]);
    }

    public void setMarkType(int n) {
        this.markType = n;
    }

    public int getMarkType() {
        return this.markType;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals((String)"MV", (String)string)) {
                this.name = xMLableReader.getAttrAsString("name", "");
                this.markType = xMLableReader.getAttrAsInt("markType", this.markType);
                this.nameTo = xMLableReader.getAttrAsString("nameTo", "");
                int n = xMLableReader.getAttrAsInt("pointx", 0);
                int n2 = xMLableReader.getAttrAsInt("pointy", 0);
                if (n != 0 && n2 != 0) {
                    this.shape.add(new Point(n, n2));
                }
            } else if (ComparatorUtils.equals((String)"onepoint", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        int n = xMLableReader.getAttrAsInt("px", 0);
                        int n2 = xMLableReader.getAttrAsInt("py", 0);
                        if (n != 0 && n2 != 0) {
                            MapShapeValue.this.shape.add(new Point(n, n2));
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("MV").attr("name", this.name).attr("markType", this.markType).attr("nameTo", this.nameTo).end();
        for (int i = 0; i < this.shape.size(); ++i) {
            xMLPrintWriter.startTAG("onepoint");
            Point point = (Point)this.shape.get(i);
            xMLPrintWriter.attr("px", point.getX());
            xMLPrintWriter.attr("py", point.getY());
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        MapShapeValue mapShapeValue = (MapShapeValue)super.clone();
        return mapShapeValue;
    }

    public JSONObject toJSONObject(ColorSelect4Shape colorSelect4Shape, String string) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        GeneralPath generalPath = this.createPathWithPoints(string, colorSelect4Shape);
        jSONObject.put("path", (Object)ChartBaseUtils.generalPath2JS(generalPath));
        jSONObject.put("name", (Object)this.name);
        jSONObject.put("markerType", this.markType);
        jSONObject.put(this.nameTo, (Object)this.nameTo);
        return jSONObject;
    }

    private GeneralPath createPathWithPoints(String string, ColorSelect4Shape colorSelect4Shape) {
        Point[] pointArray = this.getShape();
        GeneralPath generalPath = new GeneralPath();
        if (this.getMarkType() == 0) {
            for (int i = 0; i < pointArray.length; ++i) {
                generalPath.moveTo((float)pointArray[i].getX(), (float)pointArray[i].getY());
                double d = 5.0;
                double d2 = pointArray[i].getX() - d;
                double d3 = pointArray[i].getY() - d;
                generalPath.append(new Arc2D.Double(d2, d3, d * 2.0, d * 2.0, 0.0, 360.0, 0), false);
            }
        } else {
            for (int i = 0; i < pointArray.length; ++i) {
                colorSelect4Shape.makesureClickPoint(pointArray[i].getX(), pointArray[i].getY());
                GeneralPath generalPath2 = colorSelect4Shape.getSelectedPath();
                generalPath.append(generalPath2, false);
            }
        }
        return generalPath;
    }
}

