/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.CoreDecimalFormat;
import com.fr.base.Formula;
import com.fr.chart.base.AreaColor;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.AxisHelper;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapHotAreaColor
implements XMLable {
    private static final long serialVersionUID = 1532455023184207954L;
    public static final String XML_TAG = "MapHotAreaColor";
    private static final double TEN = 10.0;
    private static final double FOUR = 4.0;
    private static final double BASEVALUE = 0.4;
    public static final int AUTO = 0;
    public static final int CUSTOM = 1;
    private double maxValue = 100.0;
    private double minValue = 0.0;
    private Color mainColor = new Color(36, 167, 255);
    private List areaColorList = new ArrayList();
    private int areaNumber = 5;
    private int useType = 0;

    public void refreshMinMax(double d, double d2) {
        if (this.useType == 0) {
            this.minValue = d;
            this.maxValue = d2;
        } else {
            int n;
            this.areaNumber = n = this.areaColorList.size();
            for (int i = 0; i < n; ++i) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i);
                this.minValue = Math.min(this.minValue, areaColor.getMinNum());
                this.maxValue = Math.max(this.maxValue, areaColor.getMaxNum());
            }
        }
    }

    public int getAreaNumber() {
        return this.areaNumber;
    }

    public void clearColor() {
        this.areaColorList.clear();
    }

    public void addAreaColor(AreaColor areaColor) {
        this.areaColorList.add(areaColor);
    }

    public Color[] initColor() {
        if (this.useType == 0) {
            this.clearColor();
            return MapHotAreaColor.getColorArrayFromMinAndMax(this.getMainColor(), this.areaNumber, this.minValue, this.maxValue, this.areaColorList);
        }
        int n = this.areaColorList.size();
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i);
            colorArray[i] = areaColor.getAreaColor();
        }
        return colorArray;
    }

    public Formula[] initValues() {
        if (this.useType == 1) {
            int n = this.areaColorList.size();
            Formula[] formulaArray = new Formula[n + 1];
            for (int i = 0; i < n; ++i) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i);
                formulaArray[i] = areaColor.getMin();
                formulaArray[i + 1] = areaColor.getMax();
            }
            return formulaArray;
        }
        return new Formula[0];
    }

    public void setUseType(int n) {
        this.useType = n;
    }

    public int getUseType() {
        return this.useType;
    }

    public void setMainColor(Color color) {
        this.mainColor = color;
    }

    public Color getMainColor() {
        return this.mainColor;
    }

    public List getAreaColorList() {
        return this.areaColorList;
    }

    public void setAreaNumber(int n) {
        this.areaNumber = n;
    }

    private boolean isUseChartFormat() {
        boolean bl = true;
        for (int i = 0; i < this.areaColorList.size(); ++i) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i);
            if (areaColor.getMinNum() == (double)((int)areaColor.getMinNum()) && areaColor.getMaxNum() == (double)((int)areaColor.getMaxNum())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public Color getColorByIndex(int n) {
        if (n < this.areaColorList.size()) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(n);
            return areaColor.getAreaColor();
        }
        return Color.white;
    }

    public String[] getNumberLabels() {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        String[] stringArray = new String[this.areaColorList.size() + 1];
        for (int i = 0; i < this.areaColorList.size(); ++i) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i);
            stringArray[i] = decimalFormat.format(Math.max(areaColor.getMaxNum(), areaColor.getMinNum()));
            if (i != this.areaColorList.size() - 1) continue;
            stringArray[i + 1] = decimalFormat.format(Math.min(areaColor.getMaxNum(), areaColor.getMinNum()));
        }
        return stringArray;
    }

    public String getMaxLabelWithIndex(int n) {
        CoreDecimalFormat coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat(), "#.##");
        if (this.areaColorList != null && n < this.areaColorList.size()) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(n);
            return coreDecimalFormat.format(areaColor.getMaxNum());
        }
        return "0";
    }

    public String getMinLabelWithIndex(int n) {
        CoreDecimalFormat coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat(), "#.##");
        if (this.areaColorList != null && n < this.areaColorList.size()) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(n);
            return coreDecimalFormat.format(areaColor.getMinNum());
        }
        return "0";
    }

    public String getLabelWithInt(int n) {
        AreaColor areaColor = (AreaColor)this.areaColorList.get(n);
        boolean bl = this.isUseChartFormat();
        String string = "";
        String string2 = "";
        double d = Math.min(areaColor.getMaxNum(), areaColor.getMinNum());
        double d2 = Math.max(areaColor.getMaxNum(), areaColor.getMinNum());
        if (bl) {
            string = ChartBaseUtils.generalFormat(d);
            string2 = ChartBaseUtils.generalFormat(d2);
        } else {
            CoreDecimalFormat coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat(), "#.##");
            string = coreDecimalFormat.format(d);
            string2 = coreDecimalFormat.format(d2);
        }
        return string + "--" + string2;
    }

    public int getColorsIndex(double d) {
        int n = 0;
        for (int i = 0; i < this.areaColorList.size(); ++i) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i);
            double d2 = Math.min(areaColor.getMinNum(), areaColor.getMaxNum());
            double d3 = Math.max(areaColor.getMinNum(), areaColor.getMaxNum());
            if (!(d2 <= d) || !(d <= d3)) continue;
            n = i;
            break;
        }
        return n;
    }

    public Color getColorWithValue(double d) {
        Color color = Color.white;
        int n = this.areaColorList.size();
        for (int i = 0; i < n; ++i) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i);
            double d2 = Math.min(areaColor.getMinNum(), areaColor.getMaxNum());
            double d3 = Math.max(areaColor.getMinNum(), areaColor.getMaxNum());
            if (!(d2 <= d) || !(d <= d3)) continue;
            color = areaColor.getAreaColor();
            break;
        }
        return color;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        Object[] objectArray = new Object[this.areaColorList.size()];
        for (int i = 0; i < this.areaColorList.size(); ++i) {
            objectArray[i] = ((AreaColor)this.areaColorList.get(i)).toJSONObject();
        }
        jSONObject.put("areaColors", (Object)objectArray);
        return jSONObject;
    }

    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        for (int i = 0; i < this.areaColorList.size(); ++i) {
            ((AreaColor)this.areaColorList.get(i)).dependence(calculatorProvider, list);
        }
    }

    public void dealFormula(Calculator calculator) {
        for (int i = 0; i < this.areaColorList.size(); ++i) {
            ((AreaColor)this.areaColorList.get(i)).dealFormula(calculator);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals((String)"MC_Attr", (String)string)) {
                this.minValue = xMLableReader.getAttrAsDouble("minValue", 0.0);
                this.maxValue = xMLableReader.getAttrAsDouble("maxValue", 100.0);
                this.useType = xMLableReader.getAttrAsInt("useType", 0);
                this.areaNumber = xMLableReader.getAttrAsInt("areaNumber", 5);
                this.mainColor = xMLableReader.getAttrAsColor("mainColor", null);
            } else if (ComparatorUtils.equals((String)"ColorList", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && ComparatorUtils.equals((String)xMLableReader.getTagName(), (String)"AreaColor")) {
                            MapHotAreaColor.this.addAreaColor((AreaColor)xMLableReader.readXMLObject((XMLReadable)new AreaColor()));
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("MC_Attr").attr("minValue", this.minValue).attr("maxValue", this.maxValue).attr("useType", this.useType).attr("areaNumber", this.areaNumber);
        if (this.mainColor != null) {
            xMLPrintWriter.attr("mainColor", this.mainColor.getRGB());
        }
        xMLPrintWriter.end();
        if (this.areaColorList.size() > 0) {
            xMLPrintWriter.startTAG("ColorList");
            for (int i = 0; i < this.areaColorList.size(); ++i) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i);
                areaColor.writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        MapHotAreaColor mapHotAreaColor = (MapHotAreaColor)super.clone();
        mapHotAreaColor.areaColorList = new ArrayList();
        mapHotAreaColor.clearColor();
        if (!this.areaColorList.isEmpty()) {
            for (int i = 0; i < this.areaColorList.size(); ++i) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i);
                mapHotAreaColor.addAreaColor((AreaColor)areaColor.clone());
            }
        }
        return mapHotAreaColor;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapHotAreaColor)) {
            return false;
        }
        MapHotAreaColor mapHotAreaColor = (MapHotAreaColor)object;
        if (this.areaColorList.size() != mapHotAreaColor.areaColorList.size()) {
            return false;
        }
        int n = this.areaColorList.size();
        for (int i = 0; i < n; ++i) {
            if (ComparatorUtils.equals(this.areaColorList.get(i), mapHotAreaColor.getAreaColorList().get(i))) continue;
            return false;
        }
        return this.useType == mapHotAreaColor.useType && this.areaNumber == mapHotAreaColor.areaNumber && ComparatorUtils.equals((Object)this.mainColor, (Object)mapHotAreaColor.mainColor);
    }

    public static Color[] getColorArrayFromMinAndMax(Color color, int n, double d, double d2, List<AreaColor> list) {
        BigDecimal bigDecimal;
        Color[] colorArray = ChartBaseUtils.createColorsWithHSB(color, n);
        double d3 = d;
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2 - d));
        double d4 = AxisHelper.getMoveInt(bigDecimal2);
        if (d4 < 0.0) {
            BigDecimal bigDecimal3 = new BigDecimal(Double.toString(d3));
            bigDecimal = new BigDecimal(Math.pow(10.0, 1.0 - d4));
            bigDecimal3 = bigDecimal3.multiply(bigDecimal);
            bigDecimal3 = new BigDecimal(Math.floor(bigDecimal3.doubleValue()));
            bigDecimal3 = bigDecimal3.divide(bigDecimal);
            d3 = bigDecimal3.doubleValue();
        } else {
            int n2 = (int)Math.pow(10.0, d4);
            d3 = Math.floor(d / (double)n2) * (double)n2;
        }
        BigDecimal bigDecimal4 = new BigDecimal(Double.toString((double)n / 10.0 * Math.pow(10.0, d4)));
        bigDecimal = new BigDecimal(Double.toString(0.0));
        while (bigDecimal.doubleValue() < bigDecimal2.doubleValue()) {
            bigDecimal = bigDecimal.add(bigDecimal4);
        }
        double d5 = bigDecimal.doubleValue() / (double)n;
        while (d3 + d5 * (double)n < d2) {
            bigDecimal = bigDecimal.add(bigDecimal4);
            d5 = bigDecimal.doubleValue() / (double)n;
        }
        bigDecimal = bigDecimal.divide(new BigDecimal(n));
        for (int i = 0; i < n; ++i) {
            AreaColor areaColor = new AreaColor(d3 + bigDecimal.multiply(new BigDecimal(n - i - 1)).doubleValue(), d3 + bigDecimal.multiply(new BigDecimal(n - i)).doubleValue(), colorArray[i]);
            list.add(i, areaColor);
        }
        return colorArray;
    }
}

