/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.chart.base.ChartComparatorUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Locale;

public class LegendItem
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3537790025233710932L;
    private static final double LABEL_MARKER_GAP = 4.0;
    private Rectangle2D bounds;
    private String label;
    private LineMarkerIcon lineMarkerIcon;
    private Color fontColor = null;
    private boolean isCompositeItem = false;
    private transient boolean drawInCut = false;

    public LegendItem() {
    }

    public LegendItem(String string) {
        this.setLabel(string);
    }

    public void setLineMarkerIcon(LineMarkerIcon lineMarkerIcon) {
        this.lineMarkerIcon = lineMarkerIcon;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public void setDrawInCut(boolean bl) {
        this.drawInCut = bl;
    }

    public boolean isDrawInCut() {
        return this.drawInCut;
    }

    public void setCompositeItem(boolean bl) {
        this.isCompositeItem = bl;
    }

    public boolean isCompositeItem() {
        return this.isCompositeItem;
    }

    public void draw(Graphics graphics, FRFont fRFont, int n) {
        if (this.bounds == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawLineMarkerIcon(graphics2D, fRFont, n);
        this.drawLabel(graphics2D, fRFont, n);
    }

    private void drawLineMarkerIcon(Graphics2D graphics2D, FRFont fRFont, int n) {
        if (this.lineMarkerIcon != null) {
            graphics2D.translate(this.bounds.getX(), this.bounds.getY());
            int n2 = fRFont.getShowSize(n);
            graphics2D.translate(0.0, (this.bounds.getHeight() - (double)n2) / 2.0);
            this.lineMarkerIcon.paint(graphics2D, n2);
            graphics2D.translate(0.0, -(this.bounds.getHeight() - (double)n2) / 2.0);
            graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
        }
    }

    private void drawLabel(Graphics2D graphics2D, FRFont fRFont, int n) {
        if (StringUtils.isNotEmpty((String)this.label)) {
            Font font = graphics2D.getFont();
            Paint paint = graphics2D.getPaint();
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            if (this.fontColor != null) {
                graphics2D.setPaint(this.fontColor);
            } else {
                graphics2D.setPaint(fRFont.getForeground());
            }
            Font font2 = null;
            if (ComparatorUtils.equals((Object)Locale.ENGLISH, (Object)FRContext.getLocale())) {
                font2 = FRFont.getInstance((String)"Dialog", (int)fRFont.getStyle(), (float)fRFont.getSize());
            }
            font2 = fRFont.applyResolutionNP(n);
            graphics2D.setFont(font2);
            FontMetrics fontMetrics = GraphHelper.getFontMetrics((Font)graphics2D.getFont());
            String string = this.label;
            Dimension2D dimension2D = this.prefferedSize(fRFont, n);
            if (dimension2D.getWidth() > this.bounds.getWidth()) {
                if (this.drawInCut) {
                    Shape shape = graphics2D.getClip();
                    graphics2D.clip(this.bounds);
                    GraphHelper.drawString((Graphics)graphics2D, (String)string, (double)(this.bounds.getX() + (double)fRFont.getShowSize(n) + 4.0), (double)(this.bounds.getY() + (this.bounds.getHeight() - (double)fontMetrics.getHeight()) / 2.0 + (double)fontMetrics.getAscent()));
                    graphics2D.setClip(shape);
                } else {
                    string = LegendItem.getTextWhenNotEnoughWidth(string, fRFont.applyResolutionNP(n), this.bounds.getWidth());
                    GraphHelper.drawString((Graphics)graphics2D, (String)string, (double)(this.bounds.getX() + (double)fRFont.getShowSize(n) + 4.0), (double)(this.bounds.getY() + (this.bounds.getHeight() - (double)fontMetrics.getHeight()) / 2.0 + (double)fontMetrics.getAscent()));
                }
            } else {
                GraphHelper.drawString((Graphics)graphics2D, (String)string, (double)(this.bounds.getX() + (double)fRFont.getShowSize(n) + 4.0), (double)(this.bounds.getY() + (this.bounds.getHeight() - (double)fontMetrics.getHeight()) / 2.0 + (double)fontMetrics.getAscent()));
            }
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
            graphics2D.setFont(font);
        }
    }

    public static String getTextWhenNotEnoughWidth(String string, Font font, double d) {
        String string2 = "...";
        if (StringUtils.isEmpty((String)string)) {
            return string2;
        }
        double d2 = LegendItem.getStringWidthWithFont("...", font);
        if (d2 > d) {
            return string2;
        }
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            double d3 = LegendItem.getStringWidthWithFont(string3 + c + string2, font);
            if (d3 > d) break;
            string3 = string3 + c;
        }
        return string3 + string2;
    }

    private static int getStringWidthWithFont(String string, Font font) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)10, (int)10, (int)6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(font);
        return (int)GraphHelper.stringWidth((String)string, (Font)font, (FontRenderContext)graphics2D.getFontRenderContext()) + font.getSize() / 2 + 4;
    }

    public Dimension2D prefferedSize(FRFont fRFont, int n) {
        Font font = GlyphUtils.getFont4StringInSystem(fRFont.applyResolutionNP(n), this.label);
        int n2 = font.getSize();
        int n3 = LegendItem.getStringWidthWithFont(this.label, font) + n2;
        return new Dimension(n3, n2);
    }

    public boolean equals(Object object) {
        return object instanceof LegendItem && ChartComparatorUtils.equals(((LegendItem)object).bounds, this.bounds) && ComparatorUtils.equals((Object)((LegendItem)object).lineMarkerIcon, (Object)this.lineMarkerIcon);
    }

    public Object clone() throws CloneNotSupportedException {
        LegendItem legendItem = new LegendItem();
        if (this.bounds != null) {
            legendItem.bounds = (Rectangle2D)this.bounds.clone();
        }
        if (this.lineMarkerIcon != null) {
            legendItem.lineMarkerIcon = (LineMarkerIcon)this.lineMarkerIcon.clone();
        }
        if (this.label != null) {
            legendItem.label = this.label;
        }
        if (this.fontColor != null) {
            legendItem.fontColor = this.fontColor;
        }
        return legendItem;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("label", (Object)this.label);
        if (this.lineMarkerIcon != null) {
            jSONObject.put("lineMarkerIcon", (Object)this.lineMarkerIcon.toJSONObject(repository));
        }
        if (this.fontColor != null) {
            jSONObject.put("fontColor", (Object)StableUtils.javaColor2JSColorWithAlpha((Color)this.fontColor));
        }
        return jSONObject;
    }
}

