/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.MapHotAreaColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class HeatMapControlBar {
    public static final int BAR_LONG = 26;
    public static final int BAR_SHORT = 13;
    public static final int BAR_GAP = 1;
    private int gap = 5;
    private Rectangle2D bounds;
    private int position;
    private MapHotAreaColor mapHotAreaColor;
    private List areaColorBlock;
    private TextAttr textAttr;
    private int resolution;

    public HeatMapControlBar(Rectangle2D rectangle2D, int n, MapHotAreaColor mapHotAreaColor, int n2, TextAttr textAttr) {
        this.bounds = rectangle2D;
        this.position = n;
        this.mapHotAreaColor = mapHotAreaColor;
        this.areaColorBlock = new ArrayList();
        this.textAttr = textAttr;
        this.resolution = n2;
        this.layoutAreaColorBlock();
    }

    private void layoutAreaColorBlock() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.mapHotAreaColor.getAreaNumber();
        int n = 26;
        int n2 = 13;
        String string = this.mapHotAreaColor.getMaxLabelWithIndex(0);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.textAttr, this.resolution);
        double d4 = dimension2D.getWidth();
        double d5 = dimension2D.getHeight();
        double d6 = this.bounds.getX();
        double d7 = this.bounds.getY();
        switch (this.position) {
            case 2: {
                d = d6 + d4 + (double)this.gap;
                d2 = d7 + d5 / 2.0;
                break;
            }
            case 4: {
                d = d6;
                d2 = d7 + d5 / 2.0;
                break;
            }
            default: {
                d = d6 + d4 / 2.0;
                d2 = d7 + d5 + (double)this.gap;
            }
        }
        if (this.isInTopOrBottom()) {
            int n3 = 0;
            while ((double)n3 < d3) {
                double d8 = d + (double)(n * n3) + (double)n3;
                this.areaColorBlock.add(new Rectangle2D.Double(d8, d2, n, n2));
                ++n3;
            }
        } else {
            int n4 = 0;
            while ((double)n4 < d3) {
                double d9 = d2 + (double)(n * n4) + (double)n4;
                this.areaColorBlock.add(new Rectangle2D.Double(d, d9, n2, n));
                ++n4;
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n) {
        if (this.isInTopOrBottom()) {
            this.drawTopOrBottom(graphics2D, n);
        } else {
            this.drawLeftOrRight(graphics2D, n);
        }
    }

    private void drawTopOrBottom(Graphics2D graphics2D, int n) {
        this.drawColorBlocks(graphics2D, n);
        double d = 53.0;
        String[] stringArray = this.mapHotAreaColor.getNumberLabels();
        String string = this.mapHotAreaColor.getMaxLabelWithIndex(0);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.textAttr, n);
        double d2 = dimension2D.getHeight();
        double d3 = 27.0;
        double d4 = this.bounds.getX();
        double d5 = this.bounds.getY();
        double d6 = this.bounds.getY() + d2 + 5.0 + 13.0 + 5.0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = this.getFinalDrawLabel(stringArray[i], d, n);
            double d7 = i % 2 == 0 ? d5 : d6;
            this.drawLabel(graphics2D, string2, d4, d7);
            d4 += d3;
        }
    }

    private void drawLeftOrRight(Graphics2D graphics2D, int n) {
        this.drawColorBlocks(graphics2D, n);
        double d = this.bounds.getWidth() - 13.0 - 5.0;
        double d2 = this.bounds.getY();
        double d3 = this.position == 4 ? this.bounds.getX() + 13.0 + 5.0 : this.bounds.getX();
        String[] stringArray = this.mapHotAreaColor.getNumberLabels();
        double d4 = 27.0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.getFinalDrawLabel(stringArray[i], d, n);
            this.drawLabel(graphics2D, string, d3, d2);
            d2 += d4;
        }
    }

    private void drawColorBlocks(Graphics2D graphics2D, int n) {
        for (int i = 0; i < this.areaColorBlock.size(); ++i) {
            Color color = this.mapHotAreaColor.getColorByIndex(i);
            graphics2D.setColor(color);
            Rectangle2D rectangle2D = (Rectangle2D)this.areaColorBlock.get(i);
            graphics2D.fillRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        graphics2D.setColor(Color.black);
    }

    private String getFinalDrawLabel(String string, double d, int n) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.textAttr, n);
        if (dimension2D.getWidth() > d) {
            return LegendItem.getTextWhenNotEnoughWidth(string, (Font)this.textAttr.getFRFont(), d);
        }
        return string;
    }

    private void drawLabel(Graphics2D graphics2D, String string, double d, double d2) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.textAttr, this.resolution);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
        GlyphUtils.drawStrings(graphics2D, string, this.textAttr, double_, this.resolution);
    }

    private boolean isInTopOrBottom() {
        return this.position == 1 || this.position == 3;
    }
}

